// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opensearchservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInboundConnection = "AcceptInboundConnection"

// AcceptInboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInboundConnection for more information on using the AcceptInboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptInboundConnectionRequest method.
//	req, resp := client.AcceptInboundConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AcceptInboundConnection
func (c *OpenSearchService) AcceptInboundConnectionRequest(input *AcceptInboundConnectionInput) (req *request.Request, output *AcceptInboundConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptInboundConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/accept",
	}

	if input == nil {
		input = &AcceptInboundConnectionInput{}
	}

	output = &AcceptInboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptInboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the destination Amazon OpenSearch Service domain owner to accept an
// inbound cross-cluster search connection request. For more information, see
// Cross-cluster search for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AcceptInboundConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AcceptInboundConnection
func (c *OpenSearchService) AcceptInboundConnection(input *AcceptInboundConnectionInput) (*AcceptInboundConnectionOutput, error) {
	req, out := c.AcceptInboundConnectionRequest(input)
	return out, req.Send()
}

// AcceptInboundConnectionWithContext is the same as AcceptInboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AcceptInboundConnectionWithContext(ctx aws.Context, input *AcceptInboundConnectionInput, opts ...request.Option) (*AcceptInboundConnectionOutput, error) {
	req, out := c.AcceptInboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddDataSource = "AddDataSource"

// AddDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the AddDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddDataSource for more information on using the AddDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddDataSourceRequest method.
//	req, resp := client.AddDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AddDataSource
func (c *OpenSearchService) AddDataSourceRequest(input *AddDataSourceInput) (req *request.Request, output *AddDataSourceOutput) {
	op := &request.Operation{
		Name:       opAddDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/dataSource",
	}

	if input == nil {
		input = &AddDataSourceInput{}
	}

	output = &AddDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddDataSource API operation for Amazon OpenSearch Service.
//
// Creates a new direct-query data source to the specified domain. For more
// information, see Creating Amazon OpenSearch Service data source integrations
// with Amazon S3 (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AddDataSource for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - DependencyFailureException
//     An exception for when a failure in one of the dependencies results in the
//     service being unable to fetch details about the resource.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AddDataSource
func (c *OpenSearchService) AddDataSource(input *AddDataSourceInput) (*AddDataSourceOutput, error) {
	req, out := c.AddDataSourceRequest(input)
	return out, req.Send()
}

// AddDataSourceWithContext is the same as AddDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See AddDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AddDataSourceWithContext(ctx aws.Context, input *AddDataSourceInput, opts ...request.Option) (*AddDataSourceOutput, error) {
	req, out := c.AddDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddTagsRequest method.
//	req, resp := client.AddTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AddTags
func (c *OpenSearchService) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/tags",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon OpenSearch Service.
//
// Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a
// set of case-sensitive key-value pairs. A domain can have up to 10 tags. For
// more information, see Tagging Amazon OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AddTags for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AddTags
func (c *OpenSearchService) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePackage = "AssociatePackage"

// AssociatePackageRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePackage for more information on using the AssociatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePackageRequest method.
//	req, resp := client.AssociatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AssociatePackage
func (c *OpenSearchService) AssociatePackageRequest(input *AssociatePackageInput) (req *request.Request, output *AssociatePackageOutput) {
	op := &request.Operation{
		Name:       opAssociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/associate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &AssociatePackageInput{}
	}

	output = &AssociatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePackage API operation for Amazon OpenSearch Service.
//
// Associates a package with an Amazon OpenSearch Service domain. For more information,
// see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AssociatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AssociatePackage
func (c *OpenSearchService) AssociatePackage(input *AssociatePackageInput) (*AssociatePackageOutput, error) {
	req, out := c.AssociatePackageRequest(input)
	return out, req.Send()
}

// AssociatePackageWithContext is the same as AssociatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AssociatePackageWithContext(ctx aws.Context, input *AssociatePackageInput, opts ...request.Option) (*AssociatePackageOutput, error) {
	req, out := c.AssociatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeVpcEndpointAccess = "AuthorizeVpcEndpointAccess"

// AuthorizeVpcEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeVpcEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeVpcEndpointAccess for more information on using the AuthorizeVpcEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AuthorizeVpcEndpointAccessRequest method.
//	req, resp := client.AuthorizeVpcEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AuthorizeVpcEndpointAccess
func (c *OpenSearchService) AuthorizeVpcEndpointAccessRequest(input *AuthorizeVpcEndpointAccessInput) (req *request.Request, output *AuthorizeVpcEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opAuthorizeVpcEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/authorizeVpcEndpointAccess",
	}

	if input == nil {
		input = &AuthorizeVpcEndpointAccessInput{}
	}

	output = &AuthorizeVpcEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeVpcEndpointAccess API operation for Amazon OpenSearch Service.
//
// Provides access to an Amazon OpenSearch Service domain through the use of
// an interface VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AuthorizeVpcEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AuthorizeVpcEndpointAccess
func (c *OpenSearchService) AuthorizeVpcEndpointAccess(input *AuthorizeVpcEndpointAccessInput) (*AuthorizeVpcEndpointAccessOutput, error) {
	req, out := c.AuthorizeVpcEndpointAccessRequest(input)
	return out, req.Send()
}

// AuthorizeVpcEndpointAccessWithContext is the same as AuthorizeVpcEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeVpcEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AuthorizeVpcEndpointAccessWithContext(ctx aws.Context, input *AuthorizeVpcEndpointAccessInput, opts ...request.Option) (*AuthorizeVpcEndpointAccessOutput, error) {
	req, out := c.AuthorizeVpcEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelServiceSoftwareUpdate = "CancelServiceSoftwareUpdate"

// CancelServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the CancelServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelServiceSoftwareUpdate for more information on using the CancelServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelServiceSoftwareUpdateRequest method.
//	req, resp := client.CancelServiceSoftwareUpdateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CancelServiceSoftwareUpdate
func (c *OpenSearchService) CancelServiceSoftwareUpdateRequest(input *CancelServiceSoftwareUpdateInput) (req *request.Request, output *CancelServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opCancelServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel",
	}

	if input == nil {
		input = &CancelServiceSoftwareUpdateInput{}
	}

	output = &CancelServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelServiceSoftwareUpdate API operation for Amazon OpenSearch Service.
//
// Cancels a scheduled service software update for an Amazon OpenSearch Service
// domain. You can only perform this operation before the AutomatedUpdateDate
// and when the domain's UpdateStatus is PENDING_UPDATE. For more information,
// see Service software updates in Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CancelServiceSoftwareUpdate for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CancelServiceSoftwareUpdate
func (c *OpenSearchService) CancelServiceSoftwareUpdate(input *CancelServiceSoftwareUpdateInput) (*CancelServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// CancelServiceSoftwareUpdateWithContext is the same as CancelServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See CancelServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CancelServiceSoftwareUpdateWithContext(ctx aws.Context, input *CancelServiceSoftwareUpdateInput, opts ...request.Option) (*CancelServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDomainRequest method.
//	req, resp := client.CreateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateDomain
func (c *OpenSearchService) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon OpenSearch Service.
//
// Creates an Amazon OpenSearch Service domain. For more information, see Creating
// and managing Amazon OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - InvalidTypeException
//     An exception for trying to create or access a sub-resource that's either
//     invalid or not supported.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateDomain
func (c *OpenSearchService) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOutboundConnection = "CreateOutboundConnection"

// CreateOutboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateOutboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOutboundConnection for more information on using the CreateOutboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOutboundConnectionRequest method.
//	req, resp := client.CreateOutboundConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateOutboundConnection
func (c *OpenSearchService) CreateOutboundConnectionRequest(input *CreateOutboundConnectionInput) (req *request.Request, output *CreateOutboundConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateOutboundConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/cc/outboundConnection",
	}

	if input == nil {
		input = &CreateOutboundConnectionInput{}
	}

	output = &CreateOutboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOutboundConnection API operation for Amazon OpenSearch Service.
//
// Creates a new cross-cluster search connection from a source Amazon OpenSearch
// Service domain to a destination domain. For more information, see Cross-cluster
// search for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreateOutboundConnection for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateOutboundConnection
func (c *OpenSearchService) CreateOutboundConnection(input *CreateOutboundConnectionInput) (*CreateOutboundConnectionOutput, error) {
	req, out := c.CreateOutboundConnectionRequest(input)
	return out, req.Send()
}

// CreateOutboundConnectionWithContext is the same as CreateOutboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOutboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreateOutboundConnectionWithContext(ctx aws.Context, input *CreateOutboundConnectionInput, opts ...request.Option) (*CreateOutboundConnectionOutput, error) {
	req, out := c.CreateOutboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackage = "CreatePackage"

// CreatePackageRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackage for more information on using the CreatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePackageRequest method.
//	req, resp := client.CreatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreatePackage
func (c *OpenSearchService) CreatePackageRequest(input *CreatePackageInput) (req *request.Request, output *CreatePackageOutput) {
	op := &request.Operation{
		Name:       opCreatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages",
	}

	if input == nil {
		input = &CreatePackageInput{}
	}

	output = &CreatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackage API operation for Amazon OpenSearch Service.
//
// Creates a package for use with Amazon OpenSearch Service domains. For more
// information, see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - InvalidTypeException
//     An exception for trying to create or access a sub-resource that's either
//     invalid or not supported.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreatePackage
func (c *OpenSearchService) CreatePackage(input *CreatePackageInput) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	return out, req.Send()
}

// CreatePackageWithContext is the same as CreatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreatePackageWithContext(ctx aws.Context, input *CreatePackageInput, opts ...request.Option) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpoint = "CreateVpcEndpoint"

// CreateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpoint for more information on using the CreateVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcEndpointRequest method.
//	req, resp := client.CreateVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateVpcEndpoint
func (c *OpenSearchService) CreateVpcEndpointRequest(input *CreateVpcEndpointInput) (req *request.Request, output *CreateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/vpcEndpoints",
	}

	if input == nil {
		input = &CreateVpcEndpointInput{}
	}

	output = &CreateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpoint API operation for Amazon OpenSearch Service.
//
// Creates an Amazon OpenSearch Service-managed VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreateVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateVpcEndpoint
func (c *OpenSearchService) CreateVpcEndpoint(input *CreateVpcEndpointInput) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointWithContext is the same as CreateVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreateVpcEndpointWithContext(ctx aws.Context, input *CreateVpcEndpointInput, opts ...request.Option) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteDataSource
func (c *OpenSearchService) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/dataSource/{DataSourceName}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon OpenSearch Service.
//
// Deletes a direct-query data source. For more information, see Deleting an
// Amazon OpenSearch Service data source with Amazon S3 (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-delete.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - DependencyFailureException
//     An exception for when a failure in one of the dependencies results in the
//     service being unable to fetch details about the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteDataSource
func (c *OpenSearchService) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainRequest method.
//	req, resp := client.DeleteDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteDomain
func (c *OpenSearchService) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon OpenSearch Service.
//
// Deletes an Amazon OpenSearch Service domain and all of its data. You can't
// recover a domain after you delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteDomain
func (c *OpenSearchService) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInboundConnection = "DeleteInboundConnection"

// DeleteInboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInboundConnection for more information on using the DeleteInboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInboundConnectionRequest method.
//	req, resp := client.DeleteInboundConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteInboundConnection
func (c *OpenSearchService) DeleteInboundConnectionRequest(input *DeleteInboundConnectionInput) (req *request.Request, output *DeleteInboundConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteInboundConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteInboundConnectionInput{}
	}

	output = &DeleteInboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the destination Amazon OpenSearch Service domain owner to delete an
// existing inbound cross-cluster search connection. For more information, see
// Cross-cluster search for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteInboundConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteInboundConnection
func (c *OpenSearchService) DeleteInboundConnection(input *DeleteInboundConnectionInput) (*DeleteInboundConnectionOutput, error) {
	req, out := c.DeleteInboundConnectionRequest(input)
	return out, req.Send()
}

// DeleteInboundConnectionWithContext is the same as DeleteInboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteInboundConnectionWithContext(ctx aws.Context, input *DeleteInboundConnectionInput, opts ...request.Option) (*DeleteInboundConnectionOutput, error) {
	req, out := c.DeleteInboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOutboundConnection = "DeleteOutboundConnection"

// DeleteOutboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOutboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOutboundConnection for more information on using the DeleteOutboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOutboundConnectionRequest method.
//	req, resp := client.DeleteOutboundConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteOutboundConnection
func (c *OpenSearchService) DeleteOutboundConnectionRequest(input *DeleteOutboundConnectionInput) (req *request.Request, output *DeleteOutboundConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteOutboundConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/cc/outboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteOutboundConnectionInput{}
	}

	output = &DeleteOutboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOutboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the source Amazon OpenSearch Service domain owner to delete an existing
// outbound cross-cluster search connection. For more information, see Cross-cluster
// search for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteOutboundConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteOutboundConnection
func (c *OpenSearchService) DeleteOutboundConnection(input *DeleteOutboundConnectionInput) (*DeleteOutboundConnectionOutput, error) {
	req, out := c.DeleteOutboundConnectionRequest(input)
	return out, req.Send()
}

// DeleteOutboundConnectionWithContext is the same as DeleteOutboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOutboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteOutboundConnectionWithContext(ctx aws.Context, input *DeleteOutboundConnectionInput, opts ...request.Option) (*DeleteOutboundConnectionOutput, error) {
	req, out := c.DeleteOutboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackage = "DeletePackage"

// DeletePackageRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackage for more information on using the DeletePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePackageRequest method.
//	req, resp := client.DeletePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeletePackage
func (c *OpenSearchService) DeletePackageRequest(input *DeletePackageInput) (req *request.Request, output *DeletePackageOutput) {
	op := &request.Operation{
		Name:       opDeletePackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/packages/{PackageID}",
	}

	if input == nil {
		input = &DeletePackageInput{}
	}

	output = &DeletePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePackage API operation for Amazon OpenSearch Service.
//
// Deletes an Amazon OpenSearch Service package. For more information, see Custom
// packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeletePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeletePackage
func (c *OpenSearchService) DeletePackage(input *DeletePackageInput) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	return out, req.Send()
}

// DeletePackageWithContext is the same as DeletePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeletePackageWithContext(ctx aws.Context, input *DeletePackageInput, opts ...request.Option) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpoint = "DeleteVpcEndpoint"

// DeleteVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpoint for more information on using the DeleteVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcEndpointRequest method.
//	req, resp := client.DeleteVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteVpcEndpoint
func (c *OpenSearchService) DeleteVpcEndpointRequest(input *DeleteVpcEndpointInput) (req *request.Request, output *DeleteVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/vpcEndpoints/{VpcEndpointId}",
	}

	if input == nil {
		input = &DeleteVpcEndpointInput{}
	}

	output = &DeleteVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpoint API operation for Amazon OpenSearch Service.
//
// Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteVpcEndpoint
func (c *OpenSearchService) DeleteVpcEndpoint(input *DeleteVpcEndpointInput) (*DeleteVpcEndpointOutput, error) {
	req, out := c.DeleteVpcEndpointRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointWithContext is the same as DeleteVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteVpcEndpointWithContext(ctx aws.Context, input *DeleteVpcEndpointInput, opts ...request.Option) (*DeleteVpcEndpointOutput, error) {
	req, out := c.DeleteVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainRequest method.
//	req, resp := client.DescribeDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomain
func (c *OpenSearchService) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon OpenSearch Service.
//
// Describes the domain configuration for the specified Amazon OpenSearch Service
// domain, including the domain ID, domain service endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomain
func (c *OpenSearchService) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainAutoTunes = "DescribeDomainAutoTunes"

// DescribeDomainAutoTunesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainAutoTunes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainAutoTunes for more information on using the DescribeDomainAutoTunes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainAutoTunesRequest method.
//	req, resp := client.DescribeDomainAutoTunesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainAutoTunes
func (c *OpenSearchService) DescribeDomainAutoTunesRequest(input *DescribeDomainAutoTunesInput) (req *request.Request, output *DescribeDomainAutoTunesOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainAutoTunes,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/autoTunes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDomainAutoTunesInput{}
	}

	output = &DescribeDomainAutoTunesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainAutoTunes API operation for Amazon OpenSearch Service.
//
// Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch
// Service domain. For more information, see Auto-Tune for Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainAutoTunes for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainAutoTunes
func (c *OpenSearchService) DescribeDomainAutoTunes(input *DescribeDomainAutoTunesInput) (*DescribeDomainAutoTunesOutput, error) {
	req, out := c.DescribeDomainAutoTunesRequest(input)
	return out, req.Send()
}

// DescribeDomainAutoTunesWithContext is the same as DescribeDomainAutoTunes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainAutoTunes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainAutoTunesWithContext(ctx aws.Context, input *DescribeDomainAutoTunesInput, opts ...request.Option) (*DescribeDomainAutoTunesOutput, error) {
	req, out := c.DescribeDomainAutoTunesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDomainAutoTunesPages iterates over the pages of a DescribeDomainAutoTunes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDomainAutoTunes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeDomainAutoTunes operation.
//	pageNum := 0
//	err := client.DescribeDomainAutoTunesPages(params,
//	    func(page *opensearchservice.DescribeDomainAutoTunesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) DescribeDomainAutoTunesPages(input *DescribeDomainAutoTunesInput, fn func(*DescribeDomainAutoTunesOutput, bool) bool) error {
	return c.DescribeDomainAutoTunesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDomainAutoTunesPagesWithContext same as DescribeDomainAutoTunesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainAutoTunesPagesWithContext(ctx aws.Context, input *DescribeDomainAutoTunesInput, fn func(*DescribeDomainAutoTunesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDomainAutoTunesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDomainAutoTunesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDomainAutoTunesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDomainChangeProgress = "DescribeDomainChangeProgress"

// DescribeDomainChangeProgressRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainChangeProgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainChangeProgress for more information on using the DescribeDomainChangeProgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainChangeProgressRequest method.
//	req, resp := client.DescribeDomainChangeProgressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainChangeProgress
func (c *OpenSearchService) DescribeDomainChangeProgressRequest(input *DescribeDomainChangeProgressInput) (req *request.Request, output *DescribeDomainChangeProgressOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainChangeProgress,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/progress",
	}

	if input == nil {
		input = &DescribeDomainChangeProgressInput{}
	}

	output = &DescribeDomainChangeProgressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainChangeProgress API operation for Amazon OpenSearch Service.
//
// Returns information about the current blue/green deployment happening on
// an Amazon OpenSearch Service domain. For more information, see Making configuration
// changes in Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainChangeProgress for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainChangeProgress
func (c *OpenSearchService) DescribeDomainChangeProgress(input *DescribeDomainChangeProgressInput) (*DescribeDomainChangeProgressOutput, error) {
	req, out := c.DescribeDomainChangeProgressRequest(input)
	return out, req.Send()
}

// DescribeDomainChangeProgressWithContext is the same as DescribeDomainChangeProgress with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainChangeProgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainChangeProgressWithContext(ctx aws.Context, input *DescribeDomainChangeProgressInput, opts ...request.Option) (*DescribeDomainChangeProgressOutput, error) {
	req, out := c.DescribeDomainChangeProgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainConfig = "DescribeDomainConfig"

// DescribeDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainConfig for more information on using the DescribeDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainConfigRequest method.
//	req, resp := client.DescribeDomainConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainConfig
func (c *OpenSearchService) DescribeDomainConfigRequest(input *DescribeDomainConfigInput) (req *request.Request, output *DescribeDomainConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/config",
	}

	if input == nil {
		input = &DescribeDomainConfigInput{}
	}

	output = &DescribeDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainConfig API operation for Amazon OpenSearch Service.
//
// Returns the configuration of an Amazon OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainConfig for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainConfig
func (c *OpenSearchService) DescribeDomainConfig(input *DescribeDomainConfigInput) (*DescribeDomainConfigOutput, error) {
	req, out := c.DescribeDomainConfigRequest(input)
	return out, req.Send()
}

// DescribeDomainConfigWithContext is the same as DescribeDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainConfigWithContext(ctx aws.Context, input *DescribeDomainConfigInput, opts ...request.Option) (*DescribeDomainConfigOutput, error) {
	req, out := c.DescribeDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainHealth = "DescribeDomainHealth"

// DescribeDomainHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainHealth for more information on using the DescribeDomainHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainHealthRequest method.
//	req, resp := client.DescribeDomainHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainHealth
func (c *OpenSearchService) DescribeDomainHealthRequest(input *DescribeDomainHealthInput) (req *request.Request, output *DescribeDomainHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/health",
	}

	if input == nil {
		input = &DescribeDomainHealthInput{}
	}

	output = &DescribeDomainHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainHealth API operation for Amazon OpenSearch Service.
//
// Returns information about domain and node health, the standby Availability
// Zone, number of nodes per Availability Zone, and shard count per node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainHealth for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainHealth
func (c *OpenSearchService) DescribeDomainHealth(input *DescribeDomainHealthInput) (*DescribeDomainHealthOutput, error) {
	req, out := c.DescribeDomainHealthRequest(input)
	return out, req.Send()
}

// DescribeDomainHealthWithContext is the same as DescribeDomainHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainHealthWithContext(ctx aws.Context, input *DescribeDomainHealthInput, opts ...request.Option) (*DescribeDomainHealthOutput, error) {
	req, out := c.DescribeDomainHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainNodes = "DescribeDomainNodes"

// DescribeDomainNodesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainNodes for more information on using the DescribeDomainNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainNodesRequest method.
//	req, resp := client.DescribeDomainNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainNodes
func (c *OpenSearchService) DescribeDomainNodesRequest(input *DescribeDomainNodesInput) (req *request.Request, output *DescribeDomainNodesOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/nodes",
	}

	if input == nil {
		input = &DescribeDomainNodesInput{}
	}

	output = &DescribeDomainNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainNodes API operation for Amazon OpenSearch Service.
//
// Returns information about domain and nodes, including data nodes, master
// nodes, ultrawarm nodes, Availability Zone(s), standby nodes, node configurations,
// and node states.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainNodes for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - DependencyFailureException
//     An exception for when a failure in one of the dependencies results in the
//     service being unable to fetch details about the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainNodes
func (c *OpenSearchService) DescribeDomainNodes(input *DescribeDomainNodesInput) (*DescribeDomainNodesOutput, error) {
	req, out := c.DescribeDomainNodesRequest(input)
	return out, req.Send()
}

// DescribeDomainNodesWithContext is the same as DescribeDomainNodes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainNodesWithContext(ctx aws.Context, input *DescribeDomainNodesInput, opts ...request.Option) (*DescribeDomainNodesOutput, error) {
	req, out := c.DescribeDomainNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomains = "DescribeDomains"

// DescribeDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomains for more information on using the DescribeDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainsRequest method.
//	req, resp := client.DescribeDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomains
func (c *OpenSearchService) DescribeDomainsRequest(input *DescribeDomainsInput) (req *request.Request, output *DescribeDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain-info",
	}

	if input == nil {
		input = &DescribeDomainsInput{}
	}

	output = &DescribeDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomains API operation for Amazon OpenSearch Service.
//
// Returns domain configuration information about the specified Amazon OpenSearch
// Service domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomains for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomains
func (c *OpenSearchService) DescribeDomains(input *DescribeDomainsInput) (*DescribeDomainsOutput, error) {
	req, out := c.DescribeDomainsRequest(input)
	return out, req.Send()
}

// DescribeDomainsWithContext is the same as DescribeDomains with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainsWithContext(ctx aws.Context, input *DescribeDomainsInput, opts ...request.Option) (*DescribeDomainsOutput, error) {
	req, out := c.DescribeDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDryRunProgress = "DescribeDryRunProgress"

// DescribeDryRunProgressRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDryRunProgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDryRunProgress for more information on using the DescribeDryRunProgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDryRunProgressRequest method.
//	req, resp := client.DescribeDryRunProgressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDryRunProgress
func (c *OpenSearchService) DescribeDryRunProgressRequest(input *DescribeDryRunProgressInput) (req *request.Request, output *DescribeDryRunProgressOutput) {
	op := &request.Operation{
		Name:       opDescribeDryRunProgress,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/dryRun",
	}

	if input == nil {
		input = &DescribeDryRunProgressInput{}
	}

	output = &DescribeDryRunProgressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDryRunProgress API operation for Amazon OpenSearch Service.
//
// Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch
// Service domain. For more information, see Determining whether a change will
// cause a blue/green deployment (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDryRunProgress for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDryRunProgress
func (c *OpenSearchService) DescribeDryRunProgress(input *DescribeDryRunProgressInput) (*DescribeDryRunProgressOutput, error) {
	req, out := c.DescribeDryRunProgressRequest(input)
	return out, req.Send()
}

// DescribeDryRunProgressWithContext is the same as DescribeDryRunProgress with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDryRunProgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDryRunProgressWithContext(ctx aws.Context, input *DescribeDryRunProgressInput, opts ...request.Option) (*DescribeDryRunProgressOutput, error) {
	req, out := c.DescribeDryRunProgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInboundConnections = "DescribeInboundConnections"

// DescribeInboundConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInboundConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInboundConnections for more information on using the DescribeInboundConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInboundConnectionsRequest method.
//	req, resp := client.DescribeInboundConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInboundConnections
func (c *OpenSearchService) DescribeInboundConnectionsRequest(input *DescribeInboundConnectionsInput) (req *request.Request, output *DescribeInboundConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeInboundConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInboundConnectionsInput{}
	}

	output = &DescribeInboundConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInboundConnections API operation for Amazon OpenSearch Service.
//
// Lists all the inbound cross-cluster search connections for a destination
// (remote) Amazon OpenSearch Service domain. For more information, see Cross-cluster
// search for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeInboundConnections for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPaginationTokenException
//     Request processing failed because you provided an invalid pagination token.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInboundConnections
func (c *OpenSearchService) DescribeInboundConnections(input *DescribeInboundConnectionsInput) (*DescribeInboundConnectionsOutput, error) {
	req, out := c.DescribeInboundConnectionsRequest(input)
	return out, req.Send()
}

// DescribeInboundConnectionsWithContext is the same as DescribeInboundConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInboundConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeInboundConnectionsWithContext(ctx aws.Context, input *DescribeInboundConnectionsInput, opts ...request.Option) (*DescribeInboundConnectionsOutput, error) {
	req, out := c.DescribeInboundConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInboundConnectionsPages iterates over the pages of a DescribeInboundConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInboundConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInboundConnections operation.
//	pageNum := 0
//	err := client.DescribeInboundConnectionsPages(params,
//	    func(page *opensearchservice.DescribeInboundConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) DescribeInboundConnectionsPages(input *DescribeInboundConnectionsInput, fn func(*DescribeInboundConnectionsOutput, bool) bool) error {
	return c.DescribeInboundConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInboundConnectionsPagesWithContext same as DescribeInboundConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeInboundConnectionsPagesWithContext(ctx aws.Context, input *DescribeInboundConnectionsInput, fn func(*DescribeInboundConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInboundConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInboundConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInboundConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceTypeLimits = "DescribeInstanceTypeLimits"

// DescribeInstanceTypeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceTypeLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceTypeLimits for more information on using the DescribeInstanceTypeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceTypeLimitsRequest method.
//	req, resp := client.DescribeInstanceTypeLimitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInstanceTypeLimits
func (c *OpenSearchService) DescribeInstanceTypeLimitsRequest(input *DescribeInstanceTypeLimitsInput) (req *request.Request, output *DescribeInstanceTypeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceTypeLimits,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/instanceTypeLimits/{EngineVersion}/{InstanceType}",
	}

	if input == nil {
		input = &DescribeInstanceTypeLimitsInput{}
	}

	output = &DescribeInstanceTypeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceTypeLimits API operation for Amazon OpenSearch Service.
//
// Describes the instance count, storage, and master node limits for a given
// OpenSearch or Elasticsearch version and instance type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeInstanceTypeLimits for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - InvalidTypeException
//     An exception for trying to create or access a sub-resource that's either
//     invalid or not supported.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInstanceTypeLimits
func (c *OpenSearchService) DescribeInstanceTypeLimits(input *DescribeInstanceTypeLimitsInput) (*DescribeInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeInstanceTypeLimitsRequest(input)
	return out, req.Send()
}

// DescribeInstanceTypeLimitsWithContext is the same as DescribeInstanceTypeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceTypeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeInstanceTypeLimitsWithContext(ctx aws.Context, input *DescribeInstanceTypeLimitsInput, opts ...request.Option) (*DescribeInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeInstanceTypeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOutboundConnections = "DescribeOutboundConnections"

// DescribeOutboundConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOutboundConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOutboundConnections for more information on using the DescribeOutboundConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOutboundConnectionsRequest method.
//	req, resp := client.DescribeOutboundConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeOutboundConnections
func (c *OpenSearchService) DescribeOutboundConnectionsRequest(input *DescribeOutboundConnectionsInput) (req *request.Request, output *DescribeOutboundConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOutboundConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/cc/outboundConnection/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOutboundConnectionsInput{}
	}

	output = &DescribeOutboundConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOutboundConnections API operation for Amazon OpenSearch Service.
//
// Lists all the outbound cross-cluster connections for a local (source) Amazon
// OpenSearch Service domain. For more information, see Cross-cluster search
// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeOutboundConnections for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPaginationTokenException
//     Request processing failed because you provided an invalid pagination token.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeOutboundConnections
func (c *OpenSearchService) DescribeOutboundConnections(input *DescribeOutboundConnectionsInput) (*DescribeOutboundConnectionsOutput, error) {
	req, out := c.DescribeOutboundConnectionsRequest(input)
	return out, req.Send()
}

// DescribeOutboundConnectionsWithContext is the same as DescribeOutboundConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOutboundConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeOutboundConnectionsWithContext(ctx aws.Context, input *DescribeOutboundConnectionsInput, opts ...request.Option) (*DescribeOutboundConnectionsOutput, error) {
	req, out := c.DescribeOutboundConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOutboundConnectionsPages iterates over the pages of a DescribeOutboundConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOutboundConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeOutboundConnections operation.
//	pageNum := 0
//	err := client.DescribeOutboundConnectionsPages(params,
//	    func(page *opensearchservice.DescribeOutboundConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) DescribeOutboundConnectionsPages(input *DescribeOutboundConnectionsInput, fn func(*DescribeOutboundConnectionsOutput, bool) bool) error {
	return c.DescribeOutboundConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOutboundConnectionsPagesWithContext same as DescribeOutboundConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeOutboundConnectionsPagesWithContext(ctx aws.Context, input *DescribeOutboundConnectionsInput, fn func(*DescribeOutboundConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOutboundConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOutboundConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOutboundConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePackages = "DescribePackages"

// DescribePackagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackages for more information on using the DescribePackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePackagesRequest method.
//	req, resp := client.DescribePackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribePackages
func (c *OpenSearchService) DescribePackagesRequest(input *DescribePackagesInput) (req *request.Request, output *DescribePackagesOutput) {
	op := &request.Operation{
		Name:       opDescribePackages,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/describe",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePackagesInput{}
	}

	output = &DescribePackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackages API operation for Amazon OpenSearch Service.
//
// Describes all packages available to OpenSearch Service. For more information,
// see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribePackages for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribePackages
func (c *OpenSearchService) DescribePackages(input *DescribePackagesInput) (*DescribePackagesOutput, error) {
	req, out := c.DescribePackagesRequest(input)
	return out, req.Send()
}

// DescribePackagesWithContext is the same as DescribePackages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribePackagesWithContext(ctx aws.Context, input *DescribePackagesInput, opts ...request.Option) (*DescribePackagesOutput, error) {
	req, out := c.DescribePackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePackagesPages iterates over the pages of a DescribePackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePackages operation.
//	pageNum := 0
//	err := client.DescribePackagesPages(params,
//	    func(page *opensearchservice.DescribePackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) DescribePackagesPages(input *DescribePackagesInput, fn func(*DescribePackagesOutput, bool) bool) error {
	return c.DescribePackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePackagesPagesWithContext same as DescribePackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribePackagesPagesWithContext(ctx aws.Context, input *DescribePackagesInput, fn func(*DescribePackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedInstanceOfferings = "DescribeReservedInstanceOfferings"

// DescribeReservedInstanceOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstanceOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstanceOfferings for more information on using the DescribeReservedInstanceOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReservedInstanceOfferingsRequest method.
//	req, resp := client.DescribeReservedInstanceOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstanceOfferings
func (c *OpenSearchService) DescribeReservedInstanceOfferingsRequest(input *DescribeReservedInstanceOfferingsInput) (req *request.Request, output *DescribeReservedInstanceOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstanceOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/reservedInstanceOfferings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstanceOfferingsInput{}
	}

	output = &DescribeReservedInstanceOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstanceOfferings API operation for Amazon OpenSearch Service.
//
// Describes the available Amazon OpenSearch Service Reserved Instance offerings
// for a given Region. For more information, see Reserved Instances in Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeReservedInstanceOfferings for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstanceOfferings
func (c *OpenSearchService) DescribeReservedInstanceOfferings(input *DescribeReservedInstanceOfferingsInput) (*DescribeReservedInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedInstanceOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedInstanceOfferingsWithContext is the same as DescribeReservedInstanceOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstanceOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstanceOfferingsWithContext(ctx aws.Context, input *DescribeReservedInstanceOfferingsInput, opts ...request.Option) (*DescribeReservedInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedInstanceOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedInstanceOfferingsPages iterates over the pages of a DescribeReservedInstanceOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstanceOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReservedInstanceOfferings operation.
//	pageNum := 0
//	err := client.DescribeReservedInstanceOfferingsPages(params,
//	    func(page *opensearchservice.DescribeReservedInstanceOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) DescribeReservedInstanceOfferingsPages(input *DescribeReservedInstanceOfferingsInput, fn func(*DescribeReservedInstanceOfferingsOutput, bool) bool) error {
	return c.DescribeReservedInstanceOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedInstanceOfferingsPagesWithContext same as DescribeReservedInstanceOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstanceOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedInstanceOfferingsInput, fn func(*DescribeReservedInstanceOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedInstanceOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedInstanceOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedInstanceOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedInstances = "DescribeReservedInstances"

// DescribeReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstances for more information on using the DescribeReservedInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReservedInstancesRequest method.
//	req, resp := client.DescribeReservedInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstances
func (c *OpenSearchService) DescribeReservedInstancesRequest(input *DescribeReservedInstancesInput) (req *request.Request, output *DescribeReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/reservedInstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesInput{}
	}

	output = &DescribeReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstances API operation for Amazon OpenSearch Service.
//
// Describes the Amazon OpenSearch Service instances that you have reserved
// in a given Region. For more information, see Reserved Instances in Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeReservedInstances for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstances
func (c *OpenSearchService) DescribeReservedInstances(input *DescribeReservedInstancesInput) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedInstancesWithContext is the same as DescribeReservedInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstancesWithContext(ctx aws.Context, input *DescribeReservedInstancesInput, opts ...request.Option) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedInstancesPages iterates over the pages of a DescribeReservedInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeReservedInstances operation.
//	pageNum := 0
//	err := client.DescribeReservedInstancesPages(params,
//	    func(page *opensearchservice.DescribeReservedInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) DescribeReservedInstancesPages(input *DescribeReservedInstancesInput, fn func(*DescribeReservedInstancesOutput, bool) bool) error {
	return c.DescribeReservedInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedInstancesPagesWithContext same as DescribeReservedInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstancesPagesWithContext(ctx aws.Context, input *DescribeReservedInstancesInput, fn func(*DescribeReservedInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeVpcEndpoints = "DescribeVpcEndpoints"

// DescribeVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVpcEndpoints for more information on using the DescribeVpcEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVpcEndpointsRequest method.
//	req, resp := client.DescribeVpcEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeVpcEndpoints
func (c *OpenSearchService) DescribeVpcEndpointsRequest(input *DescribeVpcEndpointsInput) (req *request.Request, output *DescribeVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/vpcEndpoints/describe",
	}

	if input == nil {
		input = &DescribeVpcEndpointsInput{}
	}

	output = &DescribeVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcEndpoints API operation for Amazon OpenSearch Service.
//
// Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeVpcEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeVpcEndpoints
func (c *OpenSearchService) DescribeVpcEndpoints(input *DescribeVpcEndpointsInput) (*DescribeVpcEndpointsOutput, error) {
	req, out := c.DescribeVpcEndpointsRequest(input)
	return out, req.Send()
}

// DescribeVpcEndpointsWithContext is the same as DescribeVpcEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVpcEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeVpcEndpointsWithContext(ctx aws.Context, input *DescribeVpcEndpointsInput, opts ...request.Option) (*DescribeVpcEndpointsOutput, error) {
	req, out := c.DescribeVpcEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDissociatePackage = "DissociatePackage"

// DissociatePackageRequest generates a "aws/request.Request" representing the
// client's request for the DissociatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DissociatePackage for more information on using the DissociatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DissociatePackageRequest method.
//	req, resp := client.DissociatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DissociatePackage
func (c *OpenSearchService) DissociatePackageRequest(input *DissociatePackageInput) (req *request.Request, output *DissociatePackageOutput) {
	op := &request.Operation{
		Name:       opDissociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/dissociate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &DissociatePackageInput{}
	}

	output = &DissociatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DissociatePackage API operation for Amazon OpenSearch Service.
//
// Removes a package from the specified Amazon OpenSearch Service domain. The
// package can't be in use with any OpenSearch index for the dissociation to
// succeed. The package is still available in OpenSearch Service for association
// later. For more information, see Custom packages for Amazon OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DissociatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DissociatePackage
func (c *OpenSearchService) DissociatePackage(input *DissociatePackageInput) (*DissociatePackageOutput, error) {
	req, out := c.DissociatePackageRequest(input)
	return out, req.Send()
}

// DissociatePackageWithContext is the same as DissociatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DissociatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DissociatePackageWithContext(ctx aws.Context, input *DissociatePackageInput, opts ...request.Option) (*DissociatePackageOutput, error) {
	req, out := c.DissociatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCompatibleVersions = "GetCompatibleVersions"

// GetCompatibleVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCompatibleVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCompatibleVersions for more information on using the GetCompatibleVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCompatibleVersionsRequest method.
//	req, resp := client.GetCompatibleVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetCompatibleVersions
func (c *OpenSearchService) GetCompatibleVersionsRequest(input *GetCompatibleVersionsInput) (req *request.Request, output *GetCompatibleVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCompatibleVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/compatibleVersions",
	}

	if input == nil {
		input = &GetCompatibleVersionsInput{}
	}

	output = &GetCompatibleVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCompatibleVersions API operation for Amazon OpenSearch Service.
//
// Returns a map of OpenSearch or Elasticsearch versions and the versions you
// can upgrade them to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetCompatibleVersions for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetCompatibleVersions
func (c *OpenSearchService) GetCompatibleVersions(input *GetCompatibleVersionsInput) (*GetCompatibleVersionsOutput, error) {
	req, out := c.GetCompatibleVersionsRequest(input)
	return out, req.Send()
}

// GetCompatibleVersionsWithContext is the same as GetCompatibleVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCompatibleVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetCompatibleVersionsWithContext(ctx aws.Context, input *GetCompatibleVersionsInput, opts ...request.Option) (*GetCompatibleVersionsOutput, error) {
	req, out := c.GetCompatibleVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSourceRequest method.
//	req, resp := client.GetDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetDataSource
func (c *OpenSearchService) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/dataSource/{DataSourceName}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for Amazon OpenSearch Service.
//
// Retrieves information about a direct query data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetDataSource for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - DependencyFailureException
//     An exception for when a failure in one of the dependencies results in the
//     service being unable to fetch details about the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetDataSource
func (c *OpenSearchService) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainMaintenanceStatus = "GetDomainMaintenanceStatus"

// GetDomainMaintenanceStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainMaintenanceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainMaintenanceStatus for more information on using the GetDomainMaintenanceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDomainMaintenanceStatusRequest method.
//	req, resp := client.GetDomainMaintenanceStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetDomainMaintenanceStatus
func (c *OpenSearchService) GetDomainMaintenanceStatusRequest(input *GetDomainMaintenanceStatusInput) (req *request.Request, output *GetDomainMaintenanceStatusOutput) {
	op := &request.Operation{
		Name:       opGetDomainMaintenanceStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/domainMaintenance",
	}

	if input == nil {
		input = &GetDomainMaintenanceStatusInput{}
	}

	output = &GetDomainMaintenanceStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainMaintenanceStatus API operation for Amazon OpenSearch Service.
//
// The status of the maintenance action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetDomainMaintenanceStatus for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetDomainMaintenanceStatus
func (c *OpenSearchService) GetDomainMaintenanceStatus(input *GetDomainMaintenanceStatusInput) (*GetDomainMaintenanceStatusOutput, error) {
	req, out := c.GetDomainMaintenanceStatusRequest(input)
	return out, req.Send()
}

// GetDomainMaintenanceStatusWithContext is the same as GetDomainMaintenanceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainMaintenanceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetDomainMaintenanceStatusWithContext(ctx aws.Context, input *GetDomainMaintenanceStatusInput, opts ...request.Option) (*GetDomainMaintenanceStatusOutput, error) {
	req, out := c.GetDomainMaintenanceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPackageVersionHistory = "GetPackageVersionHistory"

// GetPackageVersionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetPackageVersionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPackageVersionHistory for more information on using the GetPackageVersionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPackageVersionHistoryRequest method.
//	req, resp := client.GetPackageVersionHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetPackageVersionHistory
func (c *OpenSearchService) GetPackageVersionHistoryRequest(input *GetPackageVersionHistoryInput) (req *request.Request, output *GetPackageVersionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetPackageVersionHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/packages/{PackageID}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPackageVersionHistoryInput{}
	}

	output = &GetPackageVersionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPackageVersionHistory API operation for Amazon OpenSearch Service.
//
// Returns a list of Amazon OpenSearch Service package versions, along with
// their creation time, commit message, and plugin properties (if the package
// is a zip plugin package). For more information, see Custom packages for Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetPackageVersionHistory for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetPackageVersionHistory
func (c *OpenSearchService) GetPackageVersionHistory(input *GetPackageVersionHistoryInput) (*GetPackageVersionHistoryOutput, error) {
	req, out := c.GetPackageVersionHistoryRequest(input)
	return out, req.Send()
}

// GetPackageVersionHistoryWithContext is the same as GetPackageVersionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetPackageVersionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetPackageVersionHistoryWithContext(ctx aws.Context, input *GetPackageVersionHistoryInput, opts ...request.Option) (*GetPackageVersionHistoryOutput, error) {
	req, out := c.GetPackageVersionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPackageVersionHistoryPages iterates over the pages of a GetPackageVersionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPackageVersionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetPackageVersionHistory operation.
//	pageNum := 0
//	err := client.GetPackageVersionHistoryPages(params,
//	    func(page *opensearchservice.GetPackageVersionHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) GetPackageVersionHistoryPages(input *GetPackageVersionHistoryInput, fn func(*GetPackageVersionHistoryOutput, bool) bool) error {
	return c.GetPackageVersionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPackageVersionHistoryPagesWithContext same as GetPackageVersionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetPackageVersionHistoryPagesWithContext(ctx aws.Context, input *GetPackageVersionHistoryInput, fn func(*GetPackageVersionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPackageVersionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPackageVersionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPackageVersionHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUpgradeHistory = "GetUpgradeHistory"

// GetUpgradeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeHistory for more information on using the GetUpgradeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUpgradeHistoryRequest method.
//	req, resp := client.GetUpgradeHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeHistory
func (c *OpenSearchService) GetUpgradeHistoryRequest(input *GetUpgradeHistoryInput) (req *request.Request, output *GetUpgradeHistoryOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/upgradeDomain/{DomainName}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUpgradeHistoryInput{}
	}

	output = &GetUpgradeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeHistory API operation for Amazon OpenSearch Service.
//
// Retrieves the complete history of the last 10 upgrades performed on an Amazon
// OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetUpgradeHistory for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeHistory
func (c *OpenSearchService) GetUpgradeHistory(input *GetUpgradeHistoryInput) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	return out, req.Send()
}

// GetUpgradeHistoryWithContext is the same as GetUpgradeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetUpgradeHistoryWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, opts ...request.Option) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUpgradeHistoryPages iterates over the pages of a GetUpgradeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUpgradeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetUpgradeHistory operation.
//	pageNum := 0
//	err := client.GetUpgradeHistoryPages(params,
//	    func(page *opensearchservice.GetUpgradeHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) GetUpgradeHistoryPages(input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool) error {
	return c.GetUpgradeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUpgradeHistoryPagesWithContext same as GetUpgradeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetUpgradeHistoryPagesWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUpgradeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUpgradeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUpgradeHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUpgradeStatus = "GetUpgradeStatus"

// GetUpgradeStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeStatus for more information on using the GetUpgradeStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUpgradeStatusRequest method.
//	req, resp := client.GetUpgradeStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeStatus
func (c *OpenSearchService) GetUpgradeStatusRequest(input *GetUpgradeStatusInput) (req *request.Request, output *GetUpgradeStatusOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/upgradeDomain/{DomainName}/status",
	}

	if input == nil {
		input = &GetUpgradeStatusInput{}
	}

	output = &GetUpgradeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeStatus API operation for Amazon OpenSearch Service.
//
// Returns the most recent status of the last upgrade or upgrade eligibility
// check performed on an Amazon OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetUpgradeStatus for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeStatus
func (c *OpenSearchService) GetUpgradeStatus(input *GetUpgradeStatusInput) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	return out, req.Send()
}

// GetUpgradeStatusWithContext is the same as GetUpgradeStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetUpgradeStatusWithContext(ctx aws.Context, input *GetUpgradeStatusInput, opts ...request.Option) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDataSources
func (c *OpenSearchService) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/dataSource",
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Amazon OpenSearch Service.
//
// Lists direct-query data sources for a specific domain. For more information,
// see For more information, see Working with Amazon OpenSearch Service direct
// queries with Amazon S3 (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - DependencyFailureException
//     An exception for when a failure in one of the dependencies results in the
//     service being unable to fetch details about the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDataSources
func (c *OpenSearchService) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainMaintenances = "ListDomainMaintenances"

// ListDomainMaintenancesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainMaintenances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainMaintenances for more information on using the ListDomainMaintenances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainMaintenancesRequest method.
//	req, resp := client.ListDomainMaintenancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainMaintenances
func (c *OpenSearchService) ListDomainMaintenancesRequest(input *ListDomainMaintenancesInput) (req *request.Request, output *ListDomainMaintenancesOutput) {
	op := &request.Operation{
		Name:       opListDomainMaintenances,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/domainMaintenances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainMaintenancesInput{}
	}

	output = &ListDomainMaintenancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainMaintenances API operation for Amazon OpenSearch Service.
//
// A list of maintenance actions for the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListDomainMaintenances for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainMaintenances
func (c *OpenSearchService) ListDomainMaintenances(input *ListDomainMaintenancesInput) (*ListDomainMaintenancesOutput, error) {
	req, out := c.ListDomainMaintenancesRequest(input)
	return out, req.Send()
}

// ListDomainMaintenancesWithContext is the same as ListDomainMaintenances with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainMaintenances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainMaintenancesWithContext(ctx aws.Context, input *ListDomainMaintenancesInput, opts ...request.Option) (*ListDomainMaintenancesOutput, error) {
	req, out := c.ListDomainMaintenancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainMaintenancesPages iterates over the pages of a ListDomainMaintenances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomainMaintenances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomainMaintenances operation.
//	pageNum := 0
//	err := client.ListDomainMaintenancesPages(params,
//	    func(page *opensearchservice.ListDomainMaintenancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) ListDomainMaintenancesPages(input *ListDomainMaintenancesInput, fn func(*ListDomainMaintenancesOutput, bool) bool) error {
	return c.ListDomainMaintenancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainMaintenancesPagesWithContext same as ListDomainMaintenancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainMaintenancesPagesWithContext(ctx aws.Context, input *ListDomainMaintenancesInput, fn func(*ListDomainMaintenancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainMaintenancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainMaintenancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainMaintenancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainNames for more information on using the ListDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainNamesRequest method.
//	req, resp := client.ListDomainNamesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainNames
func (c *OpenSearchService) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/domain",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	output = &ListDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainNames API operation for Amazon OpenSearch Service.
//
// Returns the names of all Amazon OpenSearch Service domains owned by the current
// user in the active Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainNames
func (c *OpenSearchService) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	return out, req.Send()
}

// ListDomainNamesWithContext is the same as ListDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainNamesWithContext(ctx aws.Context, input *ListDomainNamesInput, opts ...request.Option) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainsForPackage = "ListDomainsForPackage"

// ListDomainsForPackageRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainsForPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainsForPackage for more information on using the ListDomainsForPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsForPackageRequest method.
//	req, resp := client.ListDomainsForPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainsForPackage
func (c *OpenSearchService) ListDomainsForPackageRequest(input *ListDomainsForPackageInput) (req *request.Request, output *ListDomainsForPackageOutput) {
	op := &request.Operation{
		Name:       opListDomainsForPackage,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/packages/{PackageID}/domains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsForPackageInput{}
	}

	output = &ListDomainsForPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainsForPackage API operation for Amazon OpenSearch Service.
//
// Lists all Amazon OpenSearch Service domains associated with a given package.
// For more information, see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListDomainsForPackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainsForPackage
func (c *OpenSearchService) ListDomainsForPackage(input *ListDomainsForPackageInput) (*ListDomainsForPackageOutput, error) {
	req, out := c.ListDomainsForPackageRequest(input)
	return out, req.Send()
}

// ListDomainsForPackageWithContext is the same as ListDomainsForPackage with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainsForPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainsForPackageWithContext(ctx aws.Context, input *ListDomainsForPackageInput, opts ...request.Option) (*ListDomainsForPackageOutput, error) {
	req, out := c.ListDomainsForPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsForPackagePages iterates over the pages of a ListDomainsForPackage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomainsForPackage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomainsForPackage operation.
//	pageNum := 0
//	err := client.ListDomainsForPackagePages(params,
//	    func(page *opensearchservice.ListDomainsForPackageOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) ListDomainsForPackagePages(input *ListDomainsForPackageInput, fn func(*ListDomainsForPackageOutput, bool) bool) error {
	return c.ListDomainsForPackagePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsForPackagePagesWithContext same as ListDomainsForPackagePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainsForPackagePagesWithContext(ctx aws.Context, input *ListDomainsForPackageInput, fn func(*ListDomainsForPackageOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsForPackageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsForPackageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsForPackageOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceTypeDetails = "ListInstanceTypeDetails"

// ListInstanceTypeDetailsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceTypeDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceTypeDetails for more information on using the ListInstanceTypeDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstanceTypeDetailsRequest method.
//	req, resp := client.ListInstanceTypeDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListInstanceTypeDetails
func (c *OpenSearchService) ListInstanceTypeDetailsRequest(input *ListInstanceTypeDetailsInput) (req *request.Request, output *ListInstanceTypeDetailsOutput) {
	op := &request.Operation{
		Name:       opListInstanceTypeDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/instanceTypeDetails/{EngineVersion}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceTypeDetailsInput{}
	}

	output = &ListInstanceTypeDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceTypeDetails API operation for Amazon OpenSearch Service.
//
// Lists all instance types and available features for a given OpenSearch or
// Elasticsearch version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListInstanceTypeDetails for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListInstanceTypeDetails
func (c *OpenSearchService) ListInstanceTypeDetails(input *ListInstanceTypeDetailsInput) (*ListInstanceTypeDetailsOutput, error) {
	req, out := c.ListInstanceTypeDetailsRequest(input)
	return out, req.Send()
}

// ListInstanceTypeDetailsWithContext is the same as ListInstanceTypeDetails with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceTypeDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListInstanceTypeDetailsWithContext(ctx aws.Context, input *ListInstanceTypeDetailsInput, opts ...request.Option) (*ListInstanceTypeDetailsOutput, error) {
	req, out := c.ListInstanceTypeDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstanceTypeDetailsPages iterates over the pages of a ListInstanceTypeDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceTypeDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInstanceTypeDetails operation.
//	pageNum := 0
//	err := client.ListInstanceTypeDetailsPages(params,
//	    func(page *opensearchservice.ListInstanceTypeDetailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) ListInstanceTypeDetailsPages(input *ListInstanceTypeDetailsInput, fn func(*ListInstanceTypeDetailsOutput, bool) bool) error {
	return c.ListInstanceTypeDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstanceTypeDetailsPagesWithContext same as ListInstanceTypeDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListInstanceTypeDetailsPagesWithContext(ctx aws.Context, input *ListInstanceTypeDetailsInput, fn func(*ListInstanceTypeDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstanceTypeDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstanceTypeDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstanceTypeDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackagesForDomain = "ListPackagesForDomain"

// ListPackagesForDomainRequest generates a "aws/request.Request" representing the
// client's request for the ListPackagesForDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackagesForDomain for more information on using the ListPackagesForDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPackagesForDomainRequest method.
//	req, resp := client.ListPackagesForDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListPackagesForDomain
func (c *OpenSearchService) ListPackagesForDomainRequest(input *ListPackagesForDomainInput) (req *request.Request, output *ListPackagesForDomainOutput) {
	op := &request.Operation{
		Name:       opListPackagesForDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/domain/{DomainName}/packages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagesForDomainInput{}
	}

	output = &ListPackagesForDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackagesForDomain API operation for Amazon OpenSearch Service.
//
// Lists all packages associated with an Amazon OpenSearch Service domain. For
// more information, see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListPackagesForDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListPackagesForDomain
func (c *OpenSearchService) ListPackagesForDomain(input *ListPackagesForDomainInput) (*ListPackagesForDomainOutput, error) {
	req, out := c.ListPackagesForDomainRequest(input)
	return out, req.Send()
}

// ListPackagesForDomainWithContext is the same as ListPackagesForDomain with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackagesForDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListPackagesForDomainWithContext(ctx aws.Context, input *ListPackagesForDomainInput, opts ...request.Option) (*ListPackagesForDomainOutput, error) {
	req, out := c.ListPackagesForDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagesForDomainPages iterates over the pages of a ListPackagesForDomain operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackagesForDomain method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPackagesForDomain operation.
//	pageNum := 0
//	err := client.ListPackagesForDomainPages(params,
//	    func(page *opensearchservice.ListPackagesForDomainOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) ListPackagesForDomainPages(input *ListPackagesForDomainInput, fn func(*ListPackagesForDomainOutput, bool) bool) error {
	return c.ListPackagesForDomainPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagesForDomainPagesWithContext same as ListPackagesForDomainPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListPackagesForDomainPagesWithContext(ctx aws.Context, input *ListPackagesForDomainInput, fn func(*ListPackagesForDomainOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagesForDomainInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagesForDomainRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagesForDomainOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListScheduledActions = "ListScheduledActions"

// ListScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListScheduledActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScheduledActions for more information on using the ListScheduledActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScheduledActionsRequest method.
//	req, resp := client.ListScheduledActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListScheduledActions
func (c *OpenSearchService) ListScheduledActionsRequest(input *ListScheduledActionsInput) (req *request.Request, output *ListScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opListScheduledActions,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/scheduledActions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScheduledActionsInput{}
	}

	output = &ListScheduledActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScheduledActions API operation for Amazon OpenSearch Service.
//
// Retrieves a list of configuration changes that are scheduled for a domain.
// These changes can be service software updates (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html)
// or blue/green Auto-Tune enhancements (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListScheduledActions for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InvalidPaginationTokenException
//     Request processing failed because you provided an invalid pagination token.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListScheduledActions
func (c *OpenSearchService) ListScheduledActions(input *ListScheduledActionsInput) (*ListScheduledActionsOutput, error) {
	req, out := c.ListScheduledActionsRequest(input)
	return out, req.Send()
}

// ListScheduledActionsWithContext is the same as ListScheduledActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListScheduledActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListScheduledActionsWithContext(ctx aws.Context, input *ListScheduledActionsInput, opts ...request.Option) (*ListScheduledActionsOutput, error) {
	req, out := c.ListScheduledActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScheduledActionsPages iterates over the pages of a ListScheduledActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScheduledActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScheduledActions operation.
//	pageNum := 0
//	err := client.ListScheduledActionsPages(params,
//	    func(page *opensearchservice.ListScheduledActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) ListScheduledActionsPages(input *ListScheduledActionsInput, fn func(*ListScheduledActionsOutput, bool) bool) error {
	return c.ListScheduledActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScheduledActionsPagesWithContext same as ListScheduledActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListScheduledActionsPagesWithContext(ctx aws.Context, input *ListScheduledActionsInput, fn func(*ListScheduledActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScheduledActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScheduledActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScheduledActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsRequest method.
//	req, resp := client.ListTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListTags
func (c *OpenSearchService) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/tags/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon OpenSearch Service.
//
// Returns all resource tags for an Amazon OpenSearch Service domain. For more
// information, see Tagging Amazon OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListTags
func (c *OpenSearchService) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVersions = "ListVersions"

// ListVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVersions for more information on using the ListVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVersionsRequest method.
//	req, resp := client.ListVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVersions
func (c *OpenSearchService) ListVersionsRequest(input *ListVersionsInput) (req *request.Request, output *ListVersionsOutput) {
	op := &request.Operation{
		Name:       opListVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVersionsInput{}
	}

	output = &ListVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVersions API operation for Amazon OpenSearch Service.
//
// Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch
// Service supports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListVersions for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVersions
func (c *OpenSearchService) ListVersions(input *ListVersionsInput) (*ListVersionsOutput, error) {
	req, out := c.ListVersionsRequest(input)
	return out, req.Send()
}

// ListVersionsWithContext is the same as ListVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVersionsWithContext(ctx aws.Context, input *ListVersionsInput, opts ...request.Option) (*ListVersionsOutput, error) {
	req, out := c.ListVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVersionsPages iterates over the pages of a ListVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVersions operation.
//	pageNum := 0
//	err := client.ListVersionsPages(params,
//	    func(page *opensearchservice.ListVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchService) ListVersionsPages(input *ListVersionsInput, fn func(*ListVersionsOutput, bool) bool) error {
	return c.ListVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVersionsPagesWithContext same as ListVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVersionsPagesWithContext(ctx aws.Context, input *ListVersionsInput, fn func(*ListVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVpcEndpointAccess = "ListVpcEndpointAccess"

// ListVpcEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the ListVpcEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVpcEndpointAccess for more information on using the ListVpcEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVpcEndpointAccessRequest method.
//	req, resp := client.ListVpcEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVpcEndpointAccess
func (c *OpenSearchService) ListVpcEndpointAccessRequest(input *ListVpcEndpointAccessInput) (req *request.Request, output *ListVpcEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opListVpcEndpointAccess,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/listVpcEndpointAccess",
	}

	if input == nil {
		input = &ListVpcEndpointAccessInput{}
	}

	output = &ListVpcEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVpcEndpointAccess API operation for Amazon OpenSearch Service.
//
// Retrieves information about each Amazon Web Services principal that is allowed
// to access a given Amazon OpenSearch Service domain through the use of an
// interface VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListVpcEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVpcEndpointAccess
func (c *OpenSearchService) ListVpcEndpointAccess(input *ListVpcEndpointAccessInput) (*ListVpcEndpointAccessOutput, error) {
	req, out := c.ListVpcEndpointAccessRequest(input)
	return out, req.Send()
}

// ListVpcEndpointAccessWithContext is the same as ListVpcEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See ListVpcEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVpcEndpointAccessWithContext(ctx aws.Context, input *ListVpcEndpointAccessInput, opts ...request.Option) (*ListVpcEndpointAccessOutput, error) {
	req, out := c.ListVpcEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVpcEndpoints = "ListVpcEndpoints"

// ListVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListVpcEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVpcEndpoints for more information on using the ListVpcEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVpcEndpointsRequest method.
//	req, resp := client.ListVpcEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVpcEndpoints
func (c *OpenSearchService) ListVpcEndpointsRequest(input *ListVpcEndpointsInput) (req *request.Request, output *ListVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opListVpcEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/vpcEndpoints",
	}

	if input == nil {
		input = &ListVpcEndpointsInput{}
	}

	output = &ListVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVpcEndpoints API operation for Amazon OpenSearch Service.
//
// Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current
// Amazon Web Services account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListVpcEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVpcEndpoints
func (c *OpenSearchService) ListVpcEndpoints(input *ListVpcEndpointsInput) (*ListVpcEndpointsOutput, error) {
	req, out := c.ListVpcEndpointsRequest(input)
	return out, req.Send()
}

// ListVpcEndpointsWithContext is the same as ListVpcEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListVpcEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVpcEndpointsWithContext(ctx aws.Context, input *ListVpcEndpointsInput, opts ...request.Option) (*ListVpcEndpointsOutput, error) {
	req, out := c.ListVpcEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVpcEndpointsForDomain = "ListVpcEndpointsForDomain"

// ListVpcEndpointsForDomainRequest generates a "aws/request.Request" representing the
// client's request for the ListVpcEndpointsForDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVpcEndpointsForDomain for more information on using the ListVpcEndpointsForDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVpcEndpointsForDomainRequest method.
//	req, resp := client.ListVpcEndpointsForDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVpcEndpointsForDomain
func (c *OpenSearchService) ListVpcEndpointsForDomainRequest(input *ListVpcEndpointsForDomainInput) (req *request.Request, output *ListVpcEndpointsForDomainOutput) {
	op := &request.Operation{
		Name:       opListVpcEndpointsForDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/vpcEndpoints",
	}

	if input == nil {
		input = &ListVpcEndpointsForDomainInput{}
	}

	output = &ListVpcEndpointsForDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVpcEndpointsForDomain API operation for Amazon OpenSearch Service.
//
// Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated
// with a particular domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListVpcEndpointsForDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVpcEndpointsForDomain
func (c *OpenSearchService) ListVpcEndpointsForDomain(input *ListVpcEndpointsForDomainInput) (*ListVpcEndpointsForDomainOutput, error) {
	req, out := c.ListVpcEndpointsForDomainRequest(input)
	return out, req.Send()
}

// ListVpcEndpointsForDomainWithContext is the same as ListVpcEndpointsForDomain with the addition of
// the ability to pass a context and additional request options.
//
// See ListVpcEndpointsForDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVpcEndpointsForDomainWithContext(ctx aws.Context, input *ListVpcEndpointsForDomainInput, opts ...request.Option) (*ListVpcEndpointsForDomainOutput, error) {
	req, out := c.ListVpcEndpointsForDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedInstanceOffering = "PurchaseReservedInstanceOffering"

// PurchaseReservedInstanceOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedInstanceOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedInstanceOffering for more information on using the PurchaseReservedInstanceOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PurchaseReservedInstanceOfferingRequest method.
//	req, resp := client.PurchaseReservedInstanceOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/PurchaseReservedInstanceOffering
func (c *OpenSearchService) PurchaseReservedInstanceOfferingRequest(input *PurchaseReservedInstanceOfferingInput) (req *request.Request, output *PurchaseReservedInstanceOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedInstanceOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/purchaseReservedInstanceOffering",
	}

	if input == nil {
		input = &PurchaseReservedInstanceOfferingInput{}
	}

	output = &PurchaseReservedInstanceOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedInstanceOffering API operation for Amazon OpenSearch Service.
//
// Allows you to purchase Amazon OpenSearch Service Reserved Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation PurchaseReservedInstanceOffering for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/PurchaseReservedInstanceOffering
func (c *OpenSearchService) PurchaseReservedInstanceOffering(input *PurchaseReservedInstanceOfferingInput) (*PurchaseReservedInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedInstanceOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedInstanceOfferingWithContext is the same as PurchaseReservedInstanceOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedInstanceOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) PurchaseReservedInstanceOfferingWithContext(ctx aws.Context, input *PurchaseReservedInstanceOfferingInput, opts ...request.Option) (*PurchaseReservedInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedInstanceOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectInboundConnection = "RejectInboundConnection"

// RejectInboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the RejectInboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInboundConnection for more information on using the RejectInboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectInboundConnectionRequest method.
//	req, resp := client.RejectInboundConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RejectInboundConnection
func (c *OpenSearchService) RejectInboundConnectionRequest(input *RejectInboundConnectionInput) (req *request.Request, output *RejectInboundConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectInboundConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/reject",
	}

	if input == nil {
		input = &RejectInboundConnectionInput{}
	}

	output = &RejectInboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectInboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the remote Amazon OpenSearch Service domain owner to reject an inbound
// cross-cluster connection request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation RejectInboundConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RejectInboundConnection
func (c *OpenSearchService) RejectInboundConnection(input *RejectInboundConnectionInput) (*RejectInboundConnectionOutput, error) {
	req, out := c.RejectInboundConnectionRequest(input)
	return out, req.Send()
}

// RejectInboundConnectionWithContext is the same as RejectInboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) RejectInboundConnectionWithContext(ctx aws.Context, input *RejectInboundConnectionInput, opts ...request.Option) (*RejectInboundConnectionOutput, error) {
	req, out := c.RejectInboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveTagsRequest method.
//	req, resp := client.RemoveTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RemoveTags
func (c *OpenSearchService) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/tags-removal",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon OpenSearch Service.
//
// Removes the specified set of tags from an Amazon OpenSearch Service domain.
// For more information, see Tagging Amazon OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation RemoveTags for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RemoveTags
func (c *OpenSearchService) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeVpcEndpointAccess = "RevokeVpcEndpointAccess"

// RevokeVpcEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the RevokeVpcEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeVpcEndpointAccess for more information on using the RevokeVpcEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RevokeVpcEndpointAccessRequest method.
//	req, resp := client.RevokeVpcEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RevokeVpcEndpointAccess
func (c *OpenSearchService) RevokeVpcEndpointAccessRequest(input *RevokeVpcEndpointAccessInput) (req *request.Request, output *RevokeVpcEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opRevokeVpcEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/revokeVpcEndpointAccess",
	}

	if input == nil {
		input = &RevokeVpcEndpointAccessInput{}
	}

	output = &RevokeVpcEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeVpcEndpointAccess API operation for Amazon OpenSearch Service.
//
// Revokes access to an Amazon OpenSearch Service domain that was provided through
// an interface VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation RevokeVpcEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RevokeVpcEndpointAccess
func (c *OpenSearchService) RevokeVpcEndpointAccess(input *RevokeVpcEndpointAccessInput) (*RevokeVpcEndpointAccessOutput, error) {
	req, out := c.RevokeVpcEndpointAccessRequest(input)
	return out, req.Send()
}

// RevokeVpcEndpointAccessWithContext is the same as RevokeVpcEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeVpcEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) RevokeVpcEndpointAccessWithContext(ctx aws.Context, input *RevokeVpcEndpointAccessInput, opts ...request.Option) (*RevokeVpcEndpointAccessOutput, error) {
	req, out := c.RevokeVpcEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDomainMaintenance = "StartDomainMaintenance"

// StartDomainMaintenanceRequest generates a "aws/request.Request" representing the
// client's request for the StartDomainMaintenance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDomainMaintenance for more information on using the StartDomainMaintenance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDomainMaintenanceRequest method.
//	req, resp := client.StartDomainMaintenanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/StartDomainMaintenance
func (c *OpenSearchService) StartDomainMaintenanceRequest(input *StartDomainMaintenanceInput) (req *request.Request, output *StartDomainMaintenanceOutput) {
	op := &request.Operation{
		Name:       opStartDomainMaintenance,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/domainMaintenance",
	}

	if input == nil {
		input = &StartDomainMaintenanceInput{}
	}

	output = &StartDomainMaintenanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDomainMaintenance API operation for Amazon OpenSearch Service.
//
// Starts the node maintenance process on the data node. These processes can
// include a node reboot, an Opensearch or Elasticsearch process restart, or
// a Dashboard or Kibana restart.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation StartDomainMaintenance for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/StartDomainMaintenance
func (c *OpenSearchService) StartDomainMaintenance(input *StartDomainMaintenanceInput) (*StartDomainMaintenanceOutput, error) {
	req, out := c.StartDomainMaintenanceRequest(input)
	return out, req.Send()
}

// StartDomainMaintenanceWithContext is the same as StartDomainMaintenance with the addition of
// the ability to pass a context and additional request options.
//
// See StartDomainMaintenance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) StartDomainMaintenanceWithContext(ctx aws.Context, input *StartDomainMaintenanceInput, opts ...request.Option) (*StartDomainMaintenanceOutput, error) {
	req, out := c.StartDomainMaintenanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartServiceSoftwareUpdate = "StartServiceSoftwareUpdate"

// StartServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the StartServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartServiceSoftwareUpdate for more information on using the StartServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartServiceSoftwareUpdateRequest method.
//	req, resp := client.StartServiceSoftwareUpdateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/StartServiceSoftwareUpdate
func (c *OpenSearchService) StartServiceSoftwareUpdateRequest(input *StartServiceSoftwareUpdateInput) (req *request.Request, output *StartServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opStartServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/serviceSoftwareUpdate/start",
	}

	if input == nil {
		input = &StartServiceSoftwareUpdateInput{}
	}

	output = &StartServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartServiceSoftwareUpdate API operation for Amazon OpenSearch Service.
//
// Schedules a service software update for an Amazon OpenSearch Service domain.
// For more information, see Service software updates in Amazon OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation StartServiceSoftwareUpdate for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/StartServiceSoftwareUpdate
func (c *OpenSearchService) StartServiceSoftwareUpdate(input *StartServiceSoftwareUpdateInput) (*StartServiceSoftwareUpdateOutput, error) {
	req, out := c.StartServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// StartServiceSoftwareUpdateWithContext is the same as StartServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See StartServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) StartServiceSoftwareUpdateWithContext(ctx aws.Context, input *StartServiceSoftwareUpdateInput, opts ...request.Option) (*StartServiceSoftwareUpdateOutput, error) {
	req, out := c.StartServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateDataSource
func (c *OpenSearchService) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/dataSource/{DataSourceName}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon OpenSearch Service.
//
// Updates a direct-query data source. For more information, see Working with
// Amazon OpenSearch Service data source integrations with Amazon S3 (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - DependencyFailureException
//     An exception for when a failure in one of the dependencies results in the
//     service being unable to fetch details about the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateDataSource
func (c *OpenSearchService) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainConfig = "UpdateDomainConfig"

// UpdateDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainConfig for more information on using the UpdateDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDomainConfigRequest method.
//	req, resp := client.UpdateDomainConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateDomainConfig
func (c *OpenSearchService) UpdateDomainConfigRequest(input *UpdateDomainConfigInput) (req *request.Request, output *UpdateDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/config",
	}

	if input == nil {
		input = &UpdateDomainConfigInput{}
	}

	output = &UpdateDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainConfig API operation for Amazon OpenSearch Service.
//
// Modifies the cluster configuration of the specified Amazon OpenSearch Service
// domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdateDomainConfig for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - InvalidTypeException
//     An exception for trying to create or access a sub-resource that's either
//     invalid or not supported.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateDomainConfig
func (c *OpenSearchService) UpdateDomainConfig(input *UpdateDomainConfigInput) (*UpdateDomainConfigOutput, error) {
	req, out := c.UpdateDomainConfigRequest(input)
	return out, req.Send()
}

// UpdateDomainConfigWithContext is the same as UpdateDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdateDomainConfigWithContext(ctx aws.Context, input *UpdateDomainConfigInput, opts ...request.Option) (*UpdateDomainConfigOutput, error) {
	req, out := c.UpdateDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePackage = "UpdatePackage"

// UpdatePackageRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePackage for more information on using the UpdatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePackageRequest method.
//	req, resp := client.UpdatePackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdatePackage
func (c *OpenSearchService) UpdatePackageRequest(input *UpdatePackageInput) (req *request.Request, output *UpdatePackageOutput) {
	op := &request.Operation{
		Name:       opUpdatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/update",
	}

	if input == nil {
		input = &UpdatePackageInput{}
	}

	output = &UpdatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePackage API operation for Amazon OpenSearch Service.
//
// Updates a package for use with Amazon OpenSearch Service domains. For more
// information, see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdatePackage for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - AccessDeniedException
//     An error occurred because you don't have permissions to access the resource.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdatePackage
func (c *OpenSearchService) UpdatePackage(input *UpdatePackageInput) (*UpdatePackageOutput, error) {
	req, out := c.UpdatePackageRequest(input)
	return out, req.Send()
}

// UpdatePackageWithContext is the same as UpdatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdatePackageWithContext(ctx aws.Context, input *UpdatePackageInput, opts ...request.Option) (*UpdatePackageOutput, error) {
	req, out := c.UpdatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScheduledAction = "UpdateScheduledAction"

// UpdateScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScheduledAction for more information on using the UpdateScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateScheduledActionRequest method.
//	req, resp := client.UpdateScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateScheduledAction
func (c *OpenSearchService) UpdateScheduledActionRequest(input *UpdateScheduledActionInput) (req *request.Request, output *UpdateScheduledActionOutput) {
	op := &request.Operation{
		Name:       opUpdateScheduledAction,
		HTTPMethod: "PUT",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/scheduledAction/update",
	}

	if input == nil {
		input = &UpdateScheduledActionInput{}
	}

	output = &UpdateScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScheduledAction API operation for Amazon OpenSearch Service.
//
// Reschedules a planned domain configuration change for a later time. This
// change can be a scheduled service software update (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html)
// or a blue/green Auto-Tune enhancement (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdateScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - SlotNotAvailableException
//     An exception for attempting to schedule a domain action during an unavailable
//     time slot.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use.
//
//   - LimitExceededException
//     An exception for trying to create more than the allowed number of resources
//     or sub-resources.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateScheduledAction
func (c *OpenSearchService) UpdateScheduledAction(input *UpdateScheduledActionInput) (*UpdateScheduledActionOutput, error) {
	req, out := c.UpdateScheduledActionRequest(input)
	return out, req.Send()
}

// UpdateScheduledActionWithContext is the same as UpdateScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdateScheduledActionWithContext(ctx aws.Context, input *UpdateScheduledActionInput, opts ...request.Option) (*UpdateScheduledActionOutput, error) {
	req, out := c.UpdateScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVpcEndpoint = "UpdateVpcEndpoint"

// UpdateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVpcEndpoint for more information on using the UpdateVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVpcEndpointRequest method.
//	req, resp := client.UpdateVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateVpcEndpoint
func (c *OpenSearchService) UpdateVpcEndpointRequest(input *UpdateVpcEndpointInput) (req *request.Request, output *UpdateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/vpcEndpoints/update",
	}

	if input == nil {
		input = &UpdateVpcEndpointInput{}
	}

	output = &UpdateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVpcEndpoint API operation for Amazon OpenSearch Service.
//
// Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdateVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ConflictException
//     An error occurred because the client attempts to remove a resource that is
//     currently in use.
//
//   - BaseException
//     An error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateVpcEndpoint
func (c *OpenSearchService) UpdateVpcEndpoint(input *UpdateVpcEndpointInput) (*UpdateVpcEndpointOutput, error) {
	req, out := c.UpdateVpcEndpointRequest(input)
	return out, req.Send()
}

// UpdateVpcEndpointWithContext is the same as UpdateVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdateVpcEndpointWithContext(ctx aws.Context, input *UpdateVpcEndpointInput, opts ...request.Option) (*UpdateVpcEndpointOutput, error) {
	req, out := c.UpdateVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeDomain = "UpgradeDomain"

// UpgradeDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeDomain for more information on using the UpgradeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpgradeDomainRequest method.
//	req, resp := client.UpgradeDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpgradeDomain
func (c *OpenSearchService) UpgradeDomainRequest(input *UpgradeDomainInput) (req *request.Request, output *UpgradeDomainOutput) {
	op := &request.Operation{
		Name:       opUpgradeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/upgradeDomain",
	}

	if input == nil {
		input = &UpgradeDomainInput{}
	}

	output = &UpgradeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpgradeDomain API operation for Amazon OpenSearch Service.
//
// Allows you to either upgrade your Amazon OpenSearch Service domain or perform
// an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpgradeDomain for usage and error information.
//
// Returned Error Types:
//
//   - BaseException
//     An error occurred while processing the request.
//
//   - ResourceNotFoundException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - ResourceAlreadyExistsException
//     An exception for creating a resource that already exists.
//
//   - DisabledOperationException
//     An error occured because the client wanted to access an unsupported operation.
//
//   - ValidationException
//     An exception for accessing or deleting a resource that doesn't exist.
//
//   - InternalException
//     Request processing failed because of an unknown error, exception, or internal
//     failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpgradeDomain
func (c *OpenSearchService) UpgradeDomain(input *UpgradeDomainInput) (*UpgradeDomainOutput, error) {
	req, out := c.UpgradeDomainRequest(input)
	return out, req.Send()
}

// UpgradeDomainWithContext is the same as UpgradeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpgradeDomainWithContext(ctx aws.Context, input *UpgradeDomainInput, opts ...request.Option) (*UpgradeDomainOutput, error) {
	req, out := c.UpgradeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about an Amazon OpenSearch Service domain.
type AWSDomainInformation struct {
	_ struct{} `type:"structure"`

	// Name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The Amazon Web Services account ID of the domain owner.
	OwnerId *string `min:"12" type:"string"`

	// The Amazon Web Services Region in which the domain is located.
	Region *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AWSDomainInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AWSDomainInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AWSDomainInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AWSDomainInformation"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.OwnerId != nil && len(*s.OwnerId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerId", 12))
	}
	if s.Region != nil && len(*s.Region) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AWSDomainInformation) SetDomainName(v string) *AWSDomainInformation {
	s.DomainName = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AWSDomainInformation) SetOwnerId(v string) *AWSDomainInformation {
	s.OwnerId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *AWSDomainInformation) SetRegion(v string) *AWSDomainInformation {
	s.Region = &v
	return s
}

// Container for the parameters to the AcceptInboundConnection operation.
type AcceptInboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the inbound connection to accept.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AcceptInboundConnectionInput) SetConnectionId(v string) *AcceptInboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// Contains details about the accepted inbound connection.
type AcceptInboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the accepted inbound connection.
	Connection *InboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *AcceptInboundConnectionOutput) SetConnection(v *InboundConnection) *AcceptInboundConnectionOutput {
	s.Connection = v
	return s
}

// An error occurred because you don't have permissions to access the resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configured access rules for the domain's search endpoint, and the current
// status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the domain. Access policies can be resource-based,
	// IP-based, or IAM-based. For more information, see Configuring access policies
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies).
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AccessPoliciesStatus) SetOptions(v string) *AccessPoliciesStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPoliciesStatus) SetStatus(v *OptionStatus) *AccessPoliciesStatus {
	s.Status = v
	return s
}

// Container for the parameters to the AddDataSource operation.
type AddDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The type of data source.
	//
	// DataSourceType is a required field
	DataSourceType *DataSourceType `type:"structure" required:"true"`

	// A description of the data source.
	Description *string `type:"string"`

	// The name of the domain to add the data source to.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// A name for the data source.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddDataSourceInput"}
	if s.DataSourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceType"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.DataSourceType != nil {
		if err := s.DataSourceType.Validate(); err != nil {
			invalidParams.AddNested("DataSourceType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceType sets the DataSourceType field's value.
func (s *AddDataSourceInput) SetDataSourceType(v *DataSourceType) *AddDataSourceInput {
	s.DataSourceType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddDataSourceInput) SetDescription(v string) *AddDataSourceInput {
	s.Description = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AddDataSourceInput) SetDomainName(v string) *AddDataSourceInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddDataSourceInput) SetName(v string) *AddDataSourceInput {
	s.Name = &v
	return s
}

// The result of an AddDataSource operation.
type AddDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A message associated with creation of the data source.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddDataSourceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AddDataSourceOutput) SetMessage(v string) *AddDataSourceOutput {
	s.Message = &v
	return s
}

// Container for the parameters to the AddTags operation. Specifies the tags
// to attach to the domain.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) for the OpenSearch Service domain to which you
	// want to attach resource tags.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// List of resource tags.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *AddTagsInput) SetARN(v string) *AddTagsInput {
	s.ARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsInput) SetTagList(v []*Tag) *AddTagsInput {
	s.TagList = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// List of limits that are specific to a given instance type.
type AdditionalLimit struct {
	_ struct{} `type:"structure"`

	//    * MaximumNumberOfDataNodesSupported - This attribute only applies to master
	//    nodes and specifies the maximum number of data nodes of a given instance
	//    type a master node can support.
	//
	//    * MaximumNumberOfDataNodesWithoutMasterNode - This attribute only applies
	//    to data nodes and specifies the maximum number of data nodes of a given
	//    instance type can exist without a master node governing them.
	LimitName *string `type:"string"`

	// The values of the additional instance type limits.
	LimitValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *AdditionalLimit) SetLimitName(v string) *AdditionalLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *AdditionalLimit) SetLimitValues(v []*string) *AdditionalLimit {
	s.LimitValues = v
	return s
}

// Status of the advanced options for the specified domain. The following options
// are available:
//
//   - "rest.action.multi.allow_explicit_index": "true" | "false" - Note the
//     use of a string rather than a boolean. Specifies whether explicit references
//     to indexes are allowed inside the body of HTTP requests. If you want to
//     configure access policies for domain sub-resources, such as specific indexes
//     and domain APIs, you must disable this property. Default is true.
//
//   - "indices.fielddata.cache.size": "80" - Note the use of a string rather
//     than a boolean. Specifies the percentage of heap space allocated to field
//     data. Default is unbounded.
//
//   - "indices.query.bool.max_clause_count": "1024" - Note the use of a string
//     rather than a boolean. Specifies the maximum number of clauses allowed
//     in a Lucene boolean query. Default is 1,024. Queries with more than the
//     permitted number of clauses result in a TooManyClauses error.
//
//   - "override_main_response_version": "true" | "false" - Note the use of
//     a string rather than a boolean. Specifies whether the domain reports its
//     version as 7.10 to allow Elasticsearch OSS clients and plugins to continue
//     working with it. Default is false when creating a domain and true when
//     upgrading a domain.
//
// For more information, see Advanced cluster parameters (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The status of advanced options for the specified domain.
	//
	// Options is a required field
	Options map[string]*string `type:"map" required:"true"`

	// The status of advanced options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedOptionsStatus) SetOptions(v map[string]*string) *AdvancedOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedOptionsStatus) SetStatus(v *OptionStatus) *AdvancedOptionsStatus {
	s.Status = v
	return s
}

// Container for fine-grained access control settings.
type AdvancedSecurityOptions struct {
	_ struct{} `type:"structure"`

	// Date and time when the migration period will be disabled. Only necessary
	// when enabling fine-grained access control on an existing domain (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
	AnonymousAuthDisableDate *time.Time `type:"timestamp"`

	// True if a 30-day migration period is enabled, during which administrators
	// can create role mappings. Only necessary when enabling fine-grained access
	// control on an existing domain (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
	AnonymousAuthEnabled *bool `type:"boolean"`

	// True if fine-grained access control is enabled.
	Enabled *bool `type:"boolean"`

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool `type:"boolean"`

	// Container for information about the SAML configuration for OpenSearch Dashboards.
	SAMLOptions *SAMLOptionsOutput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptions) GoString() string {
	return s.String()
}

// SetAnonymousAuthDisableDate sets the AnonymousAuthDisableDate field's value.
func (s *AdvancedSecurityOptions) SetAnonymousAuthDisableDate(v time.Time) *AdvancedSecurityOptions {
	s.AnonymousAuthDisableDate = &v
	return s
}

// SetAnonymousAuthEnabled sets the AnonymousAuthEnabled field's value.
func (s *AdvancedSecurityOptions) SetAnonymousAuthEnabled(v bool) *AdvancedSecurityOptions {
	s.AnonymousAuthEnabled = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AdvancedSecurityOptions) SetEnabled(v bool) *AdvancedSecurityOptions {
	s.Enabled = &v
	return s
}

// SetInternalUserDatabaseEnabled sets the InternalUserDatabaseEnabled field's value.
func (s *AdvancedSecurityOptions) SetInternalUserDatabaseEnabled(v bool) *AdvancedSecurityOptions {
	s.InternalUserDatabaseEnabled = &v
	return s
}

// SetSAMLOptions sets the SAMLOptions field's value.
func (s *AdvancedSecurityOptions) SetSAMLOptions(v *SAMLOptionsOutput_) *AdvancedSecurityOptions {
	s.SAMLOptions = v
	return s
}

// Options for enabling and configuring fine-grained access control. For more
// information, see Fine-grained access control in Amazon OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html).
type AdvancedSecurityOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// True to enable a 30-day migration period during which administrators can
	// create role mappings. Only necessary when enabling fine-grained access control
	// on an existing domain (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing).
	AnonymousAuthEnabled *bool `type:"boolean"`

	// True to enable fine-grained access control.
	Enabled *bool `type:"boolean"`

	// True to enable the internal user database.
	InternalUserDatabaseEnabled *bool `type:"boolean"`

	// Container for information about the master user.
	MasterUserOptions *MasterUserOptions `type:"structure"`

	// Container for information about the SAML configuration for OpenSearch Dashboards.
	SAMLOptions *SAMLOptionsInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvancedSecurityOptionsInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvancedSecurityOptionsInput_"}
	if s.MasterUserOptions != nil {
		if err := s.MasterUserOptions.Validate(); err != nil {
			invalidParams.AddNested("MasterUserOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.SAMLOptions != nil {
		if err := s.SAMLOptions.Validate(); err != nil {
			invalidParams.AddNested("SAMLOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnonymousAuthEnabled sets the AnonymousAuthEnabled field's value.
func (s *AdvancedSecurityOptionsInput_) SetAnonymousAuthEnabled(v bool) *AdvancedSecurityOptionsInput_ {
	s.AnonymousAuthEnabled = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AdvancedSecurityOptionsInput_) SetEnabled(v bool) *AdvancedSecurityOptionsInput_ {
	s.Enabled = &v
	return s
}

// SetInternalUserDatabaseEnabled sets the InternalUserDatabaseEnabled field's value.
func (s *AdvancedSecurityOptionsInput_) SetInternalUserDatabaseEnabled(v bool) *AdvancedSecurityOptionsInput_ {
	s.InternalUserDatabaseEnabled = &v
	return s
}

// SetMasterUserOptions sets the MasterUserOptions field's value.
func (s *AdvancedSecurityOptionsInput_) SetMasterUserOptions(v *MasterUserOptions) *AdvancedSecurityOptionsInput_ {
	s.MasterUserOptions = v
	return s
}

// SetSAMLOptions sets the SAMLOptions field's value.
func (s *AdvancedSecurityOptionsInput_) SetSAMLOptions(v *SAMLOptionsInput_) *AdvancedSecurityOptionsInput_ {
	s.SAMLOptions = v
	return s
}

// The status of fine-grained access control settings for a domain.
type AdvancedSecurityOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Container for fine-grained access control settings.
	//
	// Options is a required field
	Options *AdvancedSecurityOptions `type:"structure" required:"true"`

	// Status of the fine-grained access control settings for a domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedSecurityOptionsStatus) SetOptions(v *AdvancedSecurityOptions) *AdvancedSecurityOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedSecurityOptionsStatus) SetStatus(v *OptionStatus) *AdvancedSecurityOptionsStatus {
	s.Status = v
	return s
}

// Container for the request parameters to the AssociatePackage operation.
type AssociatePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the domain to associate the package with.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Internal ID of the package to associate with a domain. Use DescribePackages
	// to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePackageInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AssociatePackageInput) SetDomainName(v string) *AssociatePackageInput {
	s.DomainName = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *AssociatePackageInput) SetPackageID(v string) *AssociatePackageInput {
	s.PackageID = &v
	return s
}

// Container for the response returned by the AssociatePackage operation.
type AssociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about a package that is associated with a domain.
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetails sets the DomainPackageDetails field's value.
func (s *AssociatePackageOutput) SetDomainPackageDetails(v *DomainPackageDetails) *AssociatePackageOutput {
	s.DomainPackageDetails = v
	return s
}

type AuthorizeVpcEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID to grant access to.
	//
	// Account is a required field
	Account *string `type:"string" required:"true"`

	// The name of the OpenSearch Service domain to provide access to.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeVpcEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeVpcEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeVpcEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeVpcEndpointAccessInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *AuthorizeVpcEndpointAccessInput) SetAccount(v string) *AuthorizeVpcEndpointAccessInput {
	s.Account = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AuthorizeVpcEndpointAccessInput) SetDomainName(v string) *AuthorizeVpcEndpointAccessInput {
	s.DomainName = &v
	return s
}

type AuthorizeVpcEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon Web Services account or service that was provided
	// access to the domain.
	//
	// AuthorizedPrincipal is a required field
	AuthorizedPrincipal *AuthorizedPrincipal `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeVpcEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeVpcEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetAuthorizedPrincipal sets the AuthorizedPrincipal field's value.
func (s *AuthorizeVpcEndpointAccessOutput) SetAuthorizedPrincipal(v *AuthorizedPrincipal) *AuthorizeVpcEndpointAccessOutput {
	s.AuthorizedPrincipal = v
	return s
}

// Information about an Amazon Web Services account or service that has access
// to an Amazon OpenSearch Service domain through the use of an interface VPC
// endpoint.
type AuthorizedPrincipal struct {
	_ struct{} `type:"structure"`

	// The IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html)
	// that is allowed access to the domain.
	Principal *string `type:"string"`

	// The type of principal.
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizedPrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizedPrincipal) GoString() string {
	return s.String()
}

// SetPrincipal sets the Principal field's value.
func (s *AuthorizedPrincipal) SetPrincipal(v string) *AuthorizedPrincipal {
	s.Principal = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AuthorizedPrincipal) SetPrincipalType(v string) *AuthorizedPrincipal {
	s.PrincipalType = &v
	return s
}

// Information about an Auto-Tune action. For more information, see Auto-Tune
// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type AutoTune struct {
	_ struct{} `type:"structure"`

	// Details about an Auto-Tune action.
	AutoTuneDetails *AutoTuneDetails `type:"structure"`

	// The type of Auto-Tune action.
	AutoTuneType *string `type:"string" enum:"AutoTuneType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTune) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTune) GoString() string {
	return s.String()
}

// SetAutoTuneDetails sets the AutoTuneDetails field's value.
func (s *AutoTune) SetAutoTuneDetails(v *AutoTuneDetails) *AutoTune {
	s.AutoTuneDetails = v
	return s
}

// SetAutoTuneType sets the AutoTuneType field's value.
func (s *AutoTune) SetAutoTuneType(v string) *AutoTune {
	s.AutoTuneType = &v
	return s
}

// Specifies details about a scheduled Auto-Tune action. For more information,
// see Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type AutoTuneDetails struct {
	_ struct{} `type:"structure"`

	// Container for details about a scheduled Auto-Tune action.
	ScheduledAutoTuneDetails *ScheduledAutoTuneDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneDetails) GoString() string {
	return s.String()
}

// SetScheduledAutoTuneDetails sets the ScheduledAutoTuneDetails field's value.
func (s *AutoTuneDetails) SetScheduledAutoTuneDetails(v *ScheduledAutoTuneDetails) *AutoTuneDetails {
	s.ScheduledAutoTuneDetails = v
	return s
}

// This object is deprecated. Use the domain's off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)
// to schedule Auto-Tune optimizations. For migration instructions, see Migrating
// from Auto-Tune maintenance windows (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html#off-peak-migrate).
//
// The Auto-Tune maintenance schedule. For more information, see Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type AutoTuneMaintenanceSchedule struct {
	_ struct{} `type:"structure"`

	// A cron expression for a recurring maintenance schedule during which Auto-Tune
	// can deploy changes.
	CronExpressionForRecurrence *string `type:"string"`

	// The duration of the maintenance schedule. For example, "Duration": {"Value":
	// 2, "Unit": "HOURS"}.
	Duration *Duration `type:"structure"`

	// The Epoch timestamp at which the Auto-Tune maintenance schedule starts.
	StartAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneMaintenanceSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneMaintenanceSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneMaintenanceSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneMaintenanceSchedule"}
	if s.Duration != nil {
		if err := s.Duration.Validate(); err != nil {
			invalidParams.AddNested("Duration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCronExpressionForRecurrence sets the CronExpressionForRecurrence field's value.
func (s *AutoTuneMaintenanceSchedule) SetCronExpressionForRecurrence(v string) *AutoTuneMaintenanceSchedule {
	s.CronExpressionForRecurrence = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *AutoTuneMaintenanceSchedule) SetDuration(v *Duration) *AutoTuneMaintenanceSchedule {
	s.Duration = v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *AutoTuneMaintenanceSchedule) SetStartAt(v time.Time) *AutoTuneMaintenanceSchedule {
	s.StartAt = &v
	return s
}

// Auto-Tune settings when updating a domain. For more information, see Auto-Tune
// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type AutoTuneOptions struct {
	_ struct{} `type:"structure"`

	// Whether Auto-Tune is enabled or disabled.
	DesiredState *string `type:"string" enum:"AutoTuneDesiredState"`

	// DEPRECATED. Use off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)
	// instead.
	//
	// A list of maintenance schedules during which Auto-Tune can deploy changes.
	MaintenanceSchedules []*AutoTuneMaintenanceSchedule `type:"list"`

	// When disabling Auto-Tune, specify NO_ROLLBACK to retain all prior Auto-Tune
	// settings or DEFAULT_ROLLBACK to revert to the OpenSearch Service defaults.
	// If you specify DEFAULT_ROLLBACK, you must include a MaintenanceSchedule in
	// the request. Otherwise, OpenSearch Service is unable to perform the rollback.
	RollbackOnDisable *string `type:"string" enum:"RollbackOnDisable"`

	// Whether to use the domain's off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html)
	// to deploy configuration changes on the domain rather than a maintenance schedule.
	UseOffPeakWindow *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneOptions"}
	if s.MaintenanceSchedules != nil {
		for i, v := range s.MaintenanceSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MaintenanceSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *AutoTuneOptions) SetDesiredState(v string) *AutoTuneOptions {
	s.DesiredState = &v
	return s
}

// SetMaintenanceSchedules sets the MaintenanceSchedules field's value.
func (s *AutoTuneOptions) SetMaintenanceSchedules(v []*AutoTuneMaintenanceSchedule) *AutoTuneOptions {
	s.MaintenanceSchedules = v
	return s
}

// SetRollbackOnDisable sets the RollbackOnDisable field's value.
func (s *AutoTuneOptions) SetRollbackOnDisable(v string) *AutoTuneOptions {
	s.RollbackOnDisable = &v
	return s
}

// SetUseOffPeakWindow sets the UseOffPeakWindow field's value.
func (s *AutoTuneOptions) SetUseOffPeakWindow(v bool) *AutoTuneOptions {
	s.UseOffPeakWindow = &v
	return s
}

// Options for configuring Auto-Tune. For more information, see Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
type AutoTuneOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// Whether Auto-Tune is enabled or disabled.
	DesiredState *string `type:"string" enum:"AutoTuneDesiredState"`

	// A list of maintenance schedules during which Auto-Tune can deploy changes.
	// Maintenance windows are deprecated and have been replaced with off-peak windows
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html).
	MaintenanceSchedules []*AutoTuneMaintenanceSchedule `type:"list"`

	// Whether to schedule Auto-Tune optimizations that require blue/green deployments
	// during the domain's configured daily off-peak window.
	UseOffPeakWindow *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneOptionsInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneOptionsInput_"}
	if s.MaintenanceSchedules != nil {
		for i, v := range s.MaintenanceSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MaintenanceSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *AutoTuneOptionsInput_) SetDesiredState(v string) *AutoTuneOptionsInput_ {
	s.DesiredState = &v
	return s
}

// SetMaintenanceSchedules sets the MaintenanceSchedules field's value.
func (s *AutoTuneOptionsInput_) SetMaintenanceSchedules(v []*AutoTuneMaintenanceSchedule) *AutoTuneOptionsInput_ {
	s.MaintenanceSchedules = v
	return s
}

// SetUseOffPeakWindow sets the UseOffPeakWindow field's value.
func (s *AutoTuneOptionsInput_) SetUseOffPeakWindow(v bool) *AutoTuneOptionsInput_ {
	s.UseOffPeakWindow = &v
	return s
}

// The Auto-Tune settings for a domain, displayed when enabling or disabling
// Auto-Tune.
type AutoTuneOptionsOutput_ struct {
	_ struct{} `type:"structure"`

	// Any errors that occurred while enabling or disabling Auto-Tune.
	ErrorMessage *string `type:"string"`

	// The current state of Auto-Tune on the domain.
	State *string `type:"string" enum:"AutoTuneState"`

	// Whether the domain's off-peak window will be used to deploy Auto-Tune changes
	// rather than a maintenance schedule.
	UseOffPeakWindow *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsOutput_) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AutoTuneOptionsOutput_) SetErrorMessage(v string) *AutoTuneOptionsOutput_ {
	s.ErrorMessage = &v
	return s
}

// SetState sets the State field's value.
func (s *AutoTuneOptionsOutput_) SetState(v string) *AutoTuneOptionsOutput_ {
	s.State = &v
	return s
}

// SetUseOffPeakWindow sets the UseOffPeakWindow field's value.
func (s *AutoTuneOptionsOutput_) SetUseOffPeakWindow(v bool) *AutoTuneOptionsOutput_ {
	s.UseOffPeakWindow = &v
	return s
}

// The Auto-Tune status for the domain.
type AutoTuneOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Auto-Tune settings for updating a domain.
	Options *AutoTuneOptions `type:"structure"`

	// The current status of Auto-Tune for a domain.
	Status *AutoTuneStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AutoTuneOptionsStatus) SetOptions(v *AutoTuneOptions) *AutoTuneOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoTuneOptionsStatus) SetStatus(v *AutoTuneStatus) *AutoTuneOptionsStatus {
	s.Status = v
	return s
}

// The current status of Auto-Tune for the domain. For more information, see
// Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type AutoTuneStatus struct {
	_ struct{} `type:"structure"`

	// Date and time when Auto-Tune was enabled for the domain.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Any errors that occurred while enabling or disabling Auto-Tune.
	ErrorMessage *string `type:"string"`

	// Indicates whether the domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// The current state of Auto-Tune on the domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"AutoTuneState"`

	// Date and time when the Auto-Tune options were last updated for the domain.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// The latest version of the Auto-Tune options.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AutoTuneStatus) SetCreationDate(v time.Time) *AutoTuneStatus {
	s.CreationDate = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AutoTuneStatus) SetErrorMessage(v string) *AutoTuneStatus {
	s.ErrorMessage = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *AutoTuneStatus) SetPendingDeletion(v bool) *AutoTuneStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *AutoTuneStatus) SetState(v string) *AutoTuneStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *AutoTuneStatus) SetUpdateDate(v time.Time) *AutoTuneStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *AutoTuneStatus) SetUpdateVersion(v int64) *AutoTuneStatus {
	s.UpdateVersion = &v
	return s
}

// Information about an Availability Zone on a domain.
type AvailabilityZoneInfo struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	AvailabilityZoneName *string `min:"1" type:"string"`

	// The number of data nodes active in the Availability Zone.
	AvailableDataNodeCount *string `type:"string"`

	// The total number of data nodes configured in the Availability Zone.
	ConfiguredDataNodeCount *string `type:"string"`

	// The total number of primary and replica shards in the Availability Zone.
	TotalShards *string `type:"string"`

	// The total number of primary and replica shards that aren't allocated to any
	// of the nodes in the Availability Zone.
	TotalUnAssignedShards *string `type:"string"`

	// The current state of the Availability Zone. Current options are Active and
	// StandBy.
	//
	//    * Active - Data nodes in the Availability Zone are in use.
	//
	//    * StandBy - Data nodes in the Availability Zone are in a standby state.
	//
	//    * NotAvailable - Unable to retrieve information.
	ZoneStatus *string `type:"string" enum:"ZoneStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZoneInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZoneInfo) GoString() string {
	return s.String()
}

// SetAvailabilityZoneName sets the AvailabilityZoneName field's value.
func (s *AvailabilityZoneInfo) SetAvailabilityZoneName(v string) *AvailabilityZoneInfo {
	s.AvailabilityZoneName = &v
	return s
}

// SetAvailableDataNodeCount sets the AvailableDataNodeCount field's value.
func (s *AvailabilityZoneInfo) SetAvailableDataNodeCount(v string) *AvailabilityZoneInfo {
	s.AvailableDataNodeCount = &v
	return s
}

// SetConfiguredDataNodeCount sets the ConfiguredDataNodeCount field's value.
func (s *AvailabilityZoneInfo) SetConfiguredDataNodeCount(v string) *AvailabilityZoneInfo {
	s.ConfiguredDataNodeCount = &v
	return s
}

// SetTotalShards sets the TotalShards field's value.
func (s *AvailabilityZoneInfo) SetTotalShards(v string) *AvailabilityZoneInfo {
	s.TotalShards = &v
	return s
}

// SetTotalUnAssignedShards sets the TotalUnAssignedShards field's value.
func (s *AvailabilityZoneInfo) SetTotalUnAssignedShards(v string) *AvailabilityZoneInfo {
	s.TotalUnAssignedShards = &v
	return s
}

// SetZoneStatus sets the ZoneStatus field's value.
func (s *AvailabilityZoneInfo) SetZoneStatus(v string) *AvailabilityZoneInfo {
	s.ZoneStatus = &v
	return s
}

// An error occurred while processing the request.
type BaseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseException) GoString() string {
	return s.String()
}

func newErrorBaseException(v protocol.ResponseMetadata) error {
	return &BaseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BaseException) Code() string {
	return "BaseException"
}

// Message returns the exception's message.
func (s *BaseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BaseException) OrigErr() error {
	return nil
}

func (s *BaseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BaseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BaseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for the request parameters to cancel a service software update.
type CancelServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// Name of the OpenSearch Service domain that you want to cancel the service
	// software update on.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CancelServiceSoftwareUpdateInput) SetDomainName(v string) *CancelServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// Container for the response to a CancelServiceSoftwareUpdate operation. Contains
// the status of the update.
type CancelServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// Container for the state of your domain relative to the latest service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *CancelServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *CancelServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// Container for information about a configuration change happening on a domain.
type ChangeProgressDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the configuration change.
	ChangeId *string `min:"36" type:"string"`

	// A message corresponding to the status of the configuration change.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressDetails) GoString() string {
	return s.String()
}

// SetChangeId sets the ChangeId field's value.
func (s *ChangeProgressDetails) SetChangeId(v string) *ChangeProgressDetails {
	s.ChangeId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ChangeProgressDetails) SetMessage(v string) *ChangeProgressDetails {
	s.Message = &v
	return s
}

// Progress details for each stage of a domain update.
type ChangeProgressStage struct {
	_ struct{} `type:"structure"`

	// The description of the stage.
	Description *string `type:"string"`

	// The most recent updated timestamp of the stage.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the stage.
	Name *string `min:"1" type:"string"`

	// The status of the stage.
	Status *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStage) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ChangeProgressStage) SetDescription(v string) *ChangeProgressStage {
	s.Description = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *ChangeProgressStage) SetLastUpdated(v time.Time) *ChangeProgressStage {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChangeProgressStage) SetName(v string) *ChangeProgressStage {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeProgressStage) SetStatus(v string) *ChangeProgressStage {
	s.Status = &v
	return s
}

// The progress details of a specific domain configuration change.
type ChangeProgressStatusDetails struct {
	_ struct{} `type:"structure"`

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string `min:"36" type:"string"`

	// The specific stages that the domain is going through to perform the configuration
	// change.
	ChangeProgressStages []*ChangeProgressStage `type:"list"`

	// The list of properties in the domain configuration change that have completed.
	CompletedProperties []*string `type:"list"`

	// The list of properties in the domain configuration change that are still
	// pending.
	PendingProperties []*string `type:"list"`

	// The time at which the configuration change is made on the domain.
	StartTime *time.Time `type:"timestamp"`

	// The overall status of the domain configuration change.
	Status *string `type:"string" enum:"OverallChangeStatus"`

	// The total number of stages required for the configuration change.
	TotalNumberOfStages *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeProgressStatusDetails) GoString() string {
	return s.String()
}

// SetChangeId sets the ChangeId field's value.
func (s *ChangeProgressStatusDetails) SetChangeId(v string) *ChangeProgressStatusDetails {
	s.ChangeId = &v
	return s
}

// SetChangeProgressStages sets the ChangeProgressStages field's value.
func (s *ChangeProgressStatusDetails) SetChangeProgressStages(v []*ChangeProgressStage) *ChangeProgressStatusDetails {
	s.ChangeProgressStages = v
	return s
}

// SetCompletedProperties sets the CompletedProperties field's value.
func (s *ChangeProgressStatusDetails) SetCompletedProperties(v []*string) *ChangeProgressStatusDetails {
	s.CompletedProperties = v
	return s
}

// SetPendingProperties sets the PendingProperties field's value.
func (s *ChangeProgressStatusDetails) SetPendingProperties(v []*string) *ChangeProgressStatusDetails {
	s.PendingProperties = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ChangeProgressStatusDetails) SetStartTime(v time.Time) *ChangeProgressStatusDetails {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeProgressStatusDetails) SetStatus(v string) *ChangeProgressStatusDetails {
	s.Status = &v
	return s
}

// SetTotalNumberOfStages sets the TotalNumberOfStages field's value.
func (s *ChangeProgressStatusDetails) SetTotalNumberOfStages(v int64) *ChangeProgressStatusDetails {
	s.TotalNumberOfStages = &v
	return s
}

// Container for the cluster configuration of an OpenSearch Service domain.
// For more information, see Creating and managing Amazon OpenSearch Service
// domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
type ClusterConfig struct {
	_ struct{} `type:"structure"`

	// Container for cold storage configuration options.
	ColdStorageOptions *ColdStorageOptions `type:"structure"`

	// Number of dedicated master nodes in the cluster. This number must be greater
	// than 2 and not 4, otherwise you receive a validation exception.
	DedicatedMasterCount *int64 `type:"integer"`

	// Indicates whether dedicated master nodes are enabled for the cluster.True
	// if the cluster will use a dedicated master node.False if the cluster will
	// not.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// OpenSearch Service instance type of the dedicated master nodes in the cluster.
	DedicatedMasterType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// Number of data nodes in the cluster. This number must be greater than 1,
	// otherwise you receive a validation exception.
	InstanceCount *int64 `type:"integer"`

	// Instance type of data nodes in the cluster.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// A boolean that indicates whether a multi-AZ domain is turned on with a standby
	// AZ. For more information, see Configuring a multi-AZ domain in Amazon OpenSearch
	// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
	MultiAZWithStandbyEnabled *bool `type:"boolean"`

	// The number of warm nodes in the cluster.
	WarmCount *int64 `type:"integer"`

	// Whether to enable warm storage for the cluster.
	WarmEnabled *bool `type:"boolean"`

	// The instance type for the cluster's warm nodes.
	WarmType *string `type:"string" enum:"OpenSearchWarmPartitionInstanceType"`

	// Container for zone awareness configuration options. Only required if ZoneAwarenessEnabled
	// is true.
	ZoneAwarenessConfig *ZoneAwarenessConfig `type:"structure"`

	// Indicates whether multiple Availability Zones are enabled. For more information,
	// see Configuring a multi-AZ domain in Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClusterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClusterConfig"}
	if s.ColdStorageOptions != nil {
		if err := s.ColdStorageOptions.Validate(); err != nil {
			invalidParams.AddNested("ColdStorageOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColdStorageOptions sets the ColdStorageOptions field's value.
func (s *ClusterConfig) SetColdStorageOptions(v *ColdStorageOptions) *ClusterConfig {
	s.ColdStorageOptions = v
	return s
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *ClusterConfig) SetDedicatedMasterCount(v int64) *ClusterConfig {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *ClusterConfig) SetDedicatedMasterEnabled(v bool) *ClusterConfig {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *ClusterConfig) SetDedicatedMasterType(v string) *ClusterConfig {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ClusterConfig) SetInstanceCount(v int64) *ClusterConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ClusterConfig) SetInstanceType(v string) *ClusterConfig {
	s.InstanceType = &v
	return s
}

// SetMultiAZWithStandbyEnabled sets the MultiAZWithStandbyEnabled field's value.
func (s *ClusterConfig) SetMultiAZWithStandbyEnabled(v bool) *ClusterConfig {
	s.MultiAZWithStandbyEnabled = &v
	return s
}

// SetWarmCount sets the WarmCount field's value.
func (s *ClusterConfig) SetWarmCount(v int64) *ClusterConfig {
	s.WarmCount = &v
	return s
}

// SetWarmEnabled sets the WarmEnabled field's value.
func (s *ClusterConfig) SetWarmEnabled(v bool) *ClusterConfig {
	s.WarmEnabled = &v
	return s
}

// SetWarmType sets the WarmType field's value.
func (s *ClusterConfig) SetWarmType(v string) *ClusterConfig {
	s.WarmType = &v
	return s
}

// SetZoneAwarenessConfig sets the ZoneAwarenessConfig field's value.
func (s *ClusterConfig) SetZoneAwarenessConfig(v *ZoneAwarenessConfig) *ClusterConfig {
	s.ZoneAwarenessConfig = v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *ClusterConfig) SetZoneAwarenessEnabled(v bool) *ClusterConfig {
	s.ZoneAwarenessEnabled = &v
	return s
}

// The cluster configuration status for a domain.
type ClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// Cluster configuration options for the specified domain.
	//
	// Options is a required field
	Options *ClusterConfig `type:"structure" required:"true"`

	// The status of cluster configuration options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfigStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ClusterConfigStatus) SetOptions(v *ClusterConfig) *ClusterConfigStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterConfigStatus) SetStatus(v *OptionStatus) *ClusterConfigStatus {
	s.Status = v
	return s
}

// Container for the parameters required to enable Cognito authentication for
// an OpenSearch Service domain. For more information, see Configuring Amazon
// Cognito authentication for OpenSearch Dashboards (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
type CognitoOptions struct {
	_ struct{} `type:"structure"`

	// Whether to enable or disable Amazon Cognito authentication for OpenSearch
	// Dashboards.
	Enabled *bool `type:"boolean"`

	// The Amazon Cognito identity pool ID that you want OpenSearch Service to use
	// for OpenSearch Dashboards authentication.
	IdentityPoolId *string `min:"1" type:"string"`

	// The AmazonOpenSearchServiceCognitoAccess role that allows OpenSearch Service
	// to configure your user pool and identity pool.
	RoleArn *string `min:"20" type:"string"`

	// The Amazon Cognito user pool ID that you want OpenSearch Service to use for
	// OpenSearch Dashboards authentication.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoOptions"}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CognitoOptions) SetEnabled(v bool) *CognitoOptions {
	s.Enabled = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *CognitoOptions) SetIdentityPoolId(v string) *CognitoOptions {
	s.IdentityPoolId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CognitoOptions) SetRoleArn(v string) *CognitoOptions {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CognitoOptions) SetUserPoolId(v string) *CognitoOptions {
	s.UserPoolId = &v
	return s
}

// The status of the Cognito options for the specified domain.
type CognitoOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Cognito options for the specified domain.
	//
	// Options is a required field
	Options *CognitoOptions `type:"structure" required:"true"`

	// The status of the Cognito options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *CognitoOptionsStatus) SetOptions(v *CognitoOptions) *CognitoOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CognitoOptionsStatus) SetStatus(v *OptionStatus) *CognitoOptionsStatus {
	s.Status = v
	return s
}

// Container for the parameters required to enable cold storage for an OpenSearch
// Service domain. For more information, see Cold storage for Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cold-storage.html).
type ColdStorageOptions struct {
	_ struct{} `type:"structure"`

	// Whether to enable or disable cold storage on the domain.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColdStorageOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColdStorageOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColdStorageOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColdStorageOptions"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ColdStorageOptions) SetEnabled(v bool) *ColdStorageOptions {
	s.Enabled = &v
	return s
}

// A map of OpenSearch or Elasticsearch versions and the versions you can upgrade
// them to.
type CompatibleVersionsMap struct {
	_ struct{} `type:"structure"`

	// The current version that the OpenSearch Service domain is running.
	SourceVersion *string `min:"14" type:"string"`

	// The possible versions that you can upgrade the domain to.
	TargetVersions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleVersionsMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleVersionsMap) GoString() string {
	return s.String()
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CompatibleVersionsMap) SetSourceVersion(v string) *CompatibleVersionsMap {
	s.SourceVersion = &v
	return s
}

// SetTargetVersions sets the TargetVersions field's value.
func (s *CompatibleVersionsMap) SetTargetVersions(v []*string) *CompatibleVersionsMap {
	s.TargetVersions = v
	return s
}

// An error occurred because the client attempts to remove a resource that is
// currently in use.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The connection properties of an outbound connection.
type ConnectionProperties struct {
	_ struct{} `type:"structure"`

	// The connection properties for cross cluster search.
	CrossClusterSearch *CrossClusterSearchConnectionProperties `type:"structure"`

	//
	// The Endpoint attribute cannot be modified.
	//
	// The endpoint of the remote domain. Applicable for VPC_ENDPOINT connection
	// mode.
	Endpoint *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionProperties) GoString() string {
	return s.String()
}

// SetCrossClusterSearch sets the CrossClusterSearch field's value.
func (s *ConnectionProperties) SetCrossClusterSearch(v *CrossClusterSearchConnectionProperties) *ConnectionProperties {
	s.CrossClusterSearch = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ConnectionProperties) SetEndpoint(v string) *ConnectionProperties {
	s.Endpoint = &v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// Identity and Access Management (IAM) policy document specifying the access
	// policies for the new domain.
	AccessPolicies *string `type:"string"`

	// Key-value pairs to specify advanced configuration options. The following
	// key-value pairs are supported:
	//
	//    * "rest.action.multi.allow_explicit_index": "true" | "false" - Note the
	//    use of a string rather than a boolean. Specifies whether explicit references
	//    to indexes are allowed inside the body of HTTP requests. If you want to
	//    configure access policies for domain sub-resources, such as specific indexes
	//    and domain APIs, you must disable this property. Default is true.
	//
	//    * "indices.fielddata.cache.size": "80" - Note the use of a string rather
	//    than a boolean. Specifies the percentage of heap space allocated to field
	//    data. Default is unbounded.
	//
	//    * "indices.query.bool.max_clause_count": "1024" - Note the use of a string
	//    rather than a boolean. Specifies the maximum number of clauses allowed
	//    in a Lucene boolean query. Default is 1,024. Queries with more than the
	//    permitted number of clauses result in a TooManyClauses error.
	//
	//    * "override_main_response_version": "true" | "false" - Note the use of
	//    a string rather than a boolean. Specifies whether the domain reports its
	//    version as 7.10 to allow Elasticsearch OSS clients and plugins to continue
	//    working with it. Default is false when creating a domain and true when
	//    upgrading a domain.
	//
	// For more information, see Advanced cluster parameters (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions map[string]*string `type:"map"`

	// Options for fine-grained access control.
	AdvancedSecurityOptions *AdvancedSecurityOptionsInput_ `type:"structure"`

	// Options for Auto-Tune.
	AutoTuneOptions *AutoTuneOptionsInput_ `type:"structure"`

	// Container for the cluster configuration of a domain.
	ClusterConfig *ClusterConfig `type:"structure"`

	// Key-value pairs to configure Amazon Cognito authentication. For more information,
	// see Configuring Amazon Cognito authentication for OpenSearch Dashboards (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// Additional options for the domain endpoint, such as whether to require HTTPS
	// for all traffic.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// Name of the OpenSearch Service domain to create. Domain names are unique
	// across the domains owned by an account within an Amazon Web Services Region.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Container for the parameters required to enable EBS-based storage for an
	// OpenSearch Service domain.
	EBSOptions *EBSOptions `type:"structure"`

	// Key-value pairs to enable encryption at rest.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine
	// version for the OpenSearch Service domain. For example, OpenSearch_1.0 or
	// Elasticsearch_7.9. For more information, see Creating and managing Amazon
	// OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
	EngineVersion *string `min:"14" type:"string"`

	// The type of IP addresses supported by the endpoint for the domain.
	IPAddressType *string `type:"string" enum:"IPAddressType"`

	// Key-value pairs to configure log publishing.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Enables node-to-node encryption.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Specifies a daily 10-hour time block during which OpenSearch Service can
	// perform configuration changes on the domain, including service software updates
	// and Auto-Tune enhancements that require a blue/green deployment. If no options
	// are specified, the default start time of 10:00 P.M. local time (for the Region
	// that the domain is created in) is used.
	OffPeakWindowOptions *OffPeakWindowOptions `type:"structure"`

	// DEPRECATED. Container for the parameters required to configure automated
	// snapshots of domain indexes.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Software update options for the domain.
	SoftwareUpdateOptions *SoftwareUpdateOptions `type:"structure"`

	// List of tags to add to the domain upon creation.
	TagList []*Tag `type:"list"`

	// Container for the values required to configure VPC access domains. If you
	// don't specify these values, OpenSearch Service creates the domain with a
	// public endpoint. For more information, see Launching your Amazon OpenSearch
	// Service domains using a VPC (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.EngineVersion != nil && len(*s.EngineVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EngineVersion", 14))
	}
	if s.AdvancedSecurityOptions != nil {
		if err := s.AdvancedSecurityOptions.Validate(); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoTuneOptions != nil {
		if err := s.AutoTuneOptions.Validate(); err != nil {
			invalidParams.AddNested("AutoTuneOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ClusterConfig != nil {
		if err := s.ClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DomainEndpointOptions != nil {
		if err := s.DomainEndpointOptions.Validate(); err != nil {
			invalidParams.AddNested("DomainEndpointOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LogPublishingOptions != nil {
		for i, v := range s.LogPublishingOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogPublishingOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OffPeakWindowOptions != nil {
		if err := s.OffPeakWindowOptions.Validate(); err != nil {
			invalidParams.AddNested("OffPeakWindowOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateDomainInput) SetAccessPolicies(v string) *CreateDomainInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *CreateDomainInput) SetAdvancedOptions(v map[string]*string) *CreateDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *CreateDomainInput) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsInput_) *CreateDomainInput {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *CreateDomainInput) SetAutoTuneOptions(v *AutoTuneOptionsInput_) *CreateDomainInput {
	s.AutoTuneOptions = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *CreateDomainInput) SetClusterConfig(v *ClusterConfig) *CreateDomainInput {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *CreateDomainInput) SetCognitoOptions(v *CognitoOptions) *CreateDomainInput {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *CreateDomainInput) SetDomainEndpointOptions(v *DomainEndpointOptions) *CreateDomainInput {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *CreateDomainInput) SetEBSOptions(v *EBSOptions) *CreateDomainInput {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *CreateDomainInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *CreateDomainInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDomainInput) SetEngineVersion(v string) *CreateDomainInput {
	s.EngineVersion = &v
	return s
}

// SetIPAddressType sets the IPAddressType field's value.
func (s *CreateDomainInput) SetIPAddressType(v string) *CreateDomainInput {
	s.IPAddressType = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *CreateDomainInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *CreateDomainInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *CreateDomainInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *CreateDomainInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetOffPeakWindowOptions sets the OffPeakWindowOptions field's value.
func (s *CreateDomainInput) SetOffPeakWindowOptions(v *OffPeakWindowOptions) *CreateDomainInput {
	s.OffPeakWindowOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *CreateDomainInput) SetSnapshotOptions(v *SnapshotOptions) *CreateDomainInput {
	s.SnapshotOptions = v
	return s
}

// SetSoftwareUpdateOptions sets the SoftwareUpdateOptions field's value.
func (s *CreateDomainInput) SetSoftwareUpdateOptions(v *SoftwareUpdateOptions) *CreateDomainInput {
	s.SoftwareUpdateOptions = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *CreateDomainInput) SetTagList(v []*Tag) *CreateDomainInput {
	s.TagList = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *CreateDomainInput) SetVPCOptions(v *VPCOptions) *CreateDomainInput {
	s.VPCOptions = v
	return s
}

// The result of a CreateDomain operation. Contains the status of the newly
// created domain.
type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the newly created domain.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateDomainOutput) SetDomainStatus(v *DomainStatus) *CreateDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the CreateOutboundConnection operation.
type CreateOutboundConnectionInput struct {
	_ struct{} `type:"structure"`

	// Name of the connection.
	//
	// ConnectionAlias is a required field
	ConnectionAlias *string `min:"2" type:"string" required:"true"`

	// The connection mode.
	ConnectionMode *string `type:"string" enum:"ConnectionMode"`

	// The ConnectionProperties for the outbound connection.
	ConnectionProperties *ConnectionProperties `type:"structure"`

	// Name and Region of the source (local) domain.
	//
	// LocalDomainInfo is a required field
	LocalDomainInfo *DomainInformationContainer `type:"structure" required:"true"`

	// Name and Region of the destination (remote) domain.
	//
	// RemoteDomainInfo is a required field
	RemoteDomainInfo *DomainInformationContainer `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOutboundConnectionInput"}
	if s.ConnectionAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionAlias"))
	}
	if s.ConnectionAlias != nil && len(*s.ConnectionAlias) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionAlias", 2))
	}
	if s.LocalDomainInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalDomainInfo"))
	}
	if s.RemoteDomainInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainInfo"))
	}
	if s.LocalDomainInfo != nil {
		if err := s.LocalDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("LocalDomainInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.RemoteDomainInfo != nil {
		if err := s.RemoteDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("RemoteDomainInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *CreateOutboundConnectionInput) SetConnectionAlias(v string) *CreateOutboundConnectionInput {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *CreateOutboundConnectionInput) SetConnectionMode(v string) *CreateOutboundConnectionInput {
	s.ConnectionMode = &v
	return s
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *CreateOutboundConnectionInput) SetConnectionProperties(v *ConnectionProperties) *CreateOutboundConnectionInput {
	s.ConnectionProperties = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *CreateOutboundConnectionInput) SetLocalDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionInput {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *CreateOutboundConnectionInput) SetRemoteDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionInput {
	s.RemoteDomainInfo = v
	return s
}

// The result of a CreateOutboundConnection request. Contains details about
// the newly created cross-cluster connection.
type CreateOutboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Name of the connection.
	ConnectionAlias *string `min:"2" type:"string"`

	// The unique identifier for the created outbound connection, which is used
	// for subsequent operations on the connection.
	ConnectionId *string `min:"10" type:"string"`

	// The connection mode.
	ConnectionMode *string `type:"string" enum:"ConnectionMode"`

	// The ConnectionProperties for the newly created connection.
	ConnectionProperties *ConnectionProperties `type:"structure"`

	// The status of the connection.
	ConnectionStatus *OutboundConnectionStatus `type:"structure"`

	// Information about the source (local) domain.
	LocalDomainInfo *DomainInformationContainer `type:"structure"`

	// Information about the destination (remote) domain.
	RemoteDomainInfo *DomainInformationContainer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionAlias(v string) *CreateOutboundConnectionOutput {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionId(v string) *CreateOutboundConnectionOutput {
	s.ConnectionId = &v
	return s
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionMode(v string) *CreateOutboundConnectionOutput {
	s.ConnectionMode = &v
	return s
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionProperties(v *ConnectionProperties) *CreateOutboundConnectionOutput {
	s.ConnectionProperties = v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionStatus(v *OutboundConnectionStatus) *CreateOutboundConnectionOutput {
	s.ConnectionStatus = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *CreateOutboundConnectionOutput) SetLocalDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionOutput {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *CreateOutboundConnectionOutput) SetRemoteDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionOutput {
	s.RemoteDomainInfo = v
	return s
}

// Container for request parameters to the CreatePackage operation.
type CreatePackageInput struct {
	_ struct{} `type:"structure"`

	// Description of the package.
	PackageDescription *string `type:"string"`

	// Unique name for the package.
	//
	// PackageName is a required field
	PackageName *string `min:"3" type:"string" required:"true"`

	// The Amazon S3 location from which to import the package.
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`

	// The type of package.
	//
	// PackageType is a required field
	PackageType *string `type:"string" required:"true" enum:"PackageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackageInput"}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 3))
	}
	if s.PackageSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageSource"))
	}
	if s.PackageType == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageType"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *CreatePackageInput) SetPackageDescription(v string) *CreatePackageInput {
	s.PackageDescription = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *CreatePackageInput) SetPackageName(v string) *CreatePackageInput {
	s.PackageName = &v
	return s
}

// SetPackageSource sets the PackageSource field's value.
func (s *CreatePackageInput) SetPackageSource(v *PackageSource) *CreatePackageInput {
	s.PackageSource = v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *CreatePackageInput) SetPackageType(v string) *CreatePackageInput {
	s.PackageType = &v
	return s
}

// Container for the response returned by the CreatePackage operation.
type CreatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Basic information about an OpenSearch Service package.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *CreatePackageOutput) SetPackageDetails(v *PackageDetails) *CreatePackageOutput {
	s.PackageDetails = v
	return s
}

type CreateVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the domain to create the endpoint for.
	//
	// DomainArn is a required field
	DomainArn *string `min:"1" type:"string" required:"true"`

	// Options to specify the subnets and security groups for the endpoint.
	//
	// VpcOptions is a required field
	VpcOptions *VPCOptions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcEndpointInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainArn"))
	}
	if s.DomainArn != nil && len(*s.DomainArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainArn", 1))
	}
	if s.VpcOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVpcEndpointInput) SetClientToken(v string) *CreateVpcEndpointInput {
	s.ClientToken = &v
	return s
}

// SetDomainArn sets the DomainArn field's value.
func (s *CreateVpcEndpointInput) SetDomainArn(v string) *CreateVpcEndpointInput {
	s.DomainArn = &v
	return s
}

// SetVpcOptions sets the VpcOptions field's value.
func (s *CreateVpcEndpointInput) SetVpcOptions(v *VPCOptions) *CreateVpcEndpointInput {
	s.VpcOptions = v
	return s
}

type CreateVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created VPC endpoint.
	//
	// VpcEndpoint is a required field
	VpcEndpoint *VpcEndpoint `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetVpcEndpoint sets the VpcEndpoint field's value.
func (s *CreateVpcEndpointOutput) SetVpcEndpoint(v *VpcEndpoint) *CreateVpcEndpointOutput {
	s.VpcEndpoint = v
	return s
}

// Cross-cluster search specific connection properties.
type CrossClusterSearchConnectionProperties struct {
	_ struct{} `type:"structure"`

	// The status of the SkipUnavailable setting for the outbound connection. This
	// feature allows you to specify some clusters as optional and ensure that your
	// cross-cluster queries return partial results despite failures on one or more
	// remote clusters.
	SkipUnavailable *string `type:"string" enum:"SkipUnavailableStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossClusterSearchConnectionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossClusterSearchConnectionProperties) GoString() string {
	return s.String()
}

// SetSkipUnavailable sets the SkipUnavailable field's value.
func (s *CrossClusterSearchConnectionProperties) SetSkipUnavailable(v string) *CrossClusterSearchConnectionProperties {
	s.SkipUnavailable = &v
	return s
}

// Details about a direct-query data source.
type DataSourceDetails struct {
	_ struct{} `type:"structure"`

	// The type of data source.
	DataSourceType *DataSourceType `type:"structure"`

	// A description of the data source.
	Description *string `type:"string"`

	// The name of the data source.
	Name *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceDetails) GoString() string {
	return s.String()
}

// SetDataSourceType sets the DataSourceType field's value.
func (s *DataSourceDetails) SetDataSourceType(v *DataSourceType) *DataSourceDetails {
	s.DataSourceType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSourceDetails) SetDescription(v string) *DataSourceDetails {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSourceDetails) SetName(v string) *DataSourceDetails {
	s.Name = &v
	return s
}

// The type of data source.
type DataSourceType struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 data source.
	S3GlueDataCatalog *S3GlueDataCatalog `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceType"}
	if s.S3GlueDataCatalog != nil {
		if err := s.S3GlueDataCatalog.Validate(); err != nil {
			invalidParams.AddNested("S3GlueDataCatalog", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3GlueDataCatalog sets the S3GlueDataCatalog field's value.
func (s *DataSourceType) SetS3GlueDataCatalog(v *S3GlueDataCatalog) *DataSourceType {
	s.S3GlueDataCatalog = v
	return s
}

// Container for the parameters to the DeleteDataSource operation.
type DeleteDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The name of the data source to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"DataSourceName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDataSourceInput) SetDomainName(v string) *DeleteDataSourceInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDataSourceInput) SetName(v string) *DeleteDataSourceInput {
	s.Name = &v
	return s
}

// The result of a GetDataSource operation.
type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A message associated with deletion of the data source.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteDataSourceOutput) SetMessage(v string) *DeleteDataSourceOutput {
	s.Message = &v
	return s
}

// Container for the parameters to the DeleteDomain operation.
type DeleteDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

// The results of a DeleteDomain request. Contains the status of the pending
// deletion, or a "domain not found" error if the domain and all of its resources
// have been deleted.
type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domain being deleted.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DeleteDomainOutput) SetDomainStatus(v *DomainStatus) *DeleteDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DeleteInboundConnection operation.
type DeleteInboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the inbound connection to permanently delete.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteInboundConnectionInput) SetConnectionId(v string) *DeleteInboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// The results of a DeleteInboundConnection operation. Contains details about
// the deleted inbound connection.
type DeleteInboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The deleted inbound connection.
	Connection *InboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteInboundConnectionOutput) SetConnection(v *InboundConnection) *DeleteInboundConnectionOutput {
	s.Connection = v
	return s
}

// Container for the parameters to the DeleteOutboundConnection operation.
type DeleteOutboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the outbound connection you want to permanently delete.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOutboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteOutboundConnectionInput) SetConnectionId(v string) *DeleteOutboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// Details about the deleted outbound connection.
type DeleteOutboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The deleted inbound connection.
	Connection *OutboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteOutboundConnectionOutput) SetConnection(v *OutboundConnection) *DeleteOutboundConnectionOutput {
	s.Connection = v
	return s
}

// Deletes a package from OpenSearch Service. The package can't be associated
// with any OpenSearch Service domain.
type DeletePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The internal ID of the package you want to delete. Use DescribePackages to
	// find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageID sets the PackageID field's value.
func (s *DeletePackageInput) SetPackageID(v string) *DeletePackageInput {
	s.PackageID = &v
	return s
}

// Container for the response parameters to the DeletePackage operation.
type DeletePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted package.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *DeletePackageOutput) SetPackageDetails(v *PackageDetails) *DeletePackageOutput {
	s.PackageDetails = v
	return s
}

type DeleteVpcEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the endpoint.
	//
	// VpcEndpointId is a required field
	VpcEndpointId *string `location:"uri" locationName:"VpcEndpointId" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcEndpointInput"}
	if s.VpcEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcEndpointId"))
	}
	if s.VpcEndpointId != nil && len(*s.VpcEndpointId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("VpcEndpointId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *DeleteVpcEndpointInput) SetVpcEndpointId(v string) *DeleteVpcEndpointInput {
	s.VpcEndpointId = &v
	return s
}

type DeleteVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted endpoint, including its current status (DELETING
	// or DELETE_FAILED).
	//
	// VpcEndpointSummary is a required field
	VpcEndpointSummary *VpcEndpointSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetVpcEndpointSummary sets the VpcEndpointSummary field's value.
func (s *DeleteVpcEndpointOutput) SetVpcEndpointSummary(v *VpcEndpointSummary) *DeleteVpcEndpointOutput {
	s.VpcEndpointSummary = v
	return s
}

// An exception for when a failure in one of the dependencies results in the
// service being unable to fetch details about the resource.
type DependencyFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailureException) GoString() string {
	return s.String()
}

func newErrorDependencyFailureException(v protocol.ResponseMetadata) error {
	return &DependencyFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyFailureException) Code() string {
	return "DependencyFailureException"
}

// Message returns the exception's message.
func (s *DependencyFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyFailureException) OrigErr() error {
	return nil
}

func (s *DependencyFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for the parameters to the DescribeDomainAutoTunes operation.
type DescribeDomainAutoTunesInput struct {
	_ struct{} `type:"structure"`

	// Name of the domain that you want Auto-Tune details about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `type:"integer"`

	// If your initial DescribeDomainAutoTunes operation returns a nextToken, you
	// can include the returned nextToken in subsequent DescribeDomainAutoTunes
	// operations, which returns results in the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainAutoTunesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainAutoTunesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainAutoTunesInput) SetDomainName(v string) *DescribeDomainAutoTunesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDomainAutoTunesInput) SetMaxResults(v int64) *DescribeDomainAutoTunesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainAutoTunesInput) SetNextToken(v string) *DescribeDomainAutoTunesInput {
	s.NextToken = &v
	return s
}

// The result of a DescribeDomainAutoTunes request.
type DescribeDomainAutoTunesOutput struct {
	_ struct{} `type:"structure"`

	// The list of setting adjustments that Auto-Tune has made to the domain.
	AutoTunes []*AutoTune `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesOutput) GoString() string {
	return s.String()
}

// SetAutoTunes sets the AutoTunes field's value.
func (s *DescribeDomainAutoTunesOutput) SetAutoTunes(v []*AutoTune) *DescribeDomainAutoTunesOutput {
	s.AutoTunes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainAutoTunesOutput) SetNextToken(v string) *DescribeDomainAutoTunesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeDomainChangeProgress operation.
type DescribeDomainChangeProgressInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The specific change ID for which you want to get progress information. If
	// omitted, the request returns information about the most recent configuration
	// change.
	ChangeId *string `location:"querystring" locationName:"changeid" min:"36" type:"string"`

	// The name of the domain to get progress information for.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainChangeProgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainChangeProgressInput"}
	if s.ChangeId != nil && len(*s.ChangeId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeId", 36))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeId sets the ChangeId field's value.
func (s *DescribeDomainChangeProgressInput) SetChangeId(v string) *DescribeDomainChangeProgressInput {
	s.ChangeId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainChangeProgressInput) SetDomainName(v string) *DescribeDomainChangeProgressInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeDomainChangeProgress request. Contains progress information
// for the requested domain change.
type DescribeDomainChangeProgressOutput struct {
	_ struct{} `type:"structure"`

	// Container for information about the stages of a configuration change happening
	// on a domain.
	ChangeProgressStatus *ChangeProgressStatusDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainChangeProgressOutput) GoString() string {
	return s.String()
}

// SetChangeProgressStatus sets the ChangeProgressStatus field's value.
func (s *DescribeDomainChangeProgressOutput) SetChangeProgressStatus(v *ChangeProgressStatusDetails) *DescribeDomainChangeProgressOutput {
	s.ChangeProgressStatus = v
	return s
}

// Container for the parameters to the DescribeDomainConfig operation.
type DescribeDomainConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the OpenSearch Service domain configuration that you want to describe.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainConfigInput) SetDomainName(v string) *DescribeDomainConfigInput {
	s.DomainName = &v
	return s
}

// Contains the configuration information of the requested domain.
type DescribeDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// Container for the configuration of the OpenSearch Service domain.
	//
	// DomainConfig is a required field
	DomainConfig *DomainConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeDomainConfigOutput) SetDomainConfig(v *DomainConfig) *DescribeDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for the parameters to the DescribeDomainHealth operation.
type DescribeDomainHealthInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainHealthInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainHealthInput) SetDomainName(v string) *DescribeDomainHealthInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeDomainHealth request. Contains health information
// for the requested domain.
type DescribeDomainHealthOutput struct {
	_ struct{} `type:"structure"`

	// The number of active Availability Zones configured for the domain. If the
	// service is unable to fetch this information, it will return NotAvailable.
	ActiveAvailabilityZoneCount *string `type:"string"`

	// The number of Availability Zones configured for the domain. If the service
	// is unable to fetch this information, it will return NotAvailable.
	AvailabilityZoneCount *string `type:"string"`

	// The current health status of your cluster.
	//
	//    * Red - At least one primary shard is not allocated to any node.
	//
	//    * Yellow - All primary shards are allocated to nodes, but some replicas
	//    aren’t.
	//
	//    * Green - All primary shards and their replicas are allocated to nodes.
	//
	//    * NotAvailable - Unable to retrieve cluster health.
	ClusterHealth *string `type:"string" enum:"DomainHealth"`

	// The number of data nodes configured for the domain. If the service is unable
	// to fetch this information, it will return NotAvailable.
	DataNodeCount *string `type:"string"`

	// A boolean that indicates if dedicated master nodes are activated for the
	// domain.
	DedicatedMaster *bool `type:"boolean"`

	// The current state of the domain.
	//
	//    * Processing - The domain has updates in progress.
	//
	//    * Active - Requested changes have been processed and deployed to the domain.
	DomainState *string `type:"string" enum:"DomainState"`

	// A list of EnvironmentInfo for the domain.
	EnvironmentInformation []*EnvironmentInfo `type:"list"`

	// The number of nodes that can be elected as a master node. If dedicated master
	// nodes is turned on, this value is the number of dedicated master nodes configured
	// for the domain. If the service is unable to fetch this information, it will
	// return NotAvailable.
	MasterEligibleNodeCount *string `type:"string"`

	// Indicates whether the domain has an elected master node.
	//
	//    * Available - The domain has an elected master node.
	//
	//    * UnAvailable - The master node hasn't yet been elected, and a quorum
	//    to elect a new master node hasn't been reached.
	MasterNode *string `type:"string" enum:"MasterNodeStatus"`

	// The number of standby Availability Zones configured for the domain. If the
	// service is unable to fetch this information, it will return NotAvailable.
	StandByAvailabilityZoneCount *string `type:"string"`

	// The total number of primary and replica shards for the domain.
	TotalShards *string `type:"string"`

	// The total number of primary and replica shards not allocated to any of the
	// nodes for the cluster.
	TotalUnAssignedShards *string `type:"string"`

	// The number of warm nodes configured for the domain.
	WarmNodeCount *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainHealthOutput) GoString() string {
	return s.String()
}

// SetActiveAvailabilityZoneCount sets the ActiveAvailabilityZoneCount field's value.
func (s *DescribeDomainHealthOutput) SetActiveAvailabilityZoneCount(v string) *DescribeDomainHealthOutput {
	s.ActiveAvailabilityZoneCount = &v
	return s
}

// SetAvailabilityZoneCount sets the AvailabilityZoneCount field's value.
func (s *DescribeDomainHealthOutput) SetAvailabilityZoneCount(v string) *DescribeDomainHealthOutput {
	s.AvailabilityZoneCount = &v
	return s
}

// SetClusterHealth sets the ClusterHealth field's value.
func (s *DescribeDomainHealthOutput) SetClusterHealth(v string) *DescribeDomainHealthOutput {
	s.ClusterHealth = &v
	return s
}

// SetDataNodeCount sets the DataNodeCount field's value.
func (s *DescribeDomainHealthOutput) SetDataNodeCount(v string) *DescribeDomainHealthOutput {
	s.DataNodeCount = &v
	return s
}

// SetDedicatedMaster sets the DedicatedMaster field's value.
func (s *DescribeDomainHealthOutput) SetDedicatedMaster(v bool) *DescribeDomainHealthOutput {
	s.DedicatedMaster = &v
	return s
}

// SetDomainState sets the DomainState field's value.
func (s *DescribeDomainHealthOutput) SetDomainState(v string) *DescribeDomainHealthOutput {
	s.DomainState = &v
	return s
}

// SetEnvironmentInformation sets the EnvironmentInformation field's value.
func (s *DescribeDomainHealthOutput) SetEnvironmentInformation(v []*EnvironmentInfo) *DescribeDomainHealthOutput {
	s.EnvironmentInformation = v
	return s
}

// SetMasterEligibleNodeCount sets the MasterEligibleNodeCount field's value.
func (s *DescribeDomainHealthOutput) SetMasterEligibleNodeCount(v string) *DescribeDomainHealthOutput {
	s.MasterEligibleNodeCount = &v
	return s
}

// SetMasterNode sets the MasterNode field's value.
func (s *DescribeDomainHealthOutput) SetMasterNode(v string) *DescribeDomainHealthOutput {
	s.MasterNode = &v
	return s
}

// SetStandByAvailabilityZoneCount sets the StandByAvailabilityZoneCount field's value.
func (s *DescribeDomainHealthOutput) SetStandByAvailabilityZoneCount(v string) *DescribeDomainHealthOutput {
	s.StandByAvailabilityZoneCount = &v
	return s
}

// SetTotalShards sets the TotalShards field's value.
func (s *DescribeDomainHealthOutput) SetTotalShards(v string) *DescribeDomainHealthOutput {
	s.TotalShards = &v
	return s
}

// SetTotalUnAssignedShards sets the TotalUnAssignedShards field's value.
func (s *DescribeDomainHealthOutput) SetTotalUnAssignedShards(v string) *DescribeDomainHealthOutput {
	s.TotalUnAssignedShards = &v
	return s
}

// SetWarmNodeCount sets the WarmNodeCount field's value.
func (s *DescribeDomainHealthOutput) SetWarmNodeCount(v string) *DescribeDomainHealthOutput {
	s.WarmNodeCount = &v
	return s
}

// Container for the parameters to the DescribeDomain operation.
type DescribeDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that you want information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainInput) SetDomainName(v string) *DescribeDomainInput {
	s.DomainName = &v
	return s
}

// Container for the parameters to the DescribeDomainNodes operation.
type DescribeDomainNodesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainNodesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainNodesInput) SetDomainName(v string) *DescribeDomainNodesInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeDomainNodes request. Contains information about the
// nodes on the requested domain.
type DescribeDomainNodesOutput struct {
	_ struct{} `type:"structure"`

	// Contains nodes information list DomainNodesStatusList with details about
	// the all nodes on the requested domain.
	DomainNodesStatusList []*DomainNodesStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainNodesOutput) GoString() string {
	return s.String()
}

// SetDomainNodesStatusList sets the DomainNodesStatusList field's value.
func (s *DescribeDomainNodesOutput) SetDomainNodesStatusList(v []*DomainNodesStatus) *DescribeDomainNodesOutput {
	s.DomainNodesStatusList = v
	return s
}

// Contains the status of the domain specified in the request.
type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// List that contains the status of each specified OpenSearch Service domain.
	//
	// DomainStatus is a required field
	DomainStatus *DomainStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeDomainOutput) SetDomainStatus(v *DomainStatus) *DescribeDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeDomains operation.
type DescribeDomainsInput struct {
	_ struct{} `type:"structure"`

	// Array of OpenSearch Service domain names that you want information about.
	// You must specify at least one domain name.
	//
	// DomainNames is a required field
	DomainNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainsInput"}
	if s.DomainNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainNames sets the DomainNames field's value.
func (s *DescribeDomainsInput) SetDomainNames(v []*string) *DescribeDomainsInput {
	s.DomainNames = v
	return s
}

// Contains the status of the specified domains or all domains owned by the
// account.
type DescribeDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the requested domains.
	//
	// DomainStatusList is a required field
	DomainStatusList []*DomainStatus `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainStatusList sets the DomainStatusList field's value.
func (s *DescribeDomainsOutput) SetDomainStatusList(v []*DomainStatus) *DescribeDomainsOutput {
	s.DomainStatusList = v
	return s
}

type DescribeDryRunProgressInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The unique identifier of the dry run.
	DryRunId *string `location:"querystring" locationName:"dryRunId" min:"36" type:"string"`

	// Whether to include the configuration of the dry run in the response. The
	// configuration specifies the updates that you're planning to make on the domain.
	LoadDryRunConfig *bool `location:"querystring" locationName:"loadDryRunConfig" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDryRunProgressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDryRunProgressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDryRunProgressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDryRunProgressInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.DryRunId != nil && len(*s.DryRunId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DryRunId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDryRunProgressInput) SetDomainName(v string) *DescribeDryRunProgressInput {
	s.DomainName = &v
	return s
}

// SetDryRunId sets the DryRunId field's value.
func (s *DescribeDryRunProgressInput) SetDryRunId(v string) *DescribeDryRunProgressInput {
	s.DryRunId = &v
	return s
}

// SetLoadDryRunConfig sets the LoadDryRunConfig field's value.
func (s *DescribeDryRunProgressInput) SetLoadDryRunConfig(v bool) *DescribeDryRunProgressInput {
	s.LoadDryRunConfig = &v
	return s
}

type DescribeDryRunProgressOutput struct {
	_ struct{} `type:"structure"`

	// Details about the changes you're planning to make on the domain.
	DryRunConfig *DomainStatus `type:"structure"`

	// The current status of the dry run, including any validation errors.
	DryRunProgressStatus *DryRunProgressStatus `type:"structure"`

	// The results of the dry run.
	DryRunResults *DryRunResults `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDryRunProgressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDryRunProgressOutput) GoString() string {
	return s.String()
}

// SetDryRunConfig sets the DryRunConfig field's value.
func (s *DescribeDryRunProgressOutput) SetDryRunConfig(v *DomainStatus) *DescribeDryRunProgressOutput {
	s.DryRunConfig = v
	return s
}

// SetDryRunProgressStatus sets the DryRunProgressStatus field's value.
func (s *DescribeDryRunProgressOutput) SetDryRunProgressStatus(v *DryRunProgressStatus) *DescribeDryRunProgressOutput {
	s.DryRunProgressStatus = v
	return s
}

// SetDryRunResults sets the DryRunResults field's value.
func (s *DescribeDryRunProgressOutput) SetDryRunResults(v *DryRunResults) *DescribeDryRunProgressOutput {
	s.DryRunResults = v
	return s
}

// Container for the parameters to the DescribeInboundConnections operation.
type DescribeInboundConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A list of filters used to match properties for inbound cross-cluster connections.
	Filters []*Filter `type:"list"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `type:"integer"`

	// If your initial DescribeInboundConnections operation returns a nextToken,
	// you can include the returned nextToken in subsequent DescribeInboundConnections
	// operations, which returns results in the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInboundConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInboundConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInboundConnectionsInput) SetFilters(v []*Filter) *DescribeInboundConnectionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInboundConnectionsInput) SetMaxResults(v int64) *DescribeInboundConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInboundConnectionsInput) SetNextToken(v string) *DescribeInboundConnectionsInput {
	s.NextToken = &v
	return s
}

// Contains a list of connections matching the filter criteria.
type DescribeInboundConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// List of inbound connections.
	Connections []*InboundConnection `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeInboundConnectionsOutput) SetConnections(v []*InboundConnection) *DescribeInboundConnectionsOutput {
	s.Connections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInboundConnectionsOutput) SetNextToken(v string) *DescribeInboundConnectionsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeInstanceTypeLimits operation.
type DescribeInstanceTypeLimitsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain. Only specify if you need the limits for an existing
	// domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or
	// OpenSearch_X.Y. Defaults to the latest version of OpenSearch.
	//
	// EngineVersion is a required field
	EngineVersion *string `location:"uri" locationName:"EngineVersion" min:"14" type:"string" required:"true"`

	// The OpenSearch Service instance type for which you need limit information.
	//
	// InstanceType is a required field
	InstanceType *string `location:"uri" locationName:"InstanceType" type:"string" required:"true" enum:"OpenSearchPartitionInstanceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceTypeLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceTypeLimitsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.EngineVersion != nil && len(*s.EngineVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EngineVersion", 14))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeInstanceTypeLimitsInput) SetDomainName(v string) *DescribeInstanceTypeLimitsInput {
	s.DomainName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeInstanceTypeLimitsInput) SetEngineVersion(v string) *DescribeInstanceTypeLimitsInput {
	s.EngineVersion = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeInstanceTypeLimitsInput) SetInstanceType(v string) *DescribeInstanceTypeLimitsInput {
	s.InstanceType = &v
	return s
}

// Container for the parameters received from the DescribeInstanceTypeLimits
// operation.
type DescribeInstanceTypeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Map that contains all applicable instance type limits.data refers to data
	// nodes.master refers to dedicated master nodes.
	LimitsByRole map[string]*Limits `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsOutput) GoString() string {
	return s.String()
}

// SetLimitsByRole sets the LimitsByRole field's value.
func (s *DescribeInstanceTypeLimitsOutput) SetLimitsByRole(v map[string]*Limits) *DescribeInstanceTypeLimitsOutput {
	s.LimitsByRole = v
	return s
}

// Container for the parameters to the DescribeOutboundConnections operation.
type DescribeOutboundConnectionsInput struct {
	_ struct{} `type:"structure"`

	// List of filter names and values that you can use for requests.
	Filters []*Filter `type:"list"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `type:"integer"`

	// If your initial DescribeOutboundConnections operation returns a nextToken,
	// you can include the returned nextToken in subsequent DescribeOutboundConnections
	// operations, which returns results in the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOutboundConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOutboundConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeOutboundConnectionsInput) SetFilters(v []*Filter) *DescribeOutboundConnectionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeOutboundConnectionsInput) SetMaxResults(v int64) *DescribeOutboundConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOutboundConnectionsInput) SetNextToken(v string) *DescribeOutboundConnectionsInput {
	s.NextToken = &v
	return s
}

// Contains a list of connections matching the filter criteria.
type DescribeOutboundConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// List of outbound connections that match the filter criteria.
	Connections []*OutboundConnection `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeOutboundConnectionsOutput) SetConnections(v []*OutboundConnection) *DescribeOutboundConnectionsOutput {
	s.Connections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOutboundConnectionsOutput) SetNextToken(v string) *DescribeOutboundConnectionsOutput {
	s.NextToken = &v
	return s
}

// A filter to apply to the DescribePackage response.
type DescribePackagesFilter struct {
	_ struct{} `type:"structure"`

	// Any field from PackageDetails.
	Name *string `type:"string" enum:"DescribePackagesFilterName"`

	// A non-empty list of values for the specified filter field.
	Value []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackagesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackagesFilter"}
	if s.Value != nil && len(s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribePackagesFilter) SetName(v string) *DescribePackagesFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DescribePackagesFilter) SetValue(v []*string) *DescribePackagesFilter {
	s.Value = v
	return s
}

// Container for the request parameters to the DescribePackage operation.
type DescribePackagesInput struct {
	_ struct{} `type:"structure"`

	// Only returns packages that match the DescribePackagesFilterList values.
	Filters []*DescribePackagesFilter `type:"list"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `type:"integer"`

	// If your initial DescribePackageFilters operation returns a nextToken, you
	// can include the returned nextToken in subsequent DescribePackageFilters operations,
	// which returns results in the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackagesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePackagesInput) SetFilters(v []*DescribePackagesFilter) *DescribePackagesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePackagesInput) SetMaxResults(v int64) *DescribePackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePackagesInput) SetNextToken(v string) *DescribePackagesInput {
	s.NextToken = &v
	return s
}

// Container for the response returned by the DescribePackages operation.
type DescribePackagesOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// Basic information about a package.
	PackageDetailsList []*PackageDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePackagesOutput) SetNextToken(v string) *DescribePackagesOutput {
	s.NextToken = &v
	return s
}

// SetPackageDetailsList sets the PackageDetailsList field's value.
func (s *DescribePackagesOutput) SetPackageDetailsList(v []*PackageDetails) *DescribePackagesOutput {
	s.PackageDetailsList = v
	return s
}

// Container for the request parameters to a DescribeReservedInstanceOfferings
// operation.
type DescribeReservedInstanceOfferingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial DescribeReservedInstanceOfferings operation returns a nextToken,
	// you can include the returned nextToken in subsequent DescribeReservedInstanceOfferings
	// operations, which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The Reserved Instance identifier filter value. Use this parameter to show
	// only the available instance types that match the specified reservation identifier.
	ReservedInstanceOfferingId *string `location:"querystring" locationName:"offeringId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservedInstanceOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservedInstanceOfferingsInput"}
	if s.ReservedInstanceOfferingId != nil && len(*s.ReservedInstanceOfferingId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ReservedInstanceOfferingId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedInstanceOfferingsInput) SetMaxResults(v int64) *DescribeReservedInstanceOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstanceOfferingsInput) SetNextToken(v string) *DescribeReservedInstanceOfferingsInput {
	s.NextToken = &v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *DescribeReservedInstanceOfferingsInput) SetReservedInstanceOfferingId(v string) *DescribeReservedInstanceOfferingsInput {
	s.ReservedInstanceOfferingId = &v
	return s
}

// Container for results of a DescribeReservedInstanceOfferings request.
type DescribeReservedInstanceOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// List of Reserved Instance offerings.
	ReservedInstanceOfferings []*ReservedInstanceOffering `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstanceOfferingsOutput) SetNextToken(v string) *DescribeReservedInstanceOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetReservedInstanceOfferings sets the ReservedInstanceOfferings field's value.
func (s *DescribeReservedInstanceOfferingsOutput) SetReservedInstanceOfferings(v []*ReservedInstanceOffering) *DescribeReservedInstanceOfferingsOutput {
	s.ReservedInstanceOfferings = v
	return s
}

// Container for the request parameters to the DescribeReservedInstances operation.
type DescribeReservedInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial DescribeReservedInstances operation returns a nextToken,
	// you can include the returned nextToken in subsequent DescribeReservedInstances
	// operations, which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The reserved instance identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reserved OpenSearch instance
	// ID.
	ReservedInstanceId *string `location:"querystring" locationName:"reservationId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservedInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservedInstancesInput"}
	if s.ReservedInstanceId != nil && len(*s.ReservedInstanceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ReservedInstanceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedInstancesInput) SetMaxResults(v int64) *DescribeReservedInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstancesInput) SetNextToken(v string) *DescribeReservedInstancesInput {
	s.NextToken = &v
	return s
}

// SetReservedInstanceId sets the ReservedInstanceId field's value.
func (s *DescribeReservedInstancesInput) SetReservedInstanceId(v string) *DescribeReservedInstancesInput {
	s.ReservedInstanceId = &v
	return s
}

// Container for results from DescribeReservedInstances
type DescribeReservedInstancesOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// List of Reserved Instances in the current Region.
	ReservedInstances []*ReservedInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstancesOutput) SetNextToken(v string) *DescribeReservedInstancesOutput {
	s.NextToken = &v
	return s
}

// SetReservedInstances sets the ReservedInstances field's value.
func (s *DescribeReservedInstancesOutput) SetReservedInstances(v []*ReservedInstance) *DescribeReservedInstancesOutput {
	s.ReservedInstances = v
	return s
}

type DescribeVpcEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifiers of the endpoints to get information about.
	//
	// VpcEndpointIds is a required field
	VpcEndpointIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVpcEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVpcEndpointsInput"}
	if s.VpcEndpointIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcEndpointIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcEndpointIds sets the VpcEndpointIds field's value.
func (s *DescribeVpcEndpointsInput) SetVpcEndpointIds(v []*string) *DescribeVpcEndpointsInput {
	s.VpcEndpointIds = v
	return s
}

type DescribeVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Any errors associated with the request.
	//
	// VpcEndpointErrors is a required field
	VpcEndpointErrors []*VpcEndpointError `type:"list" required:"true"`

	// Information about each requested VPC endpoint.
	//
	// VpcEndpoints is a required field
	VpcEndpoints []*VpcEndpoint `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcEndpointsOutput) GoString() string {
	return s.String()
}

// SetVpcEndpointErrors sets the VpcEndpointErrors field's value.
func (s *DescribeVpcEndpointsOutput) SetVpcEndpointErrors(v []*VpcEndpointError) *DescribeVpcEndpointsOutput {
	s.VpcEndpointErrors = v
	return s
}

// SetVpcEndpoints sets the VpcEndpoints field's value.
func (s *DescribeVpcEndpointsOutput) SetVpcEndpoints(v []*VpcEndpoint) *DescribeVpcEndpointsOutput {
	s.VpcEndpoints = v
	return s
}

// An error occured because the client wanted to access an unsupported operation.
type DisabledOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledOperationException) GoString() string {
	return s.String()
}

func newErrorDisabledOperationException(v protocol.ResponseMetadata) error {
	return &DisabledOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DisabledOperationException) Code() string {
	return "DisabledOperationException"
}

// Message returns the exception's message.
func (s *DisabledOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DisabledOperationException) OrigErr() error {
	return nil
}

func (s *DisabledOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DisabledOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DisabledOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for the request parameters to the DissociatePackage operation.
type DissociatePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the domain to dissociate the package from.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Internal ID of the package to dissociate from the domain. Use ListPackagesForDomain
	// to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DissociatePackageInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DissociatePackageInput) SetDomainName(v string) *DissociatePackageInput {
	s.DomainName = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *DissociatePackageInput) SetPackageID(v string) *DissociatePackageInput {
	s.PackageID = &v
	return s
}

// Container for the response returned by an DissociatePackage operation.
type DissociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about a package that has been dissociated from the domain.
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetails sets the DomainPackageDetails field's value.
func (s *DissociatePackageOutput) SetDomainPackageDetails(v *DomainPackageDetails) *DissociatePackageOutput {
	s.DomainPackageDetails = v
	return s
}

// Container for the configuration of an OpenSearch Service domain.
type DomainConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the access policies for the domain.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// Key-value pairs to specify advanced configuration options. For more information,
	// see Advanced options (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// Container for fine-grained access control settings for the domain.
	AdvancedSecurityOptions *AdvancedSecurityOptionsStatus `type:"structure"`

	// Container for Auto-Tune settings for the domain.
	AutoTuneOptions *AutoTuneOptionsStatus `type:"structure"`

	// Container for information about the progress of an existing configuration
	// change.
	ChangeProgressDetails *ChangeProgressDetails `type:"structure"`

	// Container for the cluster configuration of a the domain.
	ClusterConfig *ClusterConfigStatus `type:"structure"`

	// Container for Amazon Cognito options for the domain.
	CognitoOptions *CognitoOptionsStatus `type:"structure"`

	// Additional options for the domain endpoint, such as whether to require HTTPS
	// for all traffic.
	DomainEndpointOptions *DomainEndpointOptionsStatus `type:"structure"`

	// Container for EBS options configured for the domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// Key-value pairs to enable encryption at rest.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus `type:"structure"`

	// The OpenSearch or Elasticsearch version that the domain is running.
	EngineVersion *VersionStatus `type:"structure"`

	// The type of IP addresses supported by the endpoint for the domain.
	IPAddressType *IPAddressTypeStatus `type:"structure"`

	// Key-value pairs to configure log publishing.
	LogPublishingOptions *LogPublishingOptionsStatus `type:"structure"`

	// Whether node-to-node encryption is enabled or disabled.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus `type:"structure"`

	// Container for off-peak window options for the domain.
	OffPeakWindowOptions *OffPeakWindowOptionsStatus `type:"structure"`

	// DEPRECATED. Container for parameters required to configure automated snapshots
	// of domain indexes.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`

	// Software update options for the domain.
	SoftwareUpdateOptions *SoftwareUpdateOptionsStatus `type:"structure"`

	// The current VPC options for the domain and the status of any updates to their
	// configuration.
	VPCOptions *VPCDerivedInfoStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainConfig) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *DomainConfig) SetAccessPolicies(v *AccessPoliciesStatus) *DomainConfig {
	s.AccessPolicies = v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *DomainConfig) SetAdvancedOptions(v *AdvancedOptionsStatus) *DomainConfig {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *DomainConfig) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsStatus) *DomainConfig {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *DomainConfig) SetAutoTuneOptions(v *AutoTuneOptionsStatus) *DomainConfig {
	s.AutoTuneOptions = v
	return s
}

// SetChangeProgressDetails sets the ChangeProgressDetails field's value.
func (s *DomainConfig) SetChangeProgressDetails(v *ChangeProgressDetails) *DomainConfig {
	s.ChangeProgressDetails = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *DomainConfig) SetClusterConfig(v *ClusterConfigStatus) *DomainConfig {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *DomainConfig) SetCognitoOptions(v *CognitoOptionsStatus) *DomainConfig {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *DomainConfig) SetDomainEndpointOptions(v *DomainEndpointOptionsStatus) *DomainConfig {
	s.DomainEndpointOptions = v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *DomainConfig) SetEBSOptions(v *EBSOptionsStatus) *DomainConfig {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *DomainConfig) SetEncryptionAtRestOptions(v *EncryptionAtRestOptionsStatus) *DomainConfig {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DomainConfig) SetEngineVersion(v *VersionStatus) *DomainConfig {
	s.EngineVersion = v
	return s
}

// SetIPAddressType sets the IPAddressType field's value.
func (s *DomainConfig) SetIPAddressType(v *IPAddressTypeStatus) *DomainConfig {
	s.IPAddressType = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *DomainConfig) SetLogPublishingOptions(v *LogPublishingOptionsStatus) *DomainConfig {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *DomainConfig) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptionsStatus) *DomainConfig {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetOffPeakWindowOptions sets the OffPeakWindowOptions field's value.
func (s *DomainConfig) SetOffPeakWindowOptions(v *OffPeakWindowOptionsStatus) *DomainConfig {
	s.OffPeakWindowOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *DomainConfig) SetSnapshotOptions(v *SnapshotOptionsStatus) *DomainConfig {
	s.SnapshotOptions = v
	return s
}

// SetSoftwareUpdateOptions sets the SoftwareUpdateOptions field's value.
func (s *DomainConfig) SetSoftwareUpdateOptions(v *SoftwareUpdateOptionsStatus) *DomainConfig {
	s.SoftwareUpdateOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *DomainConfig) SetVPCOptions(v *VPCDerivedInfoStatus) *DomainConfig {
	s.VPCOptions = v
	return s
}

// Options to configure a custom endpoint for an OpenSearch Service domain.
type DomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// The fully qualified URL for the custom endpoint.
	CustomEndpoint *string `min:"1" type:"string"`

	// The ARN for your security certificate, managed in Amazon Web Services Certificate
	// Manager (ACM).
	CustomEndpointCertificateArn *string `min:"20" type:"string"`

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled *bool `type:"boolean"`

	// True to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool `type:"boolean"`

	// Specify the TLS security policy to apply to the HTTPS endpoint of the domain.
	// The policy can be one of the following values:
	//
	//    * Policy-Min-TLS-1-0-2019-07: TLS security policy that supports TLS version
	//    1.0 to TLS version 1.2
	//
	//    * Policy-Min-TLS-1-2-2019-07: TLS security policy that supports only TLS
	//    version 1.2
	TLSSecurityPolicy *string `type:"string" enum:"TLSSecurityPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainEndpointOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainEndpointOptions"}
	if s.CustomEndpoint != nil && len(*s.CustomEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomEndpoint", 1))
	}
	if s.CustomEndpointCertificateArn != nil && len(*s.CustomEndpointCertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomEndpointCertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomEndpoint sets the CustomEndpoint field's value.
func (s *DomainEndpointOptions) SetCustomEndpoint(v string) *DomainEndpointOptions {
	s.CustomEndpoint = &v
	return s
}

// SetCustomEndpointCertificateArn sets the CustomEndpointCertificateArn field's value.
func (s *DomainEndpointOptions) SetCustomEndpointCertificateArn(v string) *DomainEndpointOptions {
	s.CustomEndpointCertificateArn = &v
	return s
}

// SetCustomEndpointEnabled sets the CustomEndpointEnabled field's value.
func (s *DomainEndpointOptions) SetCustomEndpointEnabled(v bool) *DomainEndpointOptions {
	s.CustomEndpointEnabled = &v
	return s
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *DomainEndpointOptions) SetEnforceHTTPS(v bool) *DomainEndpointOptions {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *DomainEndpointOptions) SetTLSSecurityPolicy(v string) *DomainEndpointOptions {
	s.TLSSecurityPolicy = &v
	return s
}

// The configured endpoint options for a domain and their current status.
type DomainEndpointOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Options to configure the endpoint for a domain.
	//
	// Options is a required field
	Options *DomainEndpointOptions `type:"structure" required:"true"`

	// The status of the endpoint options for a domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *DomainEndpointOptionsStatus) SetOptions(v *DomainEndpointOptions) *DomainEndpointOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainEndpointOptionsStatus) SetStatus(v *OptionStatus) *DomainEndpointOptionsStatus {
	s.Status = v
	return s
}

// Information about an OpenSearch Service domain.
type DomainInfo struct {
	_ struct{} `type:"structure"`

	// Name of the domain.
	DomainName *string `min:"3" type:"string"`

	// The type of search engine that the domain is running.OpenSearch for an OpenSearch
	// engine, or Elasticsearch for a legacy Elasticsearch OSS engine.
	EngineType *string `type:"string" enum:"EngineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInfo) SetDomainName(v string) *DomainInfo {
	s.DomainName = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *DomainInfo) SetEngineType(v string) *DomainInfo {
	s.EngineType = &v
	return s
}

// Container for information about an OpenSearch Service domain.
type DomainInformationContainer struct {
	_ struct{} `type:"structure"`

	// Information about an Amazon OpenSearch Service domain.
	AWSDomainInformation *AWSDomainInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInformationContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInformationContainer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainInformationContainer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainInformationContainer"}
	if s.AWSDomainInformation != nil {
		if err := s.AWSDomainInformation.Validate(); err != nil {
			invalidParams.AddNested("AWSDomainInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAWSDomainInformation sets the AWSDomainInformation field's value.
func (s *DomainInformationContainer) SetAWSDomainInformation(v *AWSDomainInformation) *DomainInformationContainer {
	s.AWSDomainInformation = v
	return s
}

// Container for the domain maintenance details.
type DomainMaintenanceDetails struct {
	_ struct{} `type:"structure"`

	// The name of the action.
	Action *string `type:"string" enum:"MaintenanceType"`

	// The time at which the action was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the domain.
	DomainName *string `min:"3" type:"string"`

	// The ID of the requested action.
	MaintenanceId *string `min:"1" type:"string"`

	// The ID of the data node.
	NodeId *string `min:"10" type:"string"`

	// The status of the action.
	Status *string `type:"string" enum:"MaintenanceStatus"`

	// The status message for the action.
	StatusMessage *string `type:"string"`

	// The time at which the action was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainMaintenanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainMaintenanceDetails) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DomainMaintenanceDetails) SetAction(v string) *DomainMaintenanceDetails {
	s.Action = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DomainMaintenanceDetails) SetCreatedAt(v time.Time) *DomainMaintenanceDetails {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainMaintenanceDetails) SetDomainName(v string) *DomainMaintenanceDetails {
	s.DomainName = &v
	return s
}

// SetMaintenanceId sets the MaintenanceId field's value.
func (s *DomainMaintenanceDetails) SetMaintenanceId(v string) *DomainMaintenanceDetails {
	s.MaintenanceId = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *DomainMaintenanceDetails) SetNodeId(v string) *DomainMaintenanceDetails {
	s.NodeId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainMaintenanceDetails) SetStatus(v string) *DomainMaintenanceDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DomainMaintenanceDetails) SetStatusMessage(v string) *DomainMaintenanceDetails {
	s.StatusMessage = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DomainMaintenanceDetails) SetUpdatedAt(v time.Time) *DomainMaintenanceDetails {
	s.UpdatedAt = &v
	return s
}

// Container for information about nodes on the domain.
type DomainNodesStatus struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the node.
	AvailabilityZone *string `min:"1" type:"string"`

	// The instance type information of the node.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// The ID of the node.
	NodeId *string `min:"10" type:"string"`

	// Indicates if the node is active or in standby.
	NodeStatus *string `type:"string" enum:"NodeStatus"`

	// Indicates whether the nodes is a data, master, or ultrawarm node.
	NodeType *string `type:"string" enum:"NodeType"`

	// The storage size of the node, in GiB.
	StorageSize *string `type:"string"`

	// Indicates if the node has EBS or instance storage.
	StorageType *string `type:"string"`

	// If the nodes has EBS storage, indicates if the volume type is GP2 or GP3.
	// Only applicable for data nodes.
	StorageVolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainNodesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainNodesStatus) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DomainNodesStatus) SetAvailabilityZone(v string) *DomainNodesStatus {
	s.AvailabilityZone = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DomainNodesStatus) SetInstanceType(v string) *DomainNodesStatus {
	s.InstanceType = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *DomainNodesStatus) SetNodeId(v string) *DomainNodesStatus {
	s.NodeId = &v
	return s
}

// SetNodeStatus sets the NodeStatus field's value.
func (s *DomainNodesStatus) SetNodeStatus(v string) *DomainNodesStatus {
	s.NodeStatus = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *DomainNodesStatus) SetNodeType(v string) *DomainNodesStatus {
	s.NodeType = &v
	return s
}

// SetStorageSize sets the StorageSize field's value.
func (s *DomainNodesStatus) SetStorageSize(v string) *DomainNodesStatus {
	s.StorageSize = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DomainNodesStatus) SetStorageType(v string) *DomainNodesStatus {
	s.StorageType = &v
	return s
}

// SetStorageVolumeType sets the StorageVolumeType field's value.
func (s *DomainNodesStatus) SetStorageVolumeType(v string) *DomainNodesStatus {
	s.StorageVolumeType = &v
	return s
}

// Information about a package that is associated with a domain. For more information,
// see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
type DomainPackageDetails struct {
	_ struct{} `type:"structure"`

	// Name of the domain that the package is associated with.
	DomainName *string `min:"3" type:"string"`

	// State of the association.
	DomainPackageStatus *string `type:"string" enum:"DomainPackageStatus"`

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails `type:"structure"`

	// Timestamp of the most recent update to the package association status.
	LastUpdated *time.Time `type:"timestamp"`

	// Internal ID of the package.
	PackageID *string `type:"string"`

	// User-specified name of the package.
	PackageName *string `min:"3" type:"string"`

	// The type of package.
	PackageType *string `type:"string" enum:"PackageType"`

	// The current version of the package.
	PackageVersion *string `type:"string"`

	// The relative path of the package on the OpenSearch Service cluster nodes.
	// This is synonym_path when the package is for synonym files.
	ReferencePath *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainPackageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainPackageDetails) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainPackageDetails) SetDomainName(v string) *DomainPackageDetails {
	s.DomainName = &v
	return s
}

// SetDomainPackageStatus sets the DomainPackageStatus field's value.
func (s *DomainPackageDetails) SetDomainPackageStatus(v string) *DomainPackageDetails {
	s.DomainPackageStatus = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *DomainPackageDetails) SetErrorDetails(v *ErrorDetails) *DomainPackageDetails {
	s.ErrorDetails = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *DomainPackageDetails) SetLastUpdated(v time.Time) *DomainPackageDetails {
	s.LastUpdated = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *DomainPackageDetails) SetPackageID(v string) *DomainPackageDetails {
	s.PackageID = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DomainPackageDetails) SetPackageName(v string) *DomainPackageDetails {
	s.PackageName = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *DomainPackageDetails) SetPackageType(v string) *DomainPackageDetails {
	s.PackageType = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DomainPackageDetails) SetPackageVersion(v string) *DomainPackageDetails {
	s.PackageVersion = &v
	return s
}

// SetReferencePath sets the ReferencePath field's value.
func (s *DomainPackageDetails) SetReferencePath(v string) *DomainPackageDetails {
	s.ReferencePath = &v
	return s
}

// The current status of an OpenSearch Service domain.
type DomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain. For more information, see IAM
	// identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the AWS Identity and Access Management User Guide.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// Identity and Access Management (IAM) policy document specifying the access
	// policies for the domain.
	AccessPolicies *string `type:"string"`

	// Key-value pairs that specify advanced configuration options.
	AdvancedOptions map[string]*string `type:"map"`

	// Settings for fine-grained access control.
	AdvancedSecurityOptions *AdvancedSecurityOptions `type:"structure"`

	// Auto-Tune settings for the domain.
	AutoTuneOptions *AutoTuneOptionsOutput_ `type:"structure"`

	// Information about a configuration change happening on the domain.
	ChangeProgressDetails *ChangeProgressDetails `type:"structure"`

	// Container for the cluster configuration of the domain.
	//
	// ClusterConfig is a required field
	ClusterConfig *ClusterConfig `type:"structure" required:"true"`

	// Key-value pairs to configure Amazon Cognito authentication for OpenSearch
	// Dashboards.
	CognitoOptions *CognitoOptions `type:"structure"`

	// Creation status of an OpenSearch Service domain. True if domain creation
	// is complete. False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// Deletion status of an OpenSearch Service domain. True if domain deletion
	// is complete. False if domain deletion is still in progress. Once deletion
	// is complete, the status of the domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// Additional options for the domain endpoint, such as whether to require HTTPS
	// for all traffic.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// Unique identifier for the domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// Name of the domain. Domain names are unique across all domains owned by the
	// same account within an Amazon Web Services Region.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Container for EBS-based storage settings for the domain.
	EBSOptions *EBSOptions `type:"structure"`

	// Encryption at rest settings for the domain.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to the domain.
	Endpoint *string `type:"string"`

	// The domain endpoint to which index and search requests are submitted. For
	// example, search-imdb-movies-oopcnjfn6ugo.eu-west-1.es.amazonaws.com or doc-imdb-movies-oopcnjfn6u.eu-west-1.es.amazonaws.com.
	EndpointV2 *string `type:"string"`

	// The key-value pair that exists if the OpenSearch Service domain uses VPC
	// endpoints.. Example key, value: 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'.
	Endpoints map[string]*string `type:"map"`

	// Version of OpenSearch or Elasticsearch that the domain is running, in the
	// format Elasticsearch_X.Y or OpenSearch_X.Y.
	EngineVersion *string `min:"14" type:"string"`

	// The type of IP addresses supported by the endpoint for the domain.
	IPAddressType *string `type:"string" enum:"IPAddressType"`

	// Log publishing options for the domain.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Whether node-to-node encryption is enabled or disabled.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Options that specify a custom 10-hour window during which OpenSearch Service
	// can perform configuration changes on the domain.
	OffPeakWindowOptions *OffPeakWindowOptions `type:"structure"`

	// The status of the domain configuration. True if OpenSearch Service is processing
	// configuration changes. False if the configuration is active.
	Processing *bool `type:"boolean"`

	// The current status of the domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`

	// DEPRECATED. Container for parameters required to configure automated snapshots
	// of domain indexes.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Service software update options for the domain.
	SoftwareUpdateOptions *SoftwareUpdateOptions `type:"structure"`

	// The status of a domain version upgrade to a new version of OpenSearch or
	// Elasticsearch. True if OpenSearch Service is in the process of a version
	// upgrade. False if the configuration is active.
	UpgradeProcessing *bool `type:"boolean"`

	// The VPC configuration for the domain.
	VPCOptions *VPCDerivedInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainStatus) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DomainStatus) SetARN(v string) *DomainStatus {
	s.ARN = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *DomainStatus) SetAccessPolicies(v string) *DomainStatus {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *DomainStatus) SetAdvancedOptions(v map[string]*string) *DomainStatus {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *DomainStatus) SetAdvancedSecurityOptions(v *AdvancedSecurityOptions) *DomainStatus {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *DomainStatus) SetAutoTuneOptions(v *AutoTuneOptionsOutput_) *DomainStatus {
	s.AutoTuneOptions = v
	return s
}

// SetChangeProgressDetails sets the ChangeProgressDetails field's value.
func (s *DomainStatus) SetChangeProgressDetails(v *ChangeProgressDetails) *DomainStatus {
	s.ChangeProgressDetails = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *DomainStatus) SetClusterConfig(v *ClusterConfig) *DomainStatus {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *DomainStatus) SetCognitoOptions(v *CognitoOptions) *DomainStatus {
	s.CognitoOptions = v
	return s
}

// SetCreated sets the Created field's value.
func (s *DomainStatus) SetCreated(v bool) *DomainStatus {
	s.Created = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *DomainStatus) SetDeleted(v bool) *DomainStatus {
	s.Deleted = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *DomainStatus) SetDomainEndpointOptions(v *DomainEndpointOptions) *DomainStatus {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DomainStatus) SetDomainId(v string) *DomainStatus {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainStatus) SetDomainName(v string) *DomainStatus {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *DomainStatus) SetEBSOptions(v *EBSOptions) *DomainStatus {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *DomainStatus) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *DomainStatus {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DomainStatus) SetEndpoint(v string) *DomainStatus {
	s.Endpoint = &v
	return s
}

// SetEndpointV2 sets the EndpointV2 field's value.
func (s *DomainStatus) SetEndpointV2(v string) *DomainStatus {
	s.EndpointV2 = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *DomainStatus) SetEndpoints(v map[string]*string) *DomainStatus {
	s.Endpoints = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DomainStatus) SetEngineVersion(v string) *DomainStatus {
	s.EngineVersion = &v
	return s
}

// SetIPAddressType sets the IPAddressType field's value.
func (s *DomainStatus) SetIPAddressType(v string) *DomainStatus {
	s.IPAddressType = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *DomainStatus) SetLogPublishingOptions(v map[string]*LogPublishingOption) *DomainStatus {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *DomainStatus) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *DomainStatus {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetOffPeakWindowOptions sets the OffPeakWindowOptions field's value.
func (s *DomainStatus) SetOffPeakWindowOptions(v *OffPeakWindowOptions) *DomainStatus {
	s.OffPeakWindowOptions = v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *DomainStatus) SetProcessing(v bool) *DomainStatus {
	s.Processing = &v
	return s
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *DomainStatus) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *DomainStatus {
	s.ServiceSoftwareOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *DomainStatus) SetSnapshotOptions(v *SnapshotOptions) *DomainStatus {
	s.SnapshotOptions = v
	return s
}

// SetSoftwareUpdateOptions sets the SoftwareUpdateOptions field's value.
func (s *DomainStatus) SetSoftwareUpdateOptions(v *SoftwareUpdateOptions) *DomainStatus {
	s.SoftwareUpdateOptions = v
	return s
}

// SetUpgradeProcessing sets the UpgradeProcessing field's value.
func (s *DomainStatus) SetUpgradeProcessing(v bool) *DomainStatus {
	s.UpgradeProcessing = &v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *DomainStatus) SetVPCOptions(v *VPCDerivedInfo) *DomainStatus {
	s.VPCOptions = v
	return s
}

// Information about the progress of a pre-upgrade dry run analysis.
type DryRunProgressStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp when the dry run was initiated.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The unique identifier of the dry run.
	//
	// DryRunId is a required field
	DryRunId *string `min:"36" type:"string" required:"true"`

	// The current status of the dry run.
	//
	// DryRunStatus is a required field
	DryRunStatus *string `type:"string" required:"true"`

	// The timestamp when the dry run was last updated.
	//
	// UpdateDate is a required field
	UpdateDate *string `type:"string" required:"true"`

	// Any validation failures that occurred as a result of the dry run.
	ValidationFailures []*ValidationFailure `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DryRunProgressStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DryRunProgressStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DryRunProgressStatus) SetCreationDate(v string) *DryRunProgressStatus {
	s.CreationDate = &v
	return s
}

// SetDryRunId sets the DryRunId field's value.
func (s *DryRunProgressStatus) SetDryRunId(v string) *DryRunProgressStatus {
	s.DryRunId = &v
	return s
}

// SetDryRunStatus sets the DryRunStatus field's value.
func (s *DryRunProgressStatus) SetDryRunStatus(v string) *DryRunProgressStatus {
	s.DryRunStatus = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *DryRunProgressStatus) SetUpdateDate(v string) *DryRunProgressStatus {
	s.UpdateDate = &v
	return s
}

// SetValidationFailures sets the ValidationFailures field's value.
func (s *DryRunProgressStatus) SetValidationFailures(v []*ValidationFailure) *DryRunProgressStatus {
	s.ValidationFailures = v
	return s
}

// Results of a dry run performed in an update domain request.
type DryRunResults struct {
	_ struct{} `type:"structure"`

	// Specifies the way in which OpenSearch Service will apply an update. Possible
	// values are:
	//
	//    * Blue/Green - The update requires a blue/green deployment.
	//
	//    * DynamicUpdate - No blue/green deployment required
	//
	//    * Undetermined - The domain is in the middle of an update and can't predict
	//    the deployment type. Try again after the update is complete.
	//
	//    * None - The request doesn't include any configuration changes.
	DeploymentType *string `min:"2" type:"string"`

	// A message corresponding to the deployment type.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DryRunResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DryRunResults) GoString() string {
	return s.String()
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *DryRunResults) SetDeploymentType(v string) *DryRunResults {
	s.DeploymentType = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DryRunResults) SetMessage(v string) *DryRunResults {
	s.Message = &v
	return s
}

// The duration of a maintenance schedule. For more information, see Auto-Tune
// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type Duration struct {
	_ struct{} `type:"structure"`

	// The unit of measurement for the duration of a maintenance schedule.
	Unit *string `type:"string" enum:"TimeUnit"`

	// Integer to specify the value of a maintenance schedule duration.
	Value *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Duration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Duration"}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnit sets the Unit field's value.
func (s *Duration) SetUnit(v string) *Duration {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Duration) SetValue(v int64) *Duration {
	s.Value = &v
	return s
}

// Container for the parameters required to enable EBS-based storage for an
// OpenSearch Service domain.
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Indicates whether EBS volumes are attached to data nodes in an OpenSearch
	// Service domain.
	EBSEnabled *bool `type:"boolean"`

	// Specifies the baseline input/output (I/O) performance of EBS volumes attached
	// to data nodes. Applicable only for the gp3 and provisioned IOPS EBS volume
	// types.
	Iops *int64 `type:"integer"`

	// Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes.
	// Applicable only for the gp3 volume type.
	Throughput *int64 `type:"integer"`

	// Specifies the size (in GiB) of EBS volumes attached to data nodes.
	VolumeSize *int64 `type:"integer"`

	// Specifies the type of EBS volumes attached to data nodes.
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptions) GoString() string {
	return s.String()
}

// SetEBSEnabled sets the EBSEnabled field's value.
func (s *EBSOptions) SetEBSEnabled(v bool) *EBSOptions {
	s.EBSEnabled = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EBSOptions) SetIops(v int64) *EBSOptions {
	s.Iops = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *EBSOptions) SetThroughput(v int64) *EBSOptions {
	s.Throughput = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSOptions) SetVolumeSize(v int64) *EBSOptions {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EBSOptions) SetVolumeType(v string) *EBSOptions {
	s.VolumeType = &v
	return s
}

// The status of the EBS options for the specified OpenSearch Service domain.
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The configured EBS options for the specified domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// The status of the EBS options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EBSOptionsStatus) SetOptions(v *EBSOptions) *EBSOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EBSOptionsStatus) SetStatus(v *OptionStatus) *EBSOptionsStatus {
	s.Status = v
	return s
}

// Specifies whether the domain should encrypt data at rest, and if so, the
// Key Management Service (KMS) key to use. Can be used only to create a new
// domain, not update an existing one.
type EncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// True to enable encryption at rest.
	Enabled *bool `type:"boolean"`

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.
	KmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRestOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRestOptions"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *EncryptionAtRestOptions) SetEnabled(v bool) *EncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EncryptionAtRestOptions) SetKmsKeyId(v string) *EncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// Status of the encryption at rest options for the specified OpenSearch Service
// domain.
type EncryptionAtRestOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Encryption at rest options for the specified domain.
	//
	// Options is a required field
	Options *EncryptionAtRestOptions `type:"structure" required:"true"`

	// The status of the encryption at rest options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EncryptionAtRestOptionsStatus) SetOptions(v *EncryptionAtRestOptions) *EncryptionAtRestOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EncryptionAtRestOptionsStatus) SetStatus(v *OptionStatus) *EncryptionAtRestOptionsStatus {
	s.Status = v
	return s
}

// Information about the active domain environment.
type EnvironmentInfo struct {
	_ struct{} `type:"structure"`

	// A list of AvailabilityZoneInfo for the domain.
	AvailabilityZoneInformation []*AvailabilityZoneInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentInfo) GoString() string {
	return s.String()
}

// SetAvailabilityZoneInformation sets the AvailabilityZoneInformation field's value.
func (s *EnvironmentInfo) SetAvailabilityZoneInformation(v []*AvailabilityZoneInfo) *EnvironmentInfo {
	s.AvailabilityZoneInformation = v
	return s
}

// Additional information if the package is in an error state. Null otherwise.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`

	// The type of error that occurred.
	ErrorType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetails) SetErrorMessage(v string) *ErrorDetails {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *ErrorDetails) SetErrorType(v string) *ErrorDetails {
	s.ErrorType = &v
	return s
}

// A filter used to limit results when describing inbound or outbound cross-cluster
// connections. You can specify multiple values per filter. A cross-cluster
// connection must match at least one of the specified values for it to be returned
// from an operation.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `min:"1" type:"string"`

	// One or more values for the filter.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Container for the request parameters to GetCompatibleVersions operation.
type GetCompatibleVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an existing domain. Provide this parameter to limit the results
	// to a single domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCompatibleVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCompatibleVersionsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetCompatibleVersionsInput) SetDomainName(v string) *GetCompatibleVersionsInput {
	s.DomainName = &v
	return s
}

// Container for the response returned by the GetCompatibleVersions operation.
type GetCompatibleVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of OpenSearch or Elasticsearch versions and the versions you can upgrade
	// them to.
	CompatibleVersions []*CompatibleVersionsMap `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsOutput) GoString() string {
	return s.String()
}

// SetCompatibleVersions sets the CompatibleVersions field's value.
func (s *GetCompatibleVersionsOutput) SetCompatibleVersions(v []*CompatibleVersionsMap) *GetCompatibleVersionsOutput {
	s.CompatibleVersions = v
	return s
}

// Container for the parameters to the GetDataSource operation.
type GetDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The name of the data source to get information about.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"DataSourceName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDataSourceInput) SetDomainName(v string) *GetDataSourceInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataSourceInput) SetName(v string) *GetDataSourceInput {
	s.Name = &v
	return s
}

// The result of a GetDataSource operation.
type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The type of data source.
	DataSourceType *DataSourceType `type:"structure"`

	// A description of the data source.
	Description *string `type:"string"`

	// The name of the data source.
	Name *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSourceType sets the DataSourceType field's value.
func (s *GetDataSourceOutput) SetDataSourceType(v *DataSourceType) *GetDataSourceOutput {
	s.DataSourceType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDataSourceOutput) SetDescription(v string) *GetDataSourceOutput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataSourceOutput) SetName(v string) *GetDataSourceOutput {
	s.Name = &v
	return s
}

// Container for the parameters to the GetDomainMaintenanceStatus operation.
type GetDomainMaintenanceStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The request ID of the maintenance action.
	//
	// MaintenanceId is a required field
	MaintenanceId *string `location:"querystring" locationName:"maintenanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainMaintenanceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainMaintenanceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainMaintenanceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainMaintenanceStatusInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.MaintenanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("MaintenanceId"))
	}
	if s.MaintenanceId != nil && len(*s.MaintenanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaintenanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainMaintenanceStatusInput) SetDomainName(v string) *GetDomainMaintenanceStatusInput {
	s.DomainName = &v
	return s
}

// SetMaintenanceId sets the MaintenanceId field's value.
func (s *GetDomainMaintenanceStatusInput) SetMaintenanceId(v string) *GetDomainMaintenanceStatusInput {
	s.MaintenanceId = &v
	return s
}

// The result of a GetDomainMaintenanceStatus request that information about
// the requested action.
type GetDomainMaintenanceStatusOutput struct {
	_ struct{} `type:"structure"`

	// The action name.
	Action *string `type:"string" enum:"MaintenanceType"`

	// The time at which the action was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The node ID of the maintenance action.
	NodeId *string `min:"10" type:"string"`

	// The status of the maintenance action.
	Status *string `type:"string" enum:"MaintenanceStatus"`

	// The status message of the maintenance action.
	StatusMessage *string `type:"string"`

	// The time at which the action was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainMaintenanceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainMaintenanceStatusOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetDomainMaintenanceStatusOutput) SetAction(v string) *GetDomainMaintenanceStatusOutput {
	s.Action = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDomainMaintenanceStatusOutput) SetCreatedAt(v time.Time) *GetDomainMaintenanceStatusOutput {
	s.CreatedAt = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *GetDomainMaintenanceStatusOutput) SetNodeId(v string) *GetDomainMaintenanceStatusOutput {
	s.NodeId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDomainMaintenanceStatusOutput) SetStatus(v string) *GetDomainMaintenanceStatusOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetDomainMaintenanceStatusOutput) SetStatusMessage(v string) *GetDomainMaintenanceStatusOutput {
	s.StatusMessage = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDomainMaintenanceStatusOutput) SetUpdatedAt(v time.Time) *GetDomainMaintenanceStatusOutput {
	s.UpdatedAt = &v
	return s
}

// Container for the request parameters to the GetPackageVersionHistory operation.
type GetPackageVersionHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial GetPackageVersionHistory operation returns a nextToken, you
	// can include the returned nextToken in subsequent GetPackageVersionHistory
	// operations, which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The unique identifier of the package.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPackageVersionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPackageVersionHistoryInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPackageVersionHistoryInput) SetMaxResults(v int64) *GetPackageVersionHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPackageVersionHistoryInput) SetNextToken(v string) *GetPackageVersionHistoryInput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *GetPackageVersionHistoryInput) SetPackageID(v string) *GetPackageVersionHistoryInput {
	s.PackageID = &v
	return s
}

// Container for response returned by GetPackageVersionHistory operation.
type GetPackageVersionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// The unique identifier of the package.
	PackageID *string `type:"string"`

	// A list of package versions, along with their creation time and commit message.
	PackageVersionHistoryList []*PackageVersionHistory `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetPackageVersionHistoryOutput) SetNextToken(v string) *GetPackageVersionHistoryOutput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *GetPackageVersionHistoryOutput) SetPackageID(v string) *GetPackageVersionHistoryOutput {
	s.PackageID = &v
	return s
}

// SetPackageVersionHistoryList sets the PackageVersionHistoryList field's value.
func (s *GetPackageVersionHistoryOutput) SetPackageVersionHistoryList(v []*PackageVersionHistory) *GetPackageVersionHistoryOutput {
	s.PackageVersionHistoryList = v
	return s
}

// Container for the request parameters to the GetUpgradeHistory operation.
type GetUpgradeHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an existing domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial GetUpgradeHistory operation returns a nextToken, you can
	// include the returned nextToken in subsequent GetUpgradeHistory operations,
	// which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeHistoryInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeHistoryInput) SetDomainName(v string) *GetUpgradeHistoryInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUpgradeHistoryInput) SetMaxResults(v int64) *GetUpgradeHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryInput) SetNextToken(v string) *GetUpgradeHistoryInput {
	s.NextToken = &v
	return s
}

// Container for the response returned by the GetUpgradeHistory operation.
type GetUpgradeHistoryOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// A list of objects corresponding to each upgrade or upgrade eligibility check
	// performed on a domain.
	UpgradeHistories []*UpgradeHistory `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryOutput) SetNextToken(v string) *GetUpgradeHistoryOutput {
	s.NextToken = &v
	return s
}

// SetUpgradeHistories sets the UpgradeHistories field's value.
func (s *GetUpgradeHistoryOutput) SetUpgradeHistories(v []*UpgradeHistory) *GetUpgradeHistoryOutput {
	s.UpgradeHistories = v
	return s
}

// Container for the request parameters to the GetUpgradeStatus operation.
type GetUpgradeStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The domain of the domain to get upgrade status information for.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeStatusInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeStatusInput) SetDomainName(v string) *GetUpgradeStatusInput {
	s.DomainName = &v
	return s
}

// Container for the response returned by the GetUpgradeStatus operation.
type GetUpgradeStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the current step that an upgrade is on.
	StepStatus *string `type:"string" enum:"UpgradeStatus"`

	// A string that describes the update.
	UpgradeName *string `type:"string"`

	// One of three steps that an upgrade or upgrade eligibility check goes through.
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusOutput) GoString() string {
	return s.String()
}

// SetStepStatus sets the StepStatus field's value.
func (s *GetUpgradeStatusOutput) SetStepStatus(v string) *GetUpgradeStatusOutput {
	s.StepStatus = &v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeName(v string) *GetUpgradeStatusOutput {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeStep(v string) *GetUpgradeStatusOutput {
	s.UpgradeStep = &v
	return s
}

// The IP address type status for the domain.
type IPAddressTypeStatus struct {
	_ struct{} `type:"structure"`

	// The IP address options for the domain.
	//
	// Options is a required field
	Options *string `type:"string" required:"true" enum:"IPAddressType"`

	// Provides the current status of an entity.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPAddressTypeStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPAddressTypeStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *IPAddressTypeStatus) SetOptions(v string) *IPAddressTypeStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IPAddressTypeStatus) SetStatus(v *OptionStatus) *IPAddressTypeStatus {
	s.Status = v
	return s
}

// Describes an inbound cross-cluster connection for Amazon OpenSearch Service.
// For more information, see Cross-cluster search for Amazon OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
type InboundConnection struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the connection.
	ConnectionId *string `min:"10" type:"string"`

	// The connection mode.
	ConnectionMode *string `type:"string" enum:"ConnectionMode"`

	// The current status of the connection.
	ConnectionStatus *InboundConnectionStatus `type:"structure"`

	// Information about the source (local) domain.
	LocalDomainInfo *DomainInformationContainer `type:"structure"`

	// Information about the destination (remote) domain.
	RemoteDomainInfo *DomainInformationContainer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnection) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *InboundConnection) SetConnectionId(v string) *InboundConnection {
	s.ConnectionId = &v
	return s
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *InboundConnection) SetConnectionMode(v string) *InboundConnection {
	s.ConnectionMode = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *InboundConnection) SetConnectionStatus(v *InboundConnectionStatus) *InboundConnection {
	s.ConnectionStatus = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *InboundConnection) SetLocalDomainInfo(v *DomainInformationContainer) *InboundConnection {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *InboundConnection) SetRemoteDomainInfo(v *DomainInformationContainer) *InboundConnection {
	s.RemoteDomainInfo = v
	return s
}

// The status of an inbound cross-cluster connection for OpenSearch Service.
type InboundConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Information about the connection.
	Message *string `type:"string"`

	// The status code for the connection. Can be one of the following:
	//
	//    * PENDING_ACCEPTANCE - Inbound connection is not yet accepted by the remote
	//    domain owner.
	//
	//    * APPROVED: Inbound connection is pending acceptance by the remote domain
	//    owner.
	//
	//    * PROVISIONING: Inbound connection is being provisioned.
	//
	//    * ACTIVE: Inbound connection is active and ready to use.
	//
	//    * REJECTING: Inbound connection rejection is in process.
	//
	//    * REJECTED: Inbound connection is rejected.
	//
	//    * DELETING: Inbound connection deletion is in progress.
	//
	//    * DELETED: Inbound connection is deleted and can no longer be used.
	StatusCode *string `type:"string" enum:"InboundConnectionStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnectionStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *InboundConnectionStatus) SetMessage(v string) *InboundConnectionStatus {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *InboundConnectionStatus) SetStatusCode(v string) *InboundConnectionStatus {
	s.StatusCode = &v
	return s
}

// Limits on the number of instances that can be created in OpenSearch Service
// for a given instance type.
type InstanceCountLimits struct {
	_ struct{} `type:"structure"`

	// The minimum allowed number of instances.
	MaximumInstanceCount *int64 `type:"integer"`

	// The maximum allowed number of instances.
	MinimumInstanceCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCountLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCountLimits) GoString() string {
	return s.String()
}

// SetMaximumInstanceCount sets the MaximumInstanceCount field's value.
func (s *InstanceCountLimits) SetMaximumInstanceCount(v int64) *InstanceCountLimits {
	s.MaximumInstanceCount = &v
	return s
}

// SetMinimumInstanceCount sets the MinimumInstanceCount field's value.
func (s *InstanceCountLimits) SetMinimumInstanceCount(v int64) *InstanceCountLimits {
	s.MinimumInstanceCount = &v
	return s
}

// Instance-related attributes that are available for a given instance type.
type InstanceLimits struct {
	_ struct{} `type:"structure"`

	// Limits on the number of instances that can be created for a given instance
	// type.
	InstanceCountLimits *InstanceCountLimits `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceLimits) GoString() string {
	return s.String()
}

// SetInstanceCountLimits sets the InstanceCountLimits field's value.
func (s *InstanceLimits) SetInstanceCountLimits(v *InstanceCountLimits) *InstanceLimits {
	s.InstanceCountLimits = v
	return s
}

// Lists all instance types and available features for a given OpenSearch or
// Elasticsearch version.
type InstanceTypeDetails struct {
	_ struct{} `type:"structure"`

	// Whether fine-grained access control is supported for the instance type.
	AdvancedSecurityEnabled *bool `type:"boolean"`

	// Whether logging is supported for the instance type.
	AppLogsEnabled *bool `type:"boolean"`

	// The supported Availability Zones for the instance type.
	AvailabilityZones []*string `type:"list"`

	// Whether Amazon Cognito access is supported for the instance type.
	CognitoEnabled *bool `type:"boolean"`

	// Whether encryption at rest and node-to-node encryption are supported for
	// the instance type.
	EncryptionEnabled *bool `type:"boolean"`

	// Whether the instance acts as a data node, a dedicated master node, or an
	// UltraWarm node.
	InstanceRole []*string `type:"list"`

	// The instance type.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// Whether UltraWarm is supported for the instance type.
	WarmEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceTypeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceTypeDetails) GoString() string {
	return s.String()
}

// SetAdvancedSecurityEnabled sets the AdvancedSecurityEnabled field's value.
func (s *InstanceTypeDetails) SetAdvancedSecurityEnabled(v bool) *InstanceTypeDetails {
	s.AdvancedSecurityEnabled = &v
	return s
}

// SetAppLogsEnabled sets the AppLogsEnabled field's value.
func (s *InstanceTypeDetails) SetAppLogsEnabled(v bool) *InstanceTypeDetails {
	s.AppLogsEnabled = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *InstanceTypeDetails) SetAvailabilityZones(v []*string) *InstanceTypeDetails {
	s.AvailabilityZones = v
	return s
}

// SetCognitoEnabled sets the CognitoEnabled field's value.
func (s *InstanceTypeDetails) SetCognitoEnabled(v bool) *InstanceTypeDetails {
	s.CognitoEnabled = &v
	return s
}

// SetEncryptionEnabled sets the EncryptionEnabled field's value.
func (s *InstanceTypeDetails) SetEncryptionEnabled(v bool) *InstanceTypeDetails {
	s.EncryptionEnabled = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *InstanceTypeDetails) SetInstanceRole(v []*string) *InstanceTypeDetails {
	s.InstanceRole = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeDetails) SetInstanceType(v string) *InstanceTypeDetails {
	s.InstanceType = &v
	return s
}

// SetWarmEnabled sets the WarmEnabled field's value.
func (s *InstanceTypeDetails) SetWarmEnabled(v bool) *InstanceTypeDetails {
	s.WarmEnabled = &v
	return s
}

// Request processing failed because of an unknown error, exception, or internal
// failure.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request processing failed because you provided an invalid pagination token.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for trying to create or access a sub-resource that's either
// invalid or not supported.
type InvalidTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidTypeException(v protocol.ResponseMetadata) error {
	return &InvalidTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTypeException) Code() string {
	return "InvalidTypeException"
}

// Message returns the exception's message.
func (s *InvalidTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTypeException) OrigErr() error {
	return nil
}

func (s *InvalidTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for trying to create more than the allowed number of resources
// or sub-resources.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Limits for a given instance type and for each of its roles.
type Limits struct {
	_ struct{} `type:"structure"`

	// List of additional limits that are specific to a given instance type for
	// each of its instance roles.
	AdditionalLimits []*AdditionalLimit `type:"list"`

	// The limits for a given instance type.
	InstanceLimits *InstanceLimits `type:"structure"`

	// Storage-related attributes that are available for a given instance type.
	StorageTypes []*StorageType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limits) GoString() string {
	return s.String()
}

// SetAdditionalLimits sets the AdditionalLimits field's value.
func (s *Limits) SetAdditionalLimits(v []*AdditionalLimit) *Limits {
	s.AdditionalLimits = v
	return s
}

// SetInstanceLimits sets the InstanceLimits field's value.
func (s *Limits) SetInstanceLimits(v *InstanceLimits) *Limits {
	s.InstanceLimits = v
	return s
}

// SetStorageTypes sets the StorageTypes field's value.
func (s *Limits) SetStorageTypes(v []*StorageType) *Limits {
	s.StorageTypes = v
	return s
}

// Container for the parameters to the ListDataSources operation.
type ListDataSourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListDataSourcesInput) SetDomainName(v string) *ListDataSourcesInput {
	s.DomainName = &v
	return s
}

// The result of a ListDataSources operation.
type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of data sources associated with specified domain.
	DataSources []*DataSourceDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetDataSources sets the DataSources field's value.
func (s *ListDataSourcesOutput) SetDataSources(v []*DataSourceDetails) *ListDataSourcesOutput {
	s.DataSources = v
	return s
}

// Container for the parameters to the ListDomainMaintenances operation.
type ListDomainMaintenancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the action.
	Action *string `location:"querystring" locationName:"action" type:"string" enum:"MaintenanceType"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial ListDomainMaintenances operation returns a nextToken, include
	// the returned nextToken in subsequent ListDomainMaintenances operations, which
	// returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The status of the action.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"MaintenanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainMaintenancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainMaintenancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainMaintenancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainMaintenancesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ListDomainMaintenancesInput) SetAction(v string) *ListDomainMaintenancesInput {
	s.Action = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ListDomainMaintenancesInput) SetDomainName(v string) *ListDomainMaintenancesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainMaintenancesInput) SetMaxResults(v int64) *ListDomainMaintenancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainMaintenancesInput) SetNextToken(v string) *ListDomainMaintenancesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDomainMaintenancesInput) SetStatus(v string) *ListDomainMaintenancesInput {
	s.Status = &v
	return s
}

// The result of a ListDomainMaintenances request that contains information
// about the requested actions.
type ListDomainMaintenancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the submitted maintenance actions.
	DomainMaintenances []*DomainMaintenanceDetails `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainMaintenancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainMaintenancesOutput) GoString() string {
	return s.String()
}

// SetDomainMaintenances sets the DomainMaintenances field's value.
func (s *ListDomainMaintenancesOutput) SetDomainMaintenances(v []*DomainMaintenanceDetails) *ListDomainMaintenancesOutput {
	s.DomainMaintenances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainMaintenancesOutput) SetNextToken(v string) *ListDomainMaintenancesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListDomainNames operation.
type ListDomainNamesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Filters the output by domain engine type.
	EngineType *string `location:"querystring" locationName:"engineType" type:"string" enum:"EngineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// SetEngineType sets the EngineType field's value.
func (s *ListDomainNamesInput) SetEngineType(v string) *ListDomainNamesInput {
	s.EngineType = &v
	return s
}

// The results of a ListDomainNames operation. Contains the names of all domains
// owned by this account and their respective engine types.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// The names of all OpenSearch Service domains owned by the current user and
	// their respective engine types.
	DomainNames []*DomainInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainNamesOutput) SetDomainNames(v []*DomainInfo) *ListDomainNamesOutput {
	s.DomainNames = v
	return s
}

// Container for the request parameters to the ListDomainsForPackage operation.
type ListDomainsForPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial ListDomainsForPackage operation returns a nextToken, you
	// can include the returned nextToken in subsequent ListDomainsForPackage operations,
	// which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The unique identifier of the package for which to list associated domains.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsForPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsForPackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsForPackageInput) SetMaxResults(v int64) *ListDomainsForPackageInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsForPackageInput) SetNextToken(v string) *ListDomainsForPackageInput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *ListDomainsForPackageInput) SetPackageID(v string) *ListDomainsForPackageInput {
	s.PackageID = &v
	return s
}

// Container for the response parameters to the ListDomainsForPackage operation.
type ListDomainsForPackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about all domains associated with a package.
	DomainPackageDetailsList []*DomainPackageDetails `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetailsList sets the DomainPackageDetailsList field's value.
func (s *ListDomainsForPackageOutput) SetDomainPackageDetailsList(v []*DomainPackageDetails) *ListDomainsForPackageOutput {
	s.DomainPackageDetailsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsForPackageOutput) SetNextToken(v string) *ListDomainsForPackageOutput {
	s.NextToken = &v
	return s
}

type ListInstanceTypeDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// The version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y
	// or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.
	//
	// EngineVersion is a required field
	EngineVersion *string `location:"uri" locationName:"EngineVersion" min:"14" type:"string" required:"true"`

	// An optional parameter that lists information for a given instance type.
	InstanceType *string `location:"querystring" locationName:"instanceType" min:"10" type:"string"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial ListInstanceTypeDetails operation returns a nextToken, you
	// can include the returned nextToken in subsequent ListInstanceTypeDetails
	// operations, which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional parameter that specifies the Availability Zones for the domain.
	RetrieveAZs *bool `location:"querystring" locationName:"retrieveAZs" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceTypeDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceTypeDetailsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.EngineVersion != nil && len(*s.EngineVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EngineVersion", 14))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListInstanceTypeDetailsInput) SetDomainName(v string) *ListInstanceTypeDetailsInput {
	s.DomainName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ListInstanceTypeDetailsInput) SetEngineVersion(v string) *ListInstanceTypeDetailsInput {
	s.EngineVersion = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ListInstanceTypeDetailsInput) SetInstanceType(v string) *ListInstanceTypeDetailsInput {
	s.InstanceType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstanceTypeDetailsInput) SetMaxResults(v int64) *ListInstanceTypeDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstanceTypeDetailsInput) SetNextToken(v string) *ListInstanceTypeDetailsInput {
	s.NextToken = &v
	return s
}

// SetRetrieveAZs sets the RetrieveAZs field's value.
func (s *ListInstanceTypeDetailsInput) SetRetrieveAZs(v bool) *ListInstanceTypeDetailsInput {
	s.RetrieveAZs = &v
	return s
}

type ListInstanceTypeDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Lists all supported instance types and features for the given OpenSearch
	// or Elasticsearch version.
	InstanceTypeDetails []*InstanceTypeDetails `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsOutput) GoString() string {
	return s.String()
}

// SetInstanceTypeDetails sets the InstanceTypeDetails field's value.
func (s *ListInstanceTypeDetailsOutput) SetInstanceTypeDetails(v []*InstanceTypeDetails) *ListInstanceTypeDetailsOutput {
	s.InstanceTypeDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstanceTypeDetailsOutput) SetNextToken(v string) *ListInstanceTypeDetailsOutput {
	s.NextToken = &v
	return s
}

// Container for the request parameters to the ListPackagesForDomain operation.
type ListPackagesForDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain for which you want to list associated packages.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial ListPackagesForDomain operation returns a nextToken, you
	// can include the returned nextToken in subsequent ListPackagesForDomain operations,
	// which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagesForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagesForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListPackagesForDomainInput) SetDomainName(v string) *ListPackagesForDomainInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagesForDomainInput) SetMaxResults(v int64) *ListPackagesForDomainInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesForDomainInput) SetNextToken(v string) *ListPackagesForDomainInput {
	s.NextToken = &v
	return s
}

// Container for the response parameters to the ListPackagesForDomain operation.
type ListPackagesForDomainOutput struct {
	_ struct{} `type:"structure"`

	// List of all packages associated with a domain.
	DomainPackageDetailsList []*DomainPackageDetails `type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetailsList sets the DomainPackageDetailsList field's value.
func (s *ListPackagesForDomainOutput) SetDomainPackageDetailsList(v []*DomainPackageDetails) *ListPackagesForDomainOutput {
	s.DomainPackageDetailsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesForDomainOutput) SetNextToken(v string) *ListPackagesForDomainOutput {
	s.NextToken = &v
	return s
}

type ListScheduledActionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial ListScheduledActions operation returns a nextToken, you can
	// include the returned nextToken in subsequent ListScheduledActions operations,
	// which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScheduledActionsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListScheduledActionsInput) SetDomainName(v string) *ListScheduledActionsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScheduledActionsInput) SetMaxResults(v int64) *ListScheduledActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledActionsInput) SetNextToken(v string) *ListScheduledActionsInput {
	s.NextToken = &v
	return s
}

type ListScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// A list of actions that are scheduled for the domain.
	ScheduledActions []*ScheduledAction `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledActionsOutput) SetNextToken(v string) *ListScheduledActionsOutput {
	s.NextToken = &v
	return s
}

// SetScheduledActions sets the ScheduledActions field's value.
func (s *ListScheduledActionsOutput) SetScheduledActions(v []*ScheduledAction) *ListScheduledActionsOutput {
	s.ScheduledActions = v
	return s
}

// Container for the parameters to the ListTags operation.
type ListTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Resource Name (ARN) for the domain to view tags for.
	//
	// ARN is a required field
	ARN *string `location:"querystring" locationName:"arn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *ListTagsInput) SetARN(v string) *ListTagsInput {
	s.ARN = &v
	return s
}

// The results of a ListTags operation.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// List of resource tags associated with the specified domain.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

// Container for the request parameters to the ListVersions operation.
type ListVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If your initial ListVersions operation returns a nextToken, you can include
	// the returned nextToken in subsequent ListVersions operations, which returns
	// results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVersionsInput) SetMaxResults(v int64) *ListVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVersionsInput) SetNextToken(v string) *ListVersionsInput {
	s.NextToken = &v
	return s
}

// Container for the parameters for response received from the ListVersions
// operation.
type ListVersionsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `type:"string"`

	// A list of all versions of OpenSearch and Elasticsearch that Amazon OpenSearch
	// Service supports.
	Versions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVersionsOutput) SetNextToken(v string) *ListVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListVersionsOutput) SetVersions(v []*string) *ListVersionsOutput {
	s.Versions = v
	return s
}

type ListVpcEndpointAccessInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the OpenSearch Service domain to retrieve access information
	// for.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// If your initial ListVpcEndpointAccess operation returns a nextToken, you
	// can include the returned nextToken in subsequent ListVpcEndpointAccess operations,
	// which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVpcEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVpcEndpointAccessInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListVpcEndpointAccessInput) SetDomainName(v string) *ListVpcEndpointAccessInput {
	s.DomainName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointAccessInput) SetNextToken(v string) *ListVpcEndpointAccessInput {
	s.NextToken = &v
	return s
}

type ListVpcEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// A list of IAM principals (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html)
	// that can currently access the domain.
	//
	// AuthorizedPrincipalList is a required field
	AuthorizedPrincipalList []*AuthorizedPrincipal `type:"list" required:"true"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	//
	// NextToken is a required field
	NextToken *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetAuthorizedPrincipalList sets the AuthorizedPrincipalList field's value.
func (s *ListVpcEndpointAccessOutput) SetAuthorizedPrincipalList(v []*AuthorizedPrincipal) *ListVpcEndpointAccessOutput {
	s.AuthorizedPrincipalList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointAccessOutput) SetNextToken(v string) *ListVpcEndpointAccessOutput {
	s.NextToken = &v
	return s
}

type ListVpcEndpointsForDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain to list associated VPC endpoints for.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// If your initial ListEndpointsForDomain operation returns a nextToken, you
	// can include the returned nextToken in subsequent ListEndpointsForDomain operations,
	// which returns results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVpcEndpointsForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVpcEndpointsForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListVpcEndpointsForDomainInput) SetDomainName(v string) *ListVpcEndpointsForDomainInput {
	s.DomainName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointsForDomainInput) SetNextToken(v string) *ListVpcEndpointsForDomainInput {
	s.NextToken = &v
	return s
}

type ListVpcEndpointsForDomainOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	//
	// NextToken is a required field
	NextToken *string `type:"string" required:"true"`

	// Information about each endpoint associated with the domain.
	//
	// VpcEndpointSummaryList is a required field
	VpcEndpointSummaryList []*VpcEndpointSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsForDomainOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointsForDomainOutput) SetNextToken(v string) *ListVpcEndpointsForDomainOutput {
	s.NextToken = &v
	return s
}

// SetVpcEndpointSummaryList sets the VpcEndpointSummaryList field's value.
func (s *ListVpcEndpointsForDomainOutput) SetVpcEndpointSummaryList(v []*VpcEndpointSummary) *ListVpcEndpointsForDomainOutput {
	s.VpcEndpointSummaryList = v
	return s
}

type ListVpcEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If your initial ListVpcEndpoints operation returns a nextToken, you can include
	// the returned nextToken in subsequent ListVpcEndpoints operations, which returns
	// results in the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointsInput) SetNextToken(v string) *ListVpcEndpointsInput {
	s.NextToken = &v
	return s
}

type ListVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	//
	// NextToken is a required field
	NextToken *string `type:"string" required:"true"`

	// Information about each endpoint.
	//
	// VpcEndpointSummaryList is a required field
	VpcEndpointSummaryList []*VpcEndpointSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointsOutput) SetNextToken(v string) *ListVpcEndpointsOutput {
	s.NextToken = &v
	return s
}

// SetVpcEndpointSummaryList sets the VpcEndpointSummaryList field's value.
func (s *ListVpcEndpointsOutput) SetVpcEndpointSummaryList(v []*VpcEndpointSummary) *ListVpcEndpointsOutput {
	s.VpcEndpointSummaryList = v
	return s
}

// Specifies whether the Amazon OpenSearch Service domain publishes the OpenSearch
// application and slow logs to Amazon CloudWatch. For more information, see
// Monitoring OpenSearch logs with Amazon CloudWatch Logs (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html).
//
// After you enable log publishing, you still have to enable the collection
// of slow logs using the OpenSearch REST API.
type LogPublishingOption struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudWatch Logs group to publish logs
	// to.
	CloudWatchLogsLogGroupArn *string `min:"20" type:"string"`

	// Whether the log should be published.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogPublishingOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogPublishingOption"}
	if s.CloudWatchLogsLogGroupArn != nil && len(*s.CloudWatchLogsLogGroupArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogsLogGroupArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *LogPublishingOption) SetCloudWatchLogsLogGroupArn(v string) *LogPublishingOption {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LogPublishingOption) SetEnabled(v bool) *LogPublishingOption {
	s.Enabled = &v
	return s
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The log publishing options configured for the domain.
	Options map[string]*LogPublishingOption `type:"map"`

	// The status of the log publishing options for the domain.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *LogPublishingOptionsStatus) SetOptions(v map[string]*LogPublishingOption) *LogPublishingOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LogPublishingOptionsStatus) SetStatus(v *OptionStatus) *LogPublishingOptionsStatus {
	s.Status = v
	return s
}

// Credentials for the master user for a domain.
type MasterUserOptions struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) for the master user. Only specify if InternalUserDatabaseEnabled
	// is false.
	MasterUserARN *string `min:"20" type:"string"`

	// User name for the master user. Only specify if InternalUserDatabaseEnabled
	// is true.
	//
	// MasterUserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MasterUserOptions's
	// String and GoString methods.
	MasterUserName *string `min:"1" type:"string" sensitive:"true"`

	// Password for the master user. Only specify if InternalUserDatabaseEnabled
	// is true.
	//
	// MasterUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MasterUserOptions's
	// String and GoString methods.
	MasterUserPassword *string `min:"8" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MasterUserOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MasterUserOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MasterUserOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MasterUserOptions"}
	if s.MasterUserARN != nil && len(*s.MasterUserARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserARN", 20))
	}
	if s.MasterUserName != nil && len(*s.MasterUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserName", 1))
	}
	if s.MasterUserPassword != nil && len(*s.MasterUserPassword) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserPassword", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMasterUserARN sets the MasterUserARN field's value.
func (s *MasterUserOptions) SetMasterUserARN(v string) *MasterUserOptions {
	s.MasterUserARN = &v
	return s
}

// SetMasterUserName sets the MasterUserName field's value.
func (s *MasterUserOptions) SetMasterUserName(v string) *MasterUserOptions {
	s.MasterUserName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *MasterUserOptions) SetMasterUserPassword(v string) *MasterUserOptions {
	s.MasterUserPassword = &v
	return s
}

// Enables or disables node-to-node encryption. For more information, see Node-to-node
// encryption for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html).
type NodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// True to enable node-to-node encryption.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *NodeToNodeEncryptionOptions) SetEnabled(v bool) *NodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Status of the node-to-node encryption options for the specified domain.
type NodeToNodeEncryptionOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The node-to-node encryption options for the specified domain.
	//
	// Options is a required field
	Options *NodeToNodeEncryptionOptions `type:"structure" required:"true"`

	// The status of the node-to-node encryption options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetOptions(v *NodeToNodeEncryptionOptions) *NodeToNodeEncryptionOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetStatus(v *OptionStatus) *NodeToNodeEncryptionOptionsStatus {
	s.Status = v
	return s
}

// A custom 10-hour, low-traffic window during which OpenSearch Service can
// perform mandatory configuration changes on the domain. These actions can
// include scheduled service software updates and blue/green Auto-Tune enhancements.
// OpenSearch Service will schedule these actions during the window that you
// specify.
//
// If you don't specify a window start time, it defaults to 10:00 P.M. local
// time.
//
// For more information, see Defining off-peak maintenance windows for Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html).
type OffPeakWindow struct {
	_ struct{} `type:"structure"`

	// A custom start time for the off-peak window, in Coordinated Universal Time
	// (UTC). The window length will always be 10 hours, so you can't specify an
	// end time. For example, if you specify 11:00 P.M. UTC as a start time, the
	// end time will automatically be set to 9:00 A.M.
	WindowStartTime *WindowStartTime `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OffPeakWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OffPeakWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OffPeakWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OffPeakWindow"}
	if s.WindowStartTime != nil {
		if err := s.WindowStartTime.Validate(); err != nil {
			invalidParams.AddNested("WindowStartTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowStartTime sets the WindowStartTime field's value.
func (s *OffPeakWindow) SetWindowStartTime(v *WindowStartTime) *OffPeakWindow {
	s.WindowStartTime = v
	return s
}

// Options for a domain's off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html),
// during which OpenSearch Service can perform mandatory configuration changes
// on the domain.
type OffPeakWindowOptions struct {
	_ struct{} `type:"structure"`

	// Whether to enable an off-peak window.
	//
	// This option is only available when modifying a domain created prior to February
	// 16, 2023, not when creating a new domain. All domains created after this
	// date have the off-peak window enabled by default. You can't disable the off-peak
	// window after it's enabled for a domain.
	Enabled *bool `type:"boolean"`

	// Off-peak window settings for the domain.
	OffPeakWindow *OffPeakWindow `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OffPeakWindowOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OffPeakWindowOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OffPeakWindowOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OffPeakWindowOptions"}
	if s.OffPeakWindow != nil {
		if err := s.OffPeakWindow.Validate(); err != nil {
			invalidParams.AddNested("OffPeakWindow", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *OffPeakWindowOptions) SetEnabled(v bool) *OffPeakWindowOptions {
	s.Enabled = &v
	return s
}

// SetOffPeakWindow sets the OffPeakWindow field's value.
func (s *OffPeakWindowOptions) SetOffPeakWindow(v *OffPeakWindow) *OffPeakWindowOptions {
	s.OffPeakWindow = v
	return s
}

// The status of off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html)
// options for a domain.
type OffPeakWindowOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The domain's off-peak window configuration.
	Options *OffPeakWindowOptions `type:"structure"`

	// The current status of off-peak window options.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OffPeakWindowOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OffPeakWindowOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *OffPeakWindowOptionsStatus) SetOptions(v *OffPeakWindowOptions) *OffPeakWindowOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *OffPeakWindowOptionsStatus) SetStatus(v *OptionStatus) *OffPeakWindowOptionsStatus {
	s.Status = v
	return s
}

// Provides the current status of an entity.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp when the entity was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the entity is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// The state of the entity.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// The timestamp of the last time the entity was updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// The latest version of the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptionStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *OptionStatus) SetCreationDate(v time.Time) *OptionStatus {
	s.CreationDate = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *OptionStatus) SetPendingDeletion(v bool) *OptionStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *OptionStatus) SetState(v string) *OptionStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OptionStatus) SetUpdateDate(v time.Time) *OptionStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *OptionStatus) SetUpdateVersion(v int64) *OptionStatus {
	s.UpdateVersion = &v
	return s
}

// Specifies details about an outbound cross-cluster connection.
type OutboundConnection struct {
	_ struct{} `type:"structure"`

	// Name of the connection.
	ConnectionAlias *string `min:"2" type:"string"`

	// Unique identifier of the connection.
	ConnectionId *string `min:"10" type:"string"`

	// The connection mode.
	ConnectionMode *string `type:"string" enum:"ConnectionMode"`

	// Properties for the outbound connection.
	ConnectionProperties *ConnectionProperties `type:"structure"`

	// Status of the connection.
	ConnectionStatus *OutboundConnectionStatus `type:"structure"`

	// Information about the source (local) domain.
	LocalDomainInfo *DomainInformationContainer `type:"structure"`

	// Information about the destination (remote) domain.
	RemoteDomainInfo *DomainInformationContainer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnection) GoString() string {
	return s.String()
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *OutboundConnection) SetConnectionAlias(v string) *OutboundConnection {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *OutboundConnection) SetConnectionId(v string) *OutboundConnection {
	s.ConnectionId = &v
	return s
}

// SetConnectionMode sets the ConnectionMode field's value.
func (s *OutboundConnection) SetConnectionMode(v string) *OutboundConnection {
	s.ConnectionMode = &v
	return s
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *OutboundConnection) SetConnectionProperties(v *ConnectionProperties) *OutboundConnection {
	s.ConnectionProperties = v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *OutboundConnection) SetConnectionStatus(v *OutboundConnectionStatus) *OutboundConnection {
	s.ConnectionStatus = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *OutboundConnection) SetLocalDomainInfo(v *DomainInformationContainer) *OutboundConnection {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *OutboundConnection) SetRemoteDomainInfo(v *DomainInformationContainer) *OutboundConnection {
	s.RemoteDomainInfo = v
	return s
}

// The status of an outbound cross-cluster connection.
type OutboundConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Verbose information for the outbound connection.
	Message *string `type:"string"`

	// The status code for the outbound connection. Can be one of the following:
	//
	//    * VALIDATING - The outbound connection request is being validated.
	//
	//    * VALIDATION_FAILED - Validation failed for the connection request.
	//
	//    * PENDING_ACCEPTANCE: Outbound connection request is validated and is
	//    not yet accepted by the remote domain owner.
	//
	//    * APPROVED - Outbound connection has been approved by the remote domain
	//    owner for getting provisioned.
	//
	//    * PROVISIONING - Outbound connection request is in process.
	//
	//    * ACTIVE - Outbound connection is active and ready to use.
	//
	//    * REJECTING - Outbound connection rejection by remote domain owner is
	//    in progress.
	//
	//    * REJECTED - Outbound connection request is rejected by remote domain
	//    owner.
	//
	//    * DELETING - Outbound connection deletion is in progress.
	//
	//    * DELETED - Outbound connection is deleted and can no longer be used.
	StatusCode *string `type:"string" enum:"OutboundConnectionStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnectionStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *OutboundConnectionStatus) SetMessage(v string) *OutboundConnectionStatus {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *OutboundConnectionStatus) SetStatusCode(v string) *OutboundConnectionStatus {
	s.StatusCode = &v
	return s
}

// Basic information about a package.
type PackageDetails struct {
	_ struct{} `type:"structure"`

	// The package version.
	AvailablePackageVersion *string `type:"string"`

	// If the package is a ZIP-PLUGIN package, additional information about plugin
	// properties.
	AvailablePluginProperties *PluginProperties `type:"structure"`

	// The timestamp when the package was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or
	// OpenSearch_X.Y. Defaults to the latest version of OpenSearch.
	EngineVersion *string `type:"string"`

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails `type:"structure"`

	// Date and time when the package was last updated.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// User-specified description of the package.
	PackageDescription *string `type:"string"`

	// The unique identifier of the package.
	PackageID *string `type:"string"`

	// The user-specified name of the package.
	PackageName *string `min:"3" type:"string"`

	// The current status of the package. The available options are AVAILABLE, COPYING,
	// COPY_FAILED, VALIDATNG, VALIDATION_FAILED, DELETING, and DELETE_FAILED.
	PackageStatus *string `type:"string" enum:"PackageStatus"`

	// The type of package.
	PackageType *string `type:"string" enum:"PackageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDetails) GoString() string {
	return s.String()
}

// SetAvailablePackageVersion sets the AvailablePackageVersion field's value.
func (s *PackageDetails) SetAvailablePackageVersion(v string) *PackageDetails {
	s.AvailablePackageVersion = &v
	return s
}

// SetAvailablePluginProperties sets the AvailablePluginProperties field's value.
func (s *PackageDetails) SetAvailablePluginProperties(v *PluginProperties) *PackageDetails {
	s.AvailablePluginProperties = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PackageDetails) SetCreatedAt(v time.Time) *PackageDetails {
	s.CreatedAt = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PackageDetails) SetEngineVersion(v string) *PackageDetails {
	s.EngineVersion = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *PackageDetails) SetErrorDetails(v *ErrorDetails) *PackageDetails {
	s.ErrorDetails = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PackageDetails) SetLastUpdatedAt(v time.Time) *PackageDetails {
	s.LastUpdatedAt = &v
	return s
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *PackageDetails) SetPackageDescription(v string) *PackageDetails {
	s.PackageDescription = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *PackageDetails) SetPackageID(v string) *PackageDetails {
	s.PackageID = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageDetails) SetPackageName(v string) *PackageDetails {
	s.PackageName = &v
	return s
}

// SetPackageStatus sets the PackageStatus field's value.
func (s *PackageDetails) SetPackageStatus(v string) *PackageDetails {
	s.PackageStatus = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *PackageDetails) SetPackageType(v string) *PackageDetails {
	s.PackageType = &v
	return s
}

// The Amazon S3 location to import the package from.
type PackageSource struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket containing the package.
	S3BucketName *string `min:"3" type:"string"`

	// Key (file name) of the package.
	S3Key *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageSource"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *PackageSource) SetS3BucketName(v string) *PackageSource {
	s.S3BucketName = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *PackageSource) SetS3Key(v string) *PackageSource {
	s.S3Key = &v
	return s
}

// Details about a package version.
type PackageVersionHistory struct {
	_ struct{} `type:"structure"`

	// A message associated with the package version when it was uploaded.
	CommitMessage *string `type:"string"`

	// The date and time when the package was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The package version.
	PackageVersion *string `type:"string"`

	// Additional information about plugin properties if the package is a ZIP-PLUGIN
	// package.
	PluginProperties *PluginProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionHistory) GoString() string {
	return s.String()
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *PackageVersionHistory) SetCommitMessage(v string) *PackageVersionHistory {
	s.CommitMessage = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PackageVersionHistory) SetCreatedAt(v time.Time) *PackageVersionHistory {
	s.CreatedAt = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PackageVersionHistory) SetPackageVersion(v string) *PackageVersionHistory {
	s.PackageVersion = &v
	return s
}

// SetPluginProperties sets the PluginProperties field's value.
func (s *PackageVersionHistory) SetPluginProperties(v *PluginProperties) *PackageVersionHistory {
	s.PluginProperties = v
	return s
}

// Basic information about the plugin.
type PluginProperties struct {
	_ struct{} `type:"structure"`

	// The name of the class to load.
	ClassName *string `type:"string"`

	// The description of the plugin.
	Description *string `type:"string"`

	// The name of the plugin.
	Name *string `type:"string"`

	// The uncompressed size of the plugin.
	UncompressedSizeInBytes *int64 `type:"long"`

	// The version of the plugin.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginProperties) GoString() string {
	return s.String()
}

// SetClassName sets the ClassName field's value.
func (s *PluginProperties) SetClassName(v string) *PluginProperties {
	s.ClassName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PluginProperties) SetDescription(v string) *PluginProperties {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PluginProperties) SetName(v string) *PluginProperties {
	s.Name = &v
	return s
}

// SetUncompressedSizeInBytes sets the UncompressedSizeInBytes field's value.
func (s *PluginProperties) SetUncompressedSizeInBytes(v int64) *PluginProperties {
	s.UncompressedSizeInBytes = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PluginProperties) SetVersion(v string) *PluginProperties {
	s.Version = &v
	return s
}

// Container for request parameters to the PurchaseReservedInstanceOffering
// operation.
type PurchaseReservedInstanceOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of OpenSearch instances to reserve.
	InstanceCount *int64 `min:"1" type:"integer"`

	// A customer-specified identifier to track this reservation.
	//
	// ReservationName is a required field
	ReservationName *string `min:"5" type:"string" required:"true"`

	// The ID of the Reserved Instance offering to purchase.
	//
	// ReservedInstanceOfferingId is a required field
	ReservedInstanceOfferingId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedInstanceOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedInstanceOfferingInput"}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InstanceCount", 1))
	}
	if s.ReservationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationName"))
	}
	if s.ReservationName != nil && len(*s.ReservationName) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationName", 5))
	}
	if s.ReservedInstanceOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedInstanceOfferingId"))
	}
	if s.ReservedInstanceOfferingId != nil && len(*s.ReservedInstanceOfferingId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ReservedInstanceOfferingId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *PurchaseReservedInstanceOfferingInput) SetInstanceCount(v int64) *PurchaseReservedInstanceOfferingInput {
	s.InstanceCount = &v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedInstanceOfferingInput) SetReservationName(v string) *PurchaseReservedInstanceOfferingInput {
	s.ReservationName = &v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *PurchaseReservedInstanceOfferingInput) SetReservedInstanceOfferingId(v string) *PurchaseReservedInstanceOfferingInput {
	s.ReservedInstanceOfferingId = &v
	return s
}

// Represents the output of a PurchaseReservedInstanceOffering operation.
type PurchaseReservedInstanceOfferingOutput struct {
	_ struct{} `type:"structure"`

	// The customer-specified identifier used to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// The ID of the Reserved Instance offering that was purchased.
	ReservedInstanceId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingOutput) GoString() string {
	return s.String()
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedInstanceOfferingOutput) SetReservationName(v string) *PurchaseReservedInstanceOfferingOutput {
	s.ReservationName = &v
	return s
}

// SetReservedInstanceId sets the ReservedInstanceId field's value.
func (s *PurchaseReservedInstanceOfferingOutput) SetReservedInstanceId(v string) *PurchaseReservedInstanceOfferingOutput {
	s.ReservedInstanceId = &v
	return s
}

// Contains the specific price and frequency of a recurring charges for an OpenSearch
// Reserved Instance, or for a Reserved Instance offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Container for the request parameters to the RejectInboundConnection operation.
type RejectInboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the inbound connection to reject.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectInboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *RejectInboundConnectionInput) SetConnectionId(v string) *RejectInboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// Represents the output of a RejectInboundConnection operation.
type RejectInboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the rejected inbound connection.
	Connection *InboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *RejectInboundConnectionOutput) SetConnection(v *InboundConnection) *RejectInboundConnectionOutput {
	s.Connection = v
	return s
}

// Container for the request parameters to the RemoveTags operation.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain from which you want to delete
	// the specified tags.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The list of tag keys to remove from the domain.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RemoveTagsInput) SetARN(v string) *RemoveTagsInput {
	s.ARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Details of an OpenSearch Reserved Instance.
type ReservedInstance struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the billing subscription.
	BillingSubscriptionId *int64 `type:"long"`

	// The currency code for the offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the OpenSearch instance is reserved.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will paid to purchase the specific Reserved
	// Instance offering.
	FixedPrice *float64 `type:"double"`

	// The number of OpenSearch instances that have been reserved.
	InstanceCount *int64 `type:"integer"`

	// The OpenSearch instance type offered by theReserved Instance offering.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// The payment option as defined in the Reserved Instance offering.
	PaymentOption *string `type:"string" enum:"ReservedInstancePaymentOption"`

	// The recurring charge to your account, regardless of whether you create any
	// domains using the Reserved Instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The customer-specified identifier to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// The unique identifier for the reservation.
	ReservedInstanceId *string `min:"36" type:"string"`

	// The unique identifier of the Reserved Instance offering.
	ReservedInstanceOfferingId *string `type:"string"`

	// The date and time when the reservation was purchased.
	StartTime *time.Time `type:"timestamp"`

	// The state of the Reserved Instance.
	State *string `type:"string"`

	// The hourly rate at which you're charged for the domain using this Reserved
	// Instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstance) GoString() string {
	return s.String()
}

// SetBillingSubscriptionId sets the BillingSubscriptionId field's value.
func (s *ReservedInstance) SetBillingSubscriptionId(v int64) *ReservedInstance {
	s.BillingSubscriptionId = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedInstance) SetCurrencyCode(v string) *ReservedInstance {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedInstance) SetDuration(v int64) *ReservedInstance {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedInstance) SetFixedPrice(v float64) *ReservedInstance {
	s.FixedPrice = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ReservedInstance) SetInstanceCount(v int64) *ReservedInstance {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ReservedInstance) SetInstanceType(v string) *ReservedInstance {
	s.InstanceType = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedInstance) SetPaymentOption(v string) *ReservedInstance {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedInstance) SetRecurringCharges(v []*RecurringCharge) *ReservedInstance {
	s.RecurringCharges = v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *ReservedInstance) SetReservationName(v string) *ReservedInstance {
	s.ReservationName = &v
	return s
}

// SetReservedInstanceId sets the ReservedInstanceId field's value.
func (s *ReservedInstance) SetReservedInstanceId(v string) *ReservedInstance {
	s.ReservedInstanceId = &v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *ReservedInstance) SetReservedInstanceOfferingId(v string) *ReservedInstance {
	s.ReservedInstanceOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedInstance) SetStartTime(v time.Time) *ReservedInstance {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedInstance) SetState(v string) *ReservedInstance {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedInstance) SetUsagePrice(v float64) *ReservedInstance {
	s.UsagePrice = &v
	return s
}

// Details of an OpenSearch Reserved Instance offering.
type ReservedInstanceOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the Reserved Instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the OpenSearch
	// instance.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will pay to purchase the specific Reserved Instance
	// offering.
	FixedPrice *float64 `type:"double"`

	// The OpenSearch instance type offered by the Reserved Instance offering.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// Payment option for the Reserved Instance offering
	PaymentOption *string `type:"string" enum:"ReservedInstancePaymentOption"`

	// The recurring charge to your account, regardless of whether you creates any
	// domains using the offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The unique identifier of the Reserved Instance offering.
	ReservedInstanceOfferingId *string `min:"36" type:"string"`

	// The hourly rate at which you're charged for the domain using this Reserved
	// Instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstanceOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstanceOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedInstanceOffering) SetCurrencyCode(v string) *ReservedInstanceOffering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedInstanceOffering) SetDuration(v int64) *ReservedInstanceOffering {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedInstanceOffering) SetFixedPrice(v float64) *ReservedInstanceOffering {
	s.FixedPrice = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ReservedInstanceOffering) SetInstanceType(v string) *ReservedInstanceOffering {
	s.InstanceType = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedInstanceOffering) SetPaymentOption(v string) *ReservedInstanceOffering {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedInstanceOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedInstanceOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *ReservedInstanceOffering) SetReservedInstanceOfferingId(v string) *ReservedInstanceOffering {
	s.ReservedInstanceOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedInstanceOffering) SetUsagePrice(v float64) *ReservedInstanceOffering {
	s.UsagePrice = &v
	return s
}

// An exception for creating a resource that already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for accessing or deleting a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RevokeVpcEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// The account ID to revoke access from.
	//
	// Account is a required field
	Account *string `type:"string" required:"true"`

	// The name of the OpenSearch Service domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeVpcEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeVpcEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeVpcEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeVpcEndpointAccessInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *RevokeVpcEndpointAccessInput) SetAccount(v string) *RevokeVpcEndpointAccessInput {
	s.Account = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *RevokeVpcEndpointAccessInput) SetDomainName(v string) *RevokeVpcEndpointAccessInput {
	s.DomainName = &v
	return s
}

type RevokeVpcEndpointAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeVpcEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeVpcEndpointAccessOutput) GoString() string {
	return s.String()
}

// Information about the Amazon S3 Glue Data Catalog.
type S3GlueDataCatalog struct {
	_ struct{} `type:"structure"`

	// >The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3GlueDataCatalog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3GlueDataCatalog) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3GlueDataCatalog) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3GlueDataCatalog"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3GlueDataCatalog) SetRoleArn(v string) *S3GlueDataCatalog {
	s.RoleArn = &v
	return s
}

// The SAML identity povider information.
type SAMLIdp struct {
	_ struct{} `type:"structure"`

	// The unique entity ID of the application in the SAML identity provider.
	//
	// EntityId is a required field
	EntityId *string `min:"8" type:"string" required:"true"`

	// The metadata of the SAML application, in XML format.
	//
	// MetadataContent is a required field
	MetadataContent *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLIdp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLIdp) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SAMLIdp) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SAMLIdp"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 8))
	}
	if s.MetadataContent == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataContent"))
	}
	if s.MetadataContent != nil && len(*s.MetadataContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetadataContent", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *SAMLIdp) SetEntityId(v string) *SAMLIdp {
	s.EntityId = &v
	return s
}

// SetMetadataContent sets the MetadataContent field's value.
func (s *SAMLIdp) SetMetadataContent(v string) *SAMLIdp {
	s.MetadataContent = &v
	return s
}

// The SAML authentication configuration for an Amazon OpenSearch Service domain.
type SAMLOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// True to enable SAML authentication for a domain.
	Enabled *bool `type:"boolean"`

	// The SAML Identity Provider's information.
	Idp *SAMLIdp `type:"structure"`

	// The backend role that the SAML master user is mapped to.
	MasterBackendRole *string `min:"1" type:"string"`

	// The SAML master user name, which is stored in the domain's internal user
	// database.
	//
	// MasterUserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SAMLOptionsInput_'s
	// String and GoString methods.
	MasterUserName *string `min:"1" type:"string" sensitive:"true"`

	// Element of the SAML assertion to use for backend roles. Default is roles.
	RolesKey *string `type:"string"`

	// The duration, in minutes, after which a user session becomes inactive. Acceptable
	// values are between 1 and 1440, and the default value is 60.
	SessionTimeoutMinutes *int64 `type:"integer"`

	// Element of the SAML assertion to use for the user name. Default is NameID.
	SubjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SAMLOptionsInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SAMLOptionsInput_"}
	if s.MasterBackendRole != nil && len(*s.MasterBackendRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterBackendRole", 1))
	}
	if s.MasterUserName != nil && len(*s.MasterUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserName", 1))
	}
	if s.Idp != nil {
		if err := s.Idp.Validate(); err != nil {
			invalidParams.AddNested("Idp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *SAMLOptionsInput_) SetEnabled(v bool) *SAMLOptionsInput_ {
	s.Enabled = &v
	return s
}

// SetIdp sets the Idp field's value.
func (s *SAMLOptionsInput_) SetIdp(v *SAMLIdp) *SAMLOptionsInput_ {
	s.Idp = v
	return s
}

// SetMasterBackendRole sets the MasterBackendRole field's value.
func (s *SAMLOptionsInput_) SetMasterBackendRole(v string) *SAMLOptionsInput_ {
	s.MasterBackendRole = &v
	return s
}

// SetMasterUserName sets the MasterUserName field's value.
func (s *SAMLOptionsInput_) SetMasterUserName(v string) *SAMLOptionsInput_ {
	s.MasterUserName = &v
	return s
}

// SetRolesKey sets the RolesKey field's value.
func (s *SAMLOptionsInput_) SetRolesKey(v string) *SAMLOptionsInput_ {
	s.RolesKey = &v
	return s
}

// SetSessionTimeoutMinutes sets the SessionTimeoutMinutes field's value.
func (s *SAMLOptionsInput_) SetSessionTimeoutMinutes(v int64) *SAMLOptionsInput_ {
	s.SessionTimeoutMinutes = &v
	return s
}

// SetSubjectKey sets the SubjectKey field's value.
func (s *SAMLOptionsInput_) SetSubjectKey(v string) *SAMLOptionsInput_ {
	s.SubjectKey = &v
	return s
}

// Describes the SAML application configured for the domain.
type SAMLOptionsOutput_ struct {
	_ struct{} `type:"structure"`

	// True if SAML is enabled.
	Enabled *bool `type:"boolean"`

	// Describes the SAML identity provider's information.
	Idp *SAMLIdp `type:"structure"`

	// The key used for matching the SAML roles attribute.
	RolesKey *string `type:"string"`

	// The duration, in minutes, after which a user session becomes inactive.
	SessionTimeoutMinutes *int64 `type:"integer"`

	// The key used for matching the SAML subject attribute.
	SubjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsOutput_) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SAMLOptionsOutput_) SetEnabled(v bool) *SAMLOptionsOutput_ {
	s.Enabled = &v
	return s
}

// SetIdp sets the Idp field's value.
func (s *SAMLOptionsOutput_) SetIdp(v *SAMLIdp) *SAMLOptionsOutput_ {
	s.Idp = v
	return s
}

// SetRolesKey sets the RolesKey field's value.
func (s *SAMLOptionsOutput_) SetRolesKey(v string) *SAMLOptionsOutput_ {
	s.RolesKey = &v
	return s
}

// SetSessionTimeoutMinutes sets the SessionTimeoutMinutes field's value.
func (s *SAMLOptionsOutput_) SetSessionTimeoutMinutes(v int64) *SAMLOptionsOutput_ {
	s.SessionTimeoutMinutes = &v
	return s
}

// SetSubjectKey sets the SubjectKey field's value.
func (s *SAMLOptionsOutput_) SetSubjectKey(v string) *SAMLOptionsOutput_ {
	s.SubjectKey = &v
	return s
}

// Information about a scheduled configuration change for an OpenSearch Service
// domain. This actions can be a service software update (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html)
// or a blue/green Auto-Tune enhancement (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
type ScheduledAction struct {
	_ struct{} `type:"structure"`

	// Whether or not the scheduled action is cancellable.
	Cancellable *bool `type:"boolean"`

	// A description of the action to be taken.
	Description *string `type:"string"`

	// The unique identifier of the scheduled action.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Whether the action is required or optional.
	Mandatory *bool `type:"boolean"`

	// Whether the action was scheduled manually (CUSTOMER, or by OpenSearch Service
	// automatically (SYSTEM).
	ScheduledBy *string `type:"string" enum:"ScheduledBy"`

	// The time when the change is scheduled to happen.
	//
	// ScheduledTime is a required field
	ScheduledTime *int64 `type:"long" required:"true"`

	// The severity of the action.
	//
	// Severity is a required field
	Severity *string `type:"string" required:"true" enum:"ActionSeverity"`

	// The current status of the scheduled action.
	Status *string `type:"string" enum:"ActionStatus"`

	// The type of action that will be taken on the domain.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAction) GoString() string {
	return s.String()
}

// SetCancellable sets the Cancellable field's value.
func (s *ScheduledAction) SetCancellable(v bool) *ScheduledAction {
	s.Cancellable = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ScheduledAction) SetDescription(v string) *ScheduledAction {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ScheduledAction) SetId(v string) *ScheduledAction {
	s.Id = &v
	return s
}

// SetMandatory sets the Mandatory field's value.
func (s *ScheduledAction) SetMandatory(v bool) *ScheduledAction {
	s.Mandatory = &v
	return s
}

// SetScheduledBy sets the ScheduledBy field's value.
func (s *ScheduledAction) SetScheduledBy(v string) *ScheduledAction {
	s.ScheduledBy = &v
	return s
}

// SetScheduledTime sets the ScheduledTime field's value.
func (s *ScheduledAction) SetScheduledTime(v int64) *ScheduledAction {
	s.ScheduledTime = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ScheduledAction) SetSeverity(v string) *ScheduledAction {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ScheduledAction) SetStatus(v string) *ScheduledAction {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *ScheduledAction) SetType(v string) *ScheduledAction {
	s.Type = &v
	return s
}

// Specifies details about a scheduled Auto-Tune action. For more information,
// see Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
type ScheduledAutoTuneDetails struct {
	_ struct{} `type:"structure"`

	// A description of the Auto-Tune action.
	Action *string `type:"string"`

	// The type of Auto-Tune action.
	ActionType *string `type:"string" enum:"ScheduledAutoTuneActionType"`

	// The date and time when the Auto-Tune action is scheduled for the domain.
	Date *time.Time `type:"timestamp"`

	// The severity of the Auto-Tune action. Valid values are LOW, MEDIUM, and HIGH.
	Severity *string `type:"string" enum:"ScheduledAutoTuneSeverityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAutoTuneDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAutoTuneDetails) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ScheduledAutoTuneDetails) SetAction(v string) *ScheduledAutoTuneDetails {
	s.Action = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ScheduledAutoTuneDetails) SetActionType(v string) *ScheduledAutoTuneDetails {
	s.ActionType = &v
	return s
}

// SetDate sets the Date field's value.
func (s *ScheduledAutoTuneDetails) SetDate(v time.Time) *ScheduledAutoTuneDetails {
	s.Date = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ScheduledAutoTuneDetails) SetSeverity(v string) *ScheduledAutoTuneDetails {
	s.Severity = &v
	return s
}

// The current status of the service software for an Amazon OpenSearch Service
// domain. For more information, see Service software updates in Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
type ServiceSoftwareOptions struct {
	_ struct{} `type:"structure"`

	// The timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time `type:"timestamp"`

	// True if you're able to cancel your service software version update. False
	// if you can't cancel your service software update.
	Cancellable *bool `type:"boolean"`

	// The current service software version present on the domain.
	CurrentVersion *string `type:"string"`

	// A description of the service software update status.
	Description *string `type:"string"`

	// The new service software version, if one is available.
	NewVersion *string `type:"string"`

	// True if a service software is never automatically updated. False if a service
	// software is automatically updated after the automated update date.
	OptionalDeployment *bool `type:"boolean"`

	// True if you're able to update your service software version. False if you
	// can't update your service software version.
	UpdateAvailable *bool `type:"boolean"`

	// The status of your service software update.
	UpdateStatus *string `type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSoftwareOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSoftwareOptions) GoString() string {
	return s.String()
}

// SetAutomatedUpdateDate sets the AutomatedUpdateDate field's value.
func (s *ServiceSoftwareOptions) SetAutomatedUpdateDate(v time.Time) *ServiceSoftwareOptions {
	s.AutomatedUpdateDate = &v
	return s
}

// SetCancellable sets the Cancellable field's value.
func (s *ServiceSoftwareOptions) SetCancellable(v bool) *ServiceSoftwareOptions {
	s.Cancellable = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ServiceSoftwareOptions) SetCurrentVersion(v string) *ServiceSoftwareOptions {
	s.CurrentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSoftwareOptions) SetDescription(v string) *ServiceSoftwareOptions {
	s.Description = &v
	return s
}

// SetNewVersion sets the NewVersion field's value.
func (s *ServiceSoftwareOptions) SetNewVersion(v string) *ServiceSoftwareOptions {
	s.NewVersion = &v
	return s
}

// SetOptionalDeployment sets the OptionalDeployment field's value.
func (s *ServiceSoftwareOptions) SetOptionalDeployment(v bool) *ServiceSoftwareOptions {
	s.OptionalDeployment = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *ServiceSoftwareOptions) SetUpdateAvailable(v bool) *ServiceSoftwareOptions {
	s.UpdateAvailable = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ServiceSoftwareOptions) SetUpdateStatus(v string) *ServiceSoftwareOptions {
	s.UpdateStatus = &v
	return s
}

// An exception for attempting to schedule a domain action during an unavailable
// time slot.
type SlotNotAvailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Alternate time slots during which OpenSearch Service has available capacity
	// to schedule a domain action.
	SlotSuggestions []*int64 `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlotNotAvailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlotNotAvailableException) GoString() string {
	return s.String()
}

func newErrorSlotNotAvailableException(v protocol.ResponseMetadata) error {
	return &SlotNotAvailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SlotNotAvailableException) Code() string {
	return "SlotNotAvailableException"
}

// Message returns the exception's message.
func (s *SlotNotAvailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SlotNotAvailableException) OrigErr() error {
	return nil
}

func (s *SlotNotAvailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SlotNotAvailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SlotNotAvailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The time, in UTC format, when OpenSearch Service takes a daily automated
// snapshot of the specified domain. Default is 0 hours.
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// The time, in UTC format, when OpenSearch Service takes a daily automated
	// snapshot of the specified domain. Default is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptions) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotStartHour sets the AutomatedSnapshotStartHour field's value.
func (s *SnapshotOptions) SetAutomatedSnapshotStartHour(v int64) *SnapshotOptions {
	s.AutomatedSnapshotStartHour = &v
	return s
}

// Container for information about a daily automated snapshot for an OpenSearch
// Service domain.
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The daily snapshot options specified for the domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// The status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SnapshotOptionsStatus) SetOptions(v *SnapshotOptions) *SnapshotOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SnapshotOptionsStatus) SetStatus(v *OptionStatus) *SnapshotOptionsStatus {
	s.Status = v
	return s
}

// Options for configuring service software updates for a domain.
type SoftwareUpdateOptions struct {
	_ struct{} `type:"structure"`

	// Whether automatic service software updates are enabled for the domain.
	AutoSoftwareUpdateEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareUpdateOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareUpdateOptions) GoString() string {
	return s.String()
}

// SetAutoSoftwareUpdateEnabled sets the AutoSoftwareUpdateEnabled field's value.
func (s *SoftwareUpdateOptions) SetAutoSoftwareUpdateEnabled(v bool) *SoftwareUpdateOptions {
	s.AutoSoftwareUpdateEnabled = &v
	return s
}

// The status of the service software options for a domain.
type SoftwareUpdateOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The service software update options for a domain.
	Options *SoftwareUpdateOptions `type:"structure"`

	// The status of service software update options, including creation date and
	// last updated date.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareUpdateOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SoftwareUpdateOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SoftwareUpdateOptionsStatus) SetOptions(v *SoftwareUpdateOptions) *SoftwareUpdateOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SoftwareUpdateOptionsStatus) SetStatus(v *OptionStatus) *SoftwareUpdateOptionsStatus {
	s.Status = v
	return s
}

// Container for the parameters to the StartDomainMaintenance operation.
type StartDomainMaintenanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the action.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"MaintenanceType"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The ID of the data node.
	NodeId *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDomainMaintenanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDomainMaintenanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDomainMaintenanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDomainMaintenanceInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.NodeId != nil && len(*s.NodeId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("NodeId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *StartDomainMaintenanceInput) SetAction(v string) *StartDomainMaintenanceInput {
	s.Action = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *StartDomainMaintenanceInput) SetDomainName(v string) *StartDomainMaintenanceInput {
	s.DomainName = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *StartDomainMaintenanceInput) SetNodeId(v string) *StartDomainMaintenanceInput {
	s.NodeId = &v
	return s
}

// The result of a StartDomainMaintenance request that information about the
// requested action.
type StartDomainMaintenanceOutput struct {
	_ struct{} `type:"structure"`

	// The request ID of requested action.
	MaintenanceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDomainMaintenanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDomainMaintenanceOutput) GoString() string {
	return s.String()
}

// SetMaintenanceId sets the MaintenanceId field's value.
func (s *StartDomainMaintenanceOutput) SetMaintenanceId(v string) *StartDomainMaintenanceOutput {
	s.MaintenanceId = &v
	return s
}

// Container for the request parameters to the StartServiceSoftwareUpdate operation.
type StartServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The Epoch timestamp when you want the service software update to start. You
	// only need to specify this parameter if you set ScheduleAt to TIMESTAMP.
	DesiredStartTime *int64 `type:"long"`

	// The name of the domain that you want to update to the latest service software.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// When to start the service software update.
	//
	//    * NOW - Immediately schedules the update to happen in the current hour
	//    if there's capacity available.
	//
	//    * TIMESTAMP - Lets you specify a custom date and time to apply the update.
	//    If you specify this value, you must also provide a value for DesiredStartTime.
	//
	//    * OFF_PEAK_WINDOW - Marks the update to be picked up during an upcoming
	//    off-peak window. There's no guarantee that the update will happen during
	//    the next immediate window. Depending on capacity, it might happen in subsequent
	//    days.
	//
	// Default: NOW if you don't specify a value for DesiredStartTime, and TIMESTAMP
	// if you do.
	ScheduleAt *string `type:"string" enum:"ScheduleAt"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredStartTime sets the DesiredStartTime field's value.
func (s *StartServiceSoftwareUpdateInput) SetDesiredStartTime(v int64) *StartServiceSoftwareUpdateInput {
	s.DesiredStartTime = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *StartServiceSoftwareUpdateInput) SetDomainName(v string) *StartServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// SetScheduleAt sets the ScheduleAt field's value.
func (s *StartServiceSoftwareUpdateInput) SetScheduleAt(v string) *StartServiceSoftwareUpdateInput {
	s.ScheduleAt = &v
	return s
}

// Represents the output of a StartServiceSoftwareUpdate operation. Contains
// the status of the update.
type StartServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the OpenSearch Service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *StartServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *StartServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// A list of storage types for an Amazon OpenSearch Service domain that are
// available for a given intance type.
type StorageType struct {
	_ struct{} `type:"structure"`

	// The storage sub-type, such as gp3 or io1.
	StorageSubTypeName *string `type:"string"`

	// Limits that are applicable for the given storage type.
	StorageTypeLimits []*StorageTypeLimit `type:"list"`

	// The name of the storage type.
	StorageTypeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageType) GoString() string {
	return s.String()
}

// SetStorageSubTypeName sets the StorageSubTypeName field's value.
func (s *StorageType) SetStorageSubTypeName(v string) *StorageType {
	s.StorageSubTypeName = &v
	return s
}

// SetStorageTypeLimits sets the StorageTypeLimits field's value.
func (s *StorageType) SetStorageTypeLimits(v []*StorageTypeLimit) *StorageType {
	s.StorageTypeLimits = v
	return s
}

// SetStorageTypeName sets the StorageTypeName field's value.
func (s *StorageType) SetStorageTypeName(v string) *StorageType {
	s.StorageTypeName = &v
	return s
}

// Limits that are applicable for the given Amazon OpenSearch Service storage
// type.
type StorageTypeLimit struct {
	_ struct{} `type:"structure"`

	// Name of storage limits that are applicable for the given storage type. If
	// StorageType is ebs, the following options are available:
	//
	//    * MinimumVolumeSize - Minimum volume size that is available for the given
	//    storage type. Can be empty if not applicable.
	//
	//    * MaximumVolumeSize - Maximum volume size that is available for the given
	//    storage type. Can be empty if not applicable.
	//
	//    * MaximumIops - Maximum amount of IOPS that is available for the given
	//    the storage type. Can be empty if not applicable.
	//
	//    * MinimumIops - Minimum amount of IOPS that is available for the given
	//    the storage type. Can be empty if not applicable.
	//
	//    * MaximumThroughput - Maximum amount of throughput that is available for
	//    the given the storage type. Can be empty if not applicable.
	//
	//    * MinimumThroughput - Minimum amount of throughput that is available for
	//    the given the storage type. Can be empty if not applicable.
	LimitName *string `type:"string"`

	// The limit values.
	LimitValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageTypeLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageTypeLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *StorageTypeLimit) SetLimitName(v string) *StorageTypeLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *StorageTypeLimit) SetLimitValues(v []*string) *StorageTypeLimit {
	s.LimitValues = v
	return s
}

// A tag (key-value pair) for an Amazon OpenSearch Service resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key. Tag keys must be unique for the domain to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value assigned to the corresponding tag key. Tag values can be null and
	// don't have to be unique in a tag set. For example, you can have a key value
	// pair in a tag set of project : Trinity and cost-center : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the UpdateDataSource operation.
type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The type of data source.
	//
	// DataSourceType is a required field
	DataSourceType *DataSourceType `type:"structure" required:"true"`

	// A new description of the data source.
	Description *string `type:"string"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The name of the data source to modify.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"DataSourceName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.DataSourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceType"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.DataSourceType != nil {
		if err := s.DataSourceType.Validate(); err != nil {
			invalidParams.AddNested("DataSourceType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceType sets the DataSourceType field's value.
func (s *UpdateDataSourceInput) SetDataSourceType(v *DataSourceType) *UpdateDataSourceInput {
	s.DataSourceType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDataSourceInput) SetDomainName(v string) *UpdateDataSourceInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// The result of an UpdateDataSource operation.
type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A message associated with the updated data source.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UpdateDataSourceOutput) SetMessage(v string) *UpdateDataSourceOutput {
	s.Message = &v
	return s
}

// Container for the request parameters to the UpdateDomain operation.
type UpdateDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// Identity and Access Management (IAM) access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Key-value pairs to specify advanced configuration options. The following
	// key-value pairs are supported:
	//
	//    * "rest.action.multi.allow_explicit_index": "true" | "false" - Note the
	//    use of a string rather than a boolean. Specifies whether explicit references
	//    to indexes are allowed inside the body of HTTP requests. If you want to
	//    configure access policies for domain sub-resources, such as specific indexes
	//    and domain APIs, you must disable this property. Default is true.
	//
	//    * "indices.fielddata.cache.size": "80" - Note the use of a string rather
	//    than a boolean. Specifies the percentage of heap space allocated to field
	//    data. Default is unbounded.
	//
	//    * "indices.query.bool.max_clause_count": "1024" - Note the use of a string
	//    rather than a boolean. Specifies the maximum number of clauses allowed
	//    in a Lucene boolean query. Default is 1,024. Queries with more than the
	//    permitted number of clauses result in a TooManyClauses error.
	//
	// For more information, see Advanced cluster parameters (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions map[string]*string `type:"map"`

	// Options for fine-grained access control.
	AdvancedSecurityOptions *AdvancedSecurityOptionsInput_ `type:"structure"`

	// Options for Auto-Tune.
	AutoTuneOptions *AutoTuneOptions `type:"structure"`

	// Changes that you want to make to the cluster configuration, such as the instance
	// type and number of EC2 instances.
	ClusterConfig *ClusterConfig `type:"structure"`

	// Key-value pairs to configure Amazon Cognito authentication for OpenSearch
	// Dashboards.
	CognitoOptions *CognitoOptions `type:"structure"`

	// Additional options for the domain endpoint, such as whether to require HTTPS
	// for all traffic.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The name of the domain that you're updating.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// This flag, when set to True, specifies whether the UpdateDomain request should
	// return the results of a dry run analysis without actually applying the change.
	// A dry run determines what type of deployment the update will cause.
	DryRun *bool `type:"boolean"`

	// The type of dry run to perform.
	//
	//    * Basic only returns the type of deployment (blue/green or dynamic) that
	//    the update will cause.
	//
	//    * Verbose runs an additional check to validate the changes you're making.
	//    For more information, see Validating a domain update (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#validation-check).
	DryRunMode *string `type:"string" enum:"DryRunMode"`

	// The type and size of the EBS volume to attach to instances in the domain.
	EBSOptions *EBSOptions `type:"structure"`

	// Encryption at rest options for the domain.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// The type of IP addresses supported by the endpoint for the domain.
	IPAddressType *string `type:"string" enum:"IPAddressType"`

	// Options to publish OpenSearch logs to Amazon CloudWatch Logs.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Node-to-node encryption options for the domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Off-peak window options for the domain.
	OffPeakWindowOptions *OffPeakWindowOptions `type:"structure"`

	// Option to set the time, in UTC format, for the daily automated snapshot.
	// Default value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Service software update options for the domain.
	SoftwareUpdateOptions *SoftwareUpdateOptions `type:"structure"`

	// Options to specify the subnets and security groups for a VPC endpoint. For
	// more information, see Launching your Amazon OpenSearch Service domains using
	// a VPC (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.AdvancedSecurityOptions != nil {
		if err := s.AdvancedSecurityOptions.Validate(); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoTuneOptions != nil {
		if err := s.AutoTuneOptions.Validate(); err != nil {
			invalidParams.AddNested("AutoTuneOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ClusterConfig != nil {
		if err := s.ClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DomainEndpointOptions != nil {
		if err := s.DomainEndpointOptions.Validate(); err != nil {
			invalidParams.AddNested("DomainEndpointOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LogPublishingOptions != nil {
		for i, v := range s.LogPublishingOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogPublishingOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OffPeakWindowOptions != nil {
		if err := s.OffPeakWindowOptions.Validate(); err != nil {
			invalidParams.AddNested("OffPeakWindowOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *UpdateDomainConfigInput) SetAccessPolicies(v string) *UpdateDomainConfigInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpdateDomainConfigInput) SetAdvancedOptions(v map[string]*string) *UpdateDomainConfigInput {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *UpdateDomainConfigInput) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsInput_) *UpdateDomainConfigInput {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *UpdateDomainConfigInput) SetAutoTuneOptions(v *AutoTuneOptions) *UpdateDomainConfigInput {
	s.AutoTuneOptions = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *UpdateDomainConfigInput) SetClusterConfig(v *ClusterConfig) *UpdateDomainConfigInput {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *UpdateDomainConfigInput) SetCognitoOptions(v *CognitoOptions) *UpdateDomainConfigInput {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *UpdateDomainConfigInput) SetDomainEndpointOptions(v *DomainEndpointOptions) *UpdateDomainConfigInput {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainConfigInput) SetDomainName(v string) *UpdateDomainConfigInput {
	s.DomainName = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateDomainConfigInput) SetDryRun(v bool) *UpdateDomainConfigInput {
	s.DryRun = &v
	return s
}

// SetDryRunMode sets the DryRunMode field's value.
func (s *UpdateDomainConfigInput) SetDryRunMode(v string) *UpdateDomainConfigInput {
	s.DryRunMode = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *UpdateDomainConfigInput) SetEBSOptions(v *EBSOptions) *UpdateDomainConfigInput {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *UpdateDomainConfigInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *UpdateDomainConfigInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetIPAddressType sets the IPAddressType field's value.
func (s *UpdateDomainConfigInput) SetIPAddressType(v string) *UpdateDomainConfigInput {
	s.IPAddressType = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *UpdateDomainConfigInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *UpdateDomainConfigInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *UpdateDomainConfigInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *UpdateDomainConfigInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetOffPeakWindowOptions sets the OffPeakWindowOptions field's value.
func (s *UpdateDomainConfigInput) SetOffPeakWindowOptions(v *OffPeakWindowOptions) *UpdateDomainConfigInput {
	s.OffPeakWindowOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *UpdateDomainConfigInput) SetSnapshotOptions(v *SnapshotOptions) *UpdateDomainConfigInput {
	s.SnapshotOptions = v
	return s
}

// SetSoftwareUpdateOptions sets the SoftwareUpdateOptions field's value.
func (s *UpdateDomainConfigInput) SetSoftwareUpdateOptions(v *SoftwareUpdateOptions) *UpdateDomainConfigInput {
	s.SoftwareUpdateOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *UpdateDomainConfigInput) SetVPCOptions(v *VPCOptions) *UpdateDomainConfigInput {
	s.VPCOptions = v
	return s
}

// The results of an UpdateDomain request. Contains the status of the domain
// being updated.
type UpdateDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The status of the updated domain.
	//
	// DomainConfig is a required field
	DomainConfig *DomainConfig `type:"structure" required:"true"`

	// The status of the dry run being performed on the domain, if any.
	DryRunProgressStatus *DryRunProgressStatus `type:"structure"`

	// Results of the dry run performed in the update domain request.
	DryRunResults *DryRunResults `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *UpdateDomainConfigOutput) SetDomainConfig(v *DomainConfig) *UpdateDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// SetDryRunProgressStatus sets the DryRunProgressStatus field's value.
func (s *UpdateDomainConfigOutput) SetDryRunProgressStatus(v *DryRunProgressStatus) *UpdateDomainConfigOutput {
	s.DryRunProgressStatus = v
	return s
}

// SetDryRunResults sets the DryRunResults field's value.
func (s *UpdateDomainConfigOutput) SetDryRunResults(v *DryRunResults) *UpdateDomainConfigOutput {
	s.DryRunResults = v
	return s
}

// Container for request parameters to the UpdatePackage operation.
type UpdatePackageInput struct {
	_ struct{} `type:"structure"`

	// Commit message for the updated file, which is shown as part of GetPackageVersionHistoryResponse.
	CommitMessage *string `type:"string"`

	// A new description of the package.
	PackageDescription *string `type:"string"`

	// The unique identifier for the package.
	//
	// PackageID is a required field
	PackageID *string `type:"string" required:"true"`

	// Amazon S3 bucket and key for the package.
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageSource"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *UpdatePackageInput) SetCommitMessage(v string) *UpdatePackageInput {
	s.CommitMessage = &v
	return s
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *UpdatePackageInput) SetPackageDescription(v string) *UpdatePackageInput {
	s.PackageDescription = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *UpdatePackageInput) SetPackageID(v string) *UpdatePackageInput {
	s.PackageID = &v
	return s
}

// SetPackageSource sets the PackageSource field's value.
func (s *UpdatePackageInput) SetPackageSource(v *PackageSource) *UpdatePackageInput {
	s.PackageSource = v
	return s
}

// Container for the response returned by the UpdatePackage operation.
type UpdatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about a package.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *UpdatePackageOutput) SetPackageDetails(v *PackageDetails) *UpdatePackageOutput {
	s.PackageDetails = v
	return s
}

type UpdateScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the action to reschedule. To retrieve this ID, send
	// a ListScheduledActions (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html)
	// request.
	//
	// ActionID is a required field
	ActionID *string `type:"string" required:"true"`

	// The type of action to reschedule. Can be one of SERVICE_SOFTWARE_UPDATE,
	// JVM_HEAP_SIZE_TUNING, or JVM_YOUNG_GEN_TUNING. To retrieve this value, send
	// a ListScheduledActions (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html)
	// request.
	//
	// ActionType is a required field
	ActionType *string `type:"string" required:"true" enum:"ActionType"`

	// The time to implement the change, in Coordinated Universal Time (UTC). Only
	// specify this parameter if you set ScheduleAt to TIMESTAMP.
	DesiredStartTime *int64 `type:"long"`

	// The name of the domain to reschedule an action for.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// When to schedule the action.
	//
	//    * NOW - Immediately schedules the update to happen in the current hour
	//    if there's capacity available.
	//
	//    * TIMESTAMP - Lets you specify a custom date and time to apply the update.
	//    If you specify this value, you must also provide a value for DesiredStartTime.
	//
	//    * OFF_PEAK_WINDOW - Marks the action to be picked up during an upcoming
	//    off-peak window. There's no guarantee that the change will be implemented
	//    during the next immediate window. Depending on capacity, it might happen
	//    in subsequent days.
	//
	// ScheduleAt is a required field
	ScheduleAt *string `type:"string" required:"true" enum:"ScheduleAt"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScheduledActionInput"}
	if s.ActionID == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionID"))
	}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ScheduleAt == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleAt"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionID sets the ActionID field's value.
func (s *UpdateScheduledActionInput) SetActionID(v string) *UpdateScheduledActionInput {
	s.ActionID = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *UpdateScheduledActionInput) SetActionType(v string) *UpdateScheduledActionInput {
	s.ActionType = &v
	return s
}

// SetDesiredStartTime sets the DesiredStartTime field's value.
func (s *UpdateScheduledActionInput) SetDesiredStartTime(v int64) *UpdateScheduledActionInput {
	s.DesiredStartTime = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateScheduledActionInput) SetDomainName(v string) *UpdateScheduledActionInput {
	s.DomainName = &v
	return s
}

// SetScheduleAt sets the ScheduleAt field's value.
func (s *UpdateScheduledActionInput) SetScheduleAt(v string) *UpdateScheduledActionInput {
	s.ScheduleAt = &v
	return s
}

type UpdateScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rescheduled action.
	ScheduledAction *ScheduledAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionOutput) GoString() string {
	return s.String()
}

// SetScheduledAction sets the ScheduledAction field's value.
func (s *UpdateScheduledActionOutput) SetScheduledAction(v *ScheduledAction) *UpdateScheduledActionOutput {
	s.ScheduledAction = v
	return s
}

type UpdateVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the endpoint.
	//
	// VpcEndpointId is a required field
	VpcEndpointId *string `min:"5" type:"string" required:"true"`

	// The security groups and/or subnets to add, remove, or modify.
	//
	// VpcOptions is a required field
	VpcOptions *VPCOptions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVpcEndpointInput"}
	if s.VpcEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcEndpointId"))
	}
	if s.VpcEndpointId != nil && len(*s.VpcEndpointId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("VpcEndpointId", 5))
	}
	if s.VpcOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *UpdateVpcEndpointInput) SetVpcEndpointId(v string) *UpdateVpcEndpointInput {
	s.VpcEndpointId = &v
	return s
}

// SetVpcOptions sets the VpcOptions field's value.
func (s *UpdateVpcEndpointInput) SetVpcOptions(v *VPCOptions) *UpdateVpcEndpointInput {
	s.VpcOptions = v
	return s
}

type UpdateVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint to be updated.
	//
	// VpcEndpoint is a required field
	VpcEndpoint *VpcEndpoint `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetVpcEndpoint sets the VpcEndpoint field's value.
func (s *UpdateVpcEndpointOutput) SetVpcEndpoint(v *VpcEndpoint) *UpdateVpcEndpointOutput {
	s.VpcEndpoint = v
	return s
}

// Container for the request parameters to the UpgradeDomain operation.
type UpgradeDomainInput struct {
	_ struct{} `type:"structure"`

	// Only supports the override_main_response_version parameter and not other
	// advanced options. You can only include this option when upgrading to an OpenSearch
	// version. Specifies whether the domain reports its version as 7.10 so that
	// it continues to work with Elasticsearch OSS clients and plugins.
	AdvancedOptions map[string]*string `type:"map"`

	// Name of the OpenSearch Service domain that you want to upgrade.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// When true, indicates that an upgrade eligibility check needs to be performed.
	// Does not actually perform the upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// OpenSearch or Elasticsearch version to which you want to upgrade, in the
	// format Opensearch_X.Y or Elasticsearch_X.Y.
	//
	// TargetVersion is a required field
	TargetVersion *string `min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.TargetVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetVersion"))
	}
	if s.TargetVersion != nil && len(*s.TargetVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("TargetVersion", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpgradeDomainInput) SetAdvancedOptions(v map[string]*string) *UpgradeDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeDomainInput) SetDomainName(v string) *UpgradeDomainInput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeDomainInput) SetPerformCheckOnly(v bool) *UpgradeDomainInput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeDomainInput) SetTargetVersion(v string) *UpgradeDomainInput {
	s.TargetVersion = &v
	return s
}

// Container for the response returned by UpgradeDomain operation.
type UpgradeDomainOutput struct {
	_ struct{} `type:"structure"`

	// The advanced options configuration for the domain.
	AdvancedOptions map[string]*string `type:"map"`

	// Container for information about a configuration change happening on a domain.
	ChangeProgressDetails *ChangeProgressDetails `type:"structure"`

	// The name of the domain that was upgraded.
	DomainName *string `min:"3" type:"string"`

	// When true, indicates that an upgrade eligibility check was performed.
	PerformCheckOnly *bool `type:"boolean"`

	// OpenSearch or Elasticsearch version that the domain was upgraded to.
	TargetVersion *string `min:"14" type:"string"`

	// The unique identifier of the domain upgrade.
	UpgradeId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainOutput) GoString() string {
	return s.String()
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpgradeDomainOutput) SetAdvancedOptions(v map[string]*string) *UpgradeDomainOutput {
	s.AdvancedOptions = v
	return s
}

// SetChangeProgressDetails sets the ChangeProgressDetails field's value.
func (s *UpgradeDomainOutput) SetChangeProgressDetails(v *ChangeProgressDetails) *UpgradeDomainOutput {
	s.ChangeProgressDetails = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeDomainOutput) SetDomainName(v string) *UpgradeDomainOutput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeDomainOutput) SetPerformCheckOnly(v bool) *UpgradeDomainOutput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeDomainOutput) SetTargetVersion(v string) *UpgradeDomainOutput {
	s.TargetVersion = &v
	return s
}

// SetUpgradeId sets the UpgradeId field's value.
func (s *UpgradeDomainOutput) SetUpgradeId(v string) *UpgradeDomainOutput {
	s.UpgradeId = &v
	return s
}

// History of the last 10 upgrades and upgrade eligibility checks for an Amazon
// OpenSearch Service domain.
type UpgradeHistory struct {
	_ struct{} `type:"structure"`

	// UTC timestamp at which the upgrade API call was made, in the format yyyy-MM-ddTHH:mm:ssZ.
	StartTimestamp *time.Time `type:"timestamp"`

	// A list of each step performed as part of a specific upgrade or upgrade eligibility
	// check.
	StepsList []*UpgradeStepItem `type:"list"`

	// A string that describes the upgrade.
	UpgradeName *string `type:"string"`

	// The current status of the upgrade. The status can take one of the following
	// values:
	//
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeHistory) GoString() string {
	return s.String()
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *UpgradeHistory) SetStartTimestamp(v time.Time) *UpgradeHistory {
	s.StartTimestamp = &v
	return s
}

// SetStepsList sets the StepsList field's value.
func (s *UpgradeHistory) SetStepsList(v []*UpgradeStepItem) *UpgradeHistory {
	s.StepsList = v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *UpgradeHistory) SetUpgradeName(v string) *UpgradeHistory {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStatus sets the UpgradeStatus field's value.
func (s *UpgradeHistory) SetUpgradeStatus(v string) *UpgradeHistory {
	s.UpgradeStatus = &v
	return s
}

// Represents a single step of an upgrade or upgrade eligibility check workflow.
type UpgradeStepItem struct {
	_ struct{} `type:"structure"`

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []*string `type:"list"`

	// The floating point value representing the progress percentage of a particular
	// step.
	ProgressPercent *float64 `type:"double"`

	// One of three steps that an upgrade or upgrade eligibility check goes through:
	//
	//    * PreUpgradeCheck
	//
	//    * Snapshot
	//
	//    * Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`

	// The current status of the upgrade. The status can take one of the following
	// values:
	//
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStepStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeStepItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeStepItem) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *UpgradeStepItem) SetIssues(v []*string) *UpgradeStepItem {
	s.Issues = v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *UpgradeStepItem) SetProgressPercent(v float64) *UpgradeStepItem {
	s.ProgressPercent = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *UpgradeStepItem) SetUpgradeStep(v string) *UpgradeStepItem {
	s.UpgradeStep = &v
	return s
}

// SetUpgradeStepStatus sets the UpgradeStepStatus field's value.
func (s *UpgradeStepItem) SetUpgradeStepStatus(v string) *UpgradeStepItem {
	s.UpgradeStepStatus = &v
	return s
}

// Information about the subnets and security groups for an Amazon OpenSearch
// Service domain provisioned within a virtual private cloud (VPC). For more
// information, see Launching your Amazon OpenSearch Service domains using a
// VPC (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
// This information only exists if the domain was created with VPCOptions.
type VPCDerivedInfo struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []*string `type:"list"`

	// The list of security group IDs associated with the VPC endpoints for the
	// domain.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []*string `type:"list"`

	// The ID for your VPC. Amazon VPC generates this value when you create a VPC.
	VPCId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfo) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *VPCDerivedInfo) SetAvailabilityZones(v []*string) *VPCDerivedInfo {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCDerivedInfo) SetSecurityGroupIds(v []*string) *VPCDerivedInfo {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCDerivedInfo) SetSubnetIds(v []*string) *VPCDerivedInfo {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *VPCDerivedInfo) SetVPCId(v string) *VPCDerivedInfo {
	s.VPCId = &v
	return s
}

// Status of the VPC options for a specified domain.
type VPCDerivedInfoStatus struct {
	_ struct{} `type:"structure"`

	// The VPC options for the specified domain.
	//
	// Options is a required field
	Options *VPCDerivedInfo `type:"structure" required:"true"`

	// The status of the VPC options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfoStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfoStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *VPCDerivedInfoStatus) SetOptions(v *VPCDerivedInfo) *VPCDerivedInfoStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VPCDerivedInfoStatus) SetStatus(v *OptionStatus) *VPCDerivedInfoStatus {
	s.Status = v
	return s
}

// Options to specify the subnets and security groups for an Amazon OpenSearch
// Service VPC endpoint. For more information, see Launching your Amazon OpenSearch
// Service domains using a VPC (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
type VPCOptions struct {
	_ struct{} `type:"structure"`

	// The list of security group IDs associated with the VPC endpoints for the
	// domain. If you do not provide a security group ID, OpenSearch Service uses
	// the default security group for the VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the VPC endpoints for the domain. If
	// your domain uses multiple Availability Zones, you need to provide two subnet
	// IDs, one per zone. Otherwise, provide only one.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCOptions) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCOptions) SetSecurityGroupIds(v []*string) *VPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCOptions) SetSubnetIds(v []*string) *VPCOptions {
	s.SubnetIds = v
	return s
}

// An exception for accessing or deleting a resource that doesn't exist.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A validation failure that occurred as the result of a pre-update validation
// check (verbose dry run) on a domain.
type ValidationFailure struct {
	_ struct{} `type:"structure"`

	// The error code of the failure.
	Code *string `type:"string"`

	// A message corresponding to the failure.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationFailure) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ValidationFailure) SetCode(v string) *ValidationFailure {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ValidationFailure) SetMessage(v string) *ValidationFailure {
	s.Message = &v
	return s
}

// The status of the the OpenSearch or Elasticsearch version options for the
// specified Amazon OpenSearch Service domain.
type VersionStatus struct {
	_ struct{} `type:"structure"`

	// The OpenSearch or Elasticsearch version for the specified domain.
	//
	// Options is a required field
	Options *string `min:"14" type:"string" required:"true"`

	// The status of the version options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *VersionStatus) SetOptions(v string) *VersionStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VersionStatus) SetStatus(v *OptionStatus) *VersionStatus {
	s.Status = v
	return s
}

// The connection endpoint for connecting to an Amazon OpenSearch Service domain
// through a proxy.
type VpcEndpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain associated with the endpoint.
	DomainArn *string `min:"1" type:"string"`

	// The connection endpoint ID for connecting to the domain.
	Endpoint *string `type:"string"`

	// The current status of the endpoint.
	Status *string `type:"string" enum:"VpcEndpointStatus"`

	// The unique identifier of the endpoint.
	VpcEndpointId *string `min:"5" type:"string"`

	// The creator of the endpoint.
	VpcEndpointOwner *string `type:"string"`

	// Options to specify the subnets and security groups for an Amazon OpenSearch
	// Service VPC endpoint.
	VpcOptions *VPCDerivedInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpoint) GoString() string {
	return s.String()
}

// SetDomainArn sets the DomainArn field's value.
func (s *VpcEndpoint) SetDomainArn(v string) *VpcEndpoint {
	s.DomainArn = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *VpcEndpoint) SetEndpoint(v string) *VpcEndpoint {
	s.Endpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VpcEndpoint) SetStatus(v string) *VpcEndpoint {
	s.Status = &v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *VpcEndpoint) SetVpcEndpointId(v string) *VpcEndpoint {
	s.VpcEndpointId = &v
	return s
}

// SetVpcEndpointOwner sets the VpcEndpointOwner field's value.
func (s *VpcEndpoint) SetVpcEndpointOwner(v string) *VpcEndpoint {
	s.VpcEndpointOwner = &v
	return s
}

// SetVpcOptions sets the VpcOptions field's value.
func (s *VpcEndpoint) SetVpcOptions(v *VPCDerivedInfo) *VpcEndpoint {
	s.VpcOptions = v
	return s
}

// Error information when attempting to describe an Amazon OpenSearch Service-managed
// VPC endpoint.
type VpcEndpointError struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	ErrorCode *string `type:"string" enum:"VpcEndpointErrorCode"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the endpoint.
	VpcEndpointId *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *VpcEndpointError) SetErrorCode(v string) *VpcEndpointError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *VpcEndpointError) SetErrorMessage(v string) *VpcEndpointError {
	s.ErrorMessage = &v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *VpcEndpointError) SetVpcEndpointId(v string) *VpcEndpointError {
	s.VpcEndpointId = &v
	return s
}

// Summary information for an Amazon OpenSearch Service-managed VPC endpoint.
type VpcEndpointSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain associated with the endpoint.
	DomainArn *string `min:"1" type:"string"`

	// The current status of the endpoint.
	Status *string `type:"string" enum:"VpcEndpointStatus"`

	// The unique identifier of the endpoint.
	VpcEndpointId *string `min:"5" type:"string"`

	// The creator of the endpoint.
	VpcEndpointOwner *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointSummary) GoString() string {
	return s.String()
}

// SetDomainArn sets the DomainArn field's value.
func (s *VpcEndpointSummary) SetDomainArn(v string) *VpcEndpointSummary {
	s.DomainArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VpcEndpointSummary) SetStatus(v string) *VpcEndpointSummary {
	s.Status = &v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *VpcEndpointSummary) SetVpcEndpointId(v string) *VpcEndpointSummary {
	s.VpcEndpointId = &v
	return s
}

// SetVpcEndpointOwner sets the VpcEndpointOwner field's value.
func (s *VpcEndpointSummary) SetVpcEndpointOwner(v string) *VpcEndpointSummary {
	s.VpcEndpointOwner = &v
	return s
}

// The desired start time for an off-peak maintenance window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html).
type WindowStartTime struct {
	_ struct{} `type:"structure"`

	// The start hour of the window in Coordinated Universal Time (UTC), using 24-hour
	// time. For example, 17 refers to 5:00 P.M. UTC.
	//
	// Hours is a required field
	Hours *int64 `type:"long" required:"true"`

	// The start minute of the window, in UTC.
	//
	// Minutes is a required field
	Minutes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WindowStartTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WindowStartTime) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WindowStartTime) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WindowStartTime"}
	if s.Hours == nil {
		invalidParams.Add(request.NewErrParamRequired("Hours"))
	}
	if s.Minutes == nil {
		invalidParams.Add(request.NewErrParamRequired("Minutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHours sets the Hours field's value.
func (s *WindowStartTime) SetHours(v int64) *WindowStartTime {
	s.Hours = &v
	return s
}

// SetMinutes sets the Minutes field's value.
func (s *WindowStartTime) SetMinutes(v int64) *WindowStartTime {
	s.Minutes = &v
	return s
}

// The zone awareness configuration for an Amazon OpenSearch Service domain.
type ZoneAwarenessConfig struct {
	_ struct{} `type:"structure"`

	// If you enabled multiple Availability Zones, this value is the number of zones
	// that you want the domain to use. Valid values are 2 and 3. If your domain
	// is provisioned within a VPC, this value be equal to number of subnets.
	AvailabilityZoneCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZoneAwarenessConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZoneAwarenessConfig) GoString() string {
	return s.String()
}

// SetAvailabilityZoneCount sets the AvailabilityZoneCount field's value.
func (s *ZoneAwarenessConfig) SetAvailabilityZoneCount(v int64) *ZoneAwarenessConfig {
	s.AvailabilityZoneCount = &v
	return s
}

const (
	// ActionSeverityHigh is a ActionSeverity enum value
	ActionSeverityHigh = "HIGH"

	// ActionSeverityMedium is a ActionSeverity enum value
	ActionSeverityMedium = "MEDIUM"

	// ActionSeverityLow is a ActionSeverity enum value
	ActionSeverityLow = "LOW"
)

// ActionSeverity_Values returns all elements of the ActionSeverity enum
func ActionSeverity_Values() []string {
	return []string{
		ActionSeverityHigh,
		ActionSeverityMedium,
		ActionSeverityLow,
	}
}

const (
	// ActionStatusPendingUpdate is a ActionStatus enum value
	ActionStatusPendingUpdate = "PENDING_UPDATE"

	// ActionStatusInProgress is a ActionStatus enum value
	ActionStatusInProgress = "IN_PROGRESS"

	// ActionStatusFailed is a ActionStatus enum value
	ActionStatusFailed = "FAILED"

	// ActionStatusCompleted is a ActionStatus enum value
	ActionStatusCompleted = "COMPLETED"

	// ActionStatusNotEligible is a ActionStatus enum value
	ActionStatusNotEligible = "NOT_ELIGIBLE"

	// ActionStatusEligible is a ActionStatus enum value
	ActionStatusEligible = "ELIGIBLE"
)

// ActionStatus_Values returns all elements of the ActionStatus enum
func ActionStatus_Values() []string {
	return []string{
		ActionStatusPendingUpdate,
		ActionStatusInProgress,
		ActionStatusFailed,
		ActionStatusCompleted,
		ActionStatusNotEligible,
		ActionStatusEligible,
	}
}

const (
	// ActionTypeServiceSoftwareUpdate is a ActionType enum value
	ActionTypeServiceSoftwareUpdate = "SERVICE_SOFTWARE_UPDATE"

	// ActionTypeJvmHeapSizeTuning is a ActionType enum value
	ActionTypeJvmHeapSizeTuning = "JVM_HEAP_SIZE_TUNING"

	// ActionTypeJvmYoungGenTuning is a ActionType enum value
	ActionTypeJvmYoungGenTuning = "JVM_YOUNG_GEN_TUNING"
)

// ActionType_Values returns all elements of the ActionType enum
func ActionType_Values() []string {
	return []string{
		ActionTypeServiceSoftwareUpdate,
		ActionTypeJvmHeapSizeTuning,
		ActionTypeJvmYoungGenTuning,
	}
}

// The Auto-Tune desired state. Valid values are ENABLED and DISABLED.
const (
	// AutoTuneDesiredStateEnabled is a AutoTuneDesiredState enum value
	AutoTuneDesiredStateEnabled = "ENABLED"

	// AutoTuneDesiredStateDisabled is a AutoTuneDesiredState enum value
	AutoTuneDesiredStateDisabled = "DISABLED"
)

// AutoTuneDesiredState_Values returns all elements of the AutoTuneDesiredState enum
func AutoTuneDesiredState_Values() []string {
	return []string{
		AutoTuneDesiredStateEnabled,
		AutoTuneDesiredStateDisabled,
	}
}

// The Auto-Tune state for the domain. For valid states see Auto-Tune for Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
const (
	// AutoTuneStateEnabled is a AutoTuneState enum value
	AutoTuneStateEnabled = "ENABLED"

	// AutoTuneStateDisabled is a AutoTuneState enum value
	AutoTuneStateDisabled = "DISABLED"

	// AutoTuneStateEnableInProgress is a AutoTuneState enum value
	AutoTuneStateEnableInProgress = "ENABLE_IN_PROGRESS"

	// AutoTuneStateDisableInProgress is a AutoTuneState enum value
	AutoTuneStateDisableInProgress = "DISABLE_IN_PROGRESS"

	// AutoTuneStateDisabledAndRollbackScheduled is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackScheduled = "DISABLED_AND_ROLLBACK_SCHEDULED"

	// AutoTuneStateDisabledAndRollbackInProgress is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackInProgress = "DISABLED_AND_ROLLBACK_IN_PROGRESS"

	// AutoTuneStateDisabledAndRollbackComplete is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackComplete = "DISABLED_AND_ROLLBACK_COMPLETE"

	// AutoTuneStateDisabledAndRollbackError is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackError = "DISABLED_AND_ROLLBACK_ERROR"

	// AutoTuneStateError is a AutoTuneState enum value
	AutoTuneStateError = "ERROR"
)

// AutoTuneState_Values returns all elements of the AutoTuneState enum
func AutoTuneState_Values() []string {
	return []string{
		AutoTuneStateEnabled,
		AutoTuneStateDisabled,
		AutoTuneStateEnableInProgress,
		AutoTuneStateDisableInProgress,
		AutoTuneStateDisabledAndRollbackScheduled,
		AutoTuneStateDisabledAndRollbackInProgress,
		AutoTuneStateDisabledAndRollbackComplete,
		AutoTuneStateDisabledAndRollbackError,
		AutoTuneStateError,
	}
}

// Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.
const (
	// AutoTuneTypeScheduledAction is a AutoTuneType enum value
	AutoTuneTypeScheduledAction = "SCHEDULED_ACTION"
)

// AutoTuneType_Values returns all elements of the AutoTuneType enum
func AutoTuneType_Values() []string {
	return []string{
		AutoTuneTypeScheduledAction,
	}
}

// The connection mode for the cross-cluster connection.
//
//   - DIRECT - Used for cross-cluster search or cross-cluster replication.
//
//   - VPC_ENDPOINT - Used for remote reindex between Amazon OpenSearch Service
//     VPC domains.
const (
	// ConnectionModeDirect is a ConnectionMode enum value
	ConnectionModeDirect = "DIRECT"

	// ConnectionModeVpcEndpoint is a ConnectionMode enum value
	ConnectionModeVpcEndpoint = "VPC_ENDPOINT"
)

// ConnectionMode_Values returns all elements of the ConnectionMode enum
func ConnectionMode_Values() []string {
	return []string{
		ConnectionModeDirect,
		ConnectionModeVpcEndpoint,
	}
}

const (
	// DeploymentStatusPendingUpdate is a DeploymentStatus enum value
	DeploymentStatusPendingUpdate = "PENDING_UPDATE"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "IN_PROGRESS"

	// DeploymentStatusCompleted is a DeploymentStatus enum value
	DeploymentStatusCompleted = "COMPLETED"

	// DeploymentStatusNotEligible is a DeploymentStatus enum value
	DeploymentStatusNotEligible = "NOT_ELIGIBLE"

	// DeploymentStatusEligible is a DeploymentStatus enum value
	DeploymentStatusEligible = "ELIGIBLE"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusPendingUpdate,
		DeploymentStatusInProgress,
		DeploymentStatusCompleted,
		DeploymentStatusNotEligible,
		DeploymentStatusEligible,
	}
}

const (
	// DescribePackagesFilterNamePackageId is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageId = "PackageID"

	// DescribePackagesFilterNamePackageName is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageName = "PackageName"

	// DescribePackagesFilterNamePackageStatus is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageStatus = "PackageStatus"

	// DescribePackagesFilterNamePackageType is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageType = "PackageType"

	// DescribePackagesFilterNameEngineVersion is a DescribePackagesFilterName enum value
	DescribePackagesFilterNameEngineVersion = "EngineVersion"
)

// DescribePackagesFilterName_Values returns all elements of the DescribePackagesFilterName enum
func DescribePackagesFilterName_Values() []string {
	return []string{
		DescribePackagesFilterNamePackageId,
		DescribePackagesFilterNamePackageName,
		DescribePackagesFilterNamePackageStatus,
		DescribePackagesFilterNamePackageType,
		DescribePackagesFilterNameEngineVersion,
	}
}

const (
	// DomainHealthRed is a DomainHealth enum value
	DomainHealthRed = "Red"

	// DomainHealthYellow is a DomainHealth enum value
	DomainHealthYellow = "Yellow"

	// DomainHealthGreen is a DomainHealth enum value
	DomainHealthGreen = "Green"

	// DomainHealthNotAvailable is a DomainHealth enum value
	DomainHealthNotAvailable = "NotAvailable"
)

// DomainHealth_Values returns all elements of the DomainHealth enum
func DomainHealth_Values() []string {
	return []string{
		DomainHealthRed,
		DomainHealthYellow,
		DomainHealthGreen,
		DomainHealthNotAvailable,
	}
}

const (
	// DomainPackageStatusAssociating is a DomainPackageStatus enum value
	DomainPackageStatusAssociating = "ASSOCIATING"

	// DomainPackageStatusAssociationFailed is a DomainPackageStatus enum value
	DomainPackageStatusAssociationFailed = "ASSOCIATION_FAILED"

	// DomainPackageStatusActive is a DomainPackageStatus enum value
	DomainPackageStatusActive = "ACTIVE"

	// DomainPackageStatusDissociating is a DomainPackageStatus enum value
	DomainPackageStatusDissociating = "DISSOCIATING"

	// DomainPackageStatusDissociationFailed is a DomainPackageStatus enum value
	DomainPackageStatusDissociationFailed = "DISSOCIATION_FAILED"
)

// DomainPackageStatus_Values returns all elements of the DomainPackageStatus enum
func DomainPackageStatus_Values() []string {
	return []string{
		DomainPackageStatusAssociating,
		DomainPackageStatusAssociationFailed,
		DomainPackageStatusActive,
		DomainPackageStatusDissociating,
		DomainPackageStatusDissociationFailed,
	}
}

const (
	// DomainStateActive is a DomainState enum value
	DomainStateActive = "Active"

	// DomainStateProcessing is a DomainState enum value
	DomainStateProcessing = "Processing"

	// DomainStateNotAvailable is a DomainState enum value
	DomainStateNotAvailable = "NotAvailable"
)

// DomainState_Values returns all elements of the DomainState enum
func DomainState_Values() []string {
	return []string{
		DomainStateActive,
		DomainStateProcessing,
		DomainStateNotAvailable,
	}
}

const (
	// DryRunModeBasic is a DryRunMode enum value
	DryRunModeBasic = "Basic"

	// DryRunModeVerbose is a DryRunMode enum value
	DryRunModeVerbose = "Verbose"
)

// DryRunMode_Values returns all elements of the DryRunMode enum
func DryRunMode_Values() []string {
	return []string{
		DryRunModeBasic,
		DryRunModeVerbose,
	}
}

const (
	// EngineTypeOpenSearch is a EngineType enum value
	EngineTypeOpenSearch = "OpenSearch"

	// EngineTypeElasticsearch is a EngineType enum value
	EngineTypeElasticsearch = "Elasticsearch"
)

// EngineType_Values returns all elements of the EngineType enum
func EngineType_Values() []string {
	return []string{
		EngineTypeOpenSearch,
		EngineTypeElasticsearch,
	}
}

const (
	// IPAddressTypeIpv4 is a IPAddressType enum value
	IPAddressTypeIpv4 = "ipv4"

	// IPAddressTypeDualstack is a IPAddressType enum value
	IPAddressTypeDualstack = "dualstack"
)

// IPAddressType_Values returns all elements of the IPAddressType enum
func IPAddressType_Values() []string {
	return []string{
		IPAddressTypeIpv4,
		IPAddressTypeDualstack,
	}
}

const (
	// InboundConnectionStatusCodePendingAcceptance is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodePendingAcceptance = "PENDING_ACCEPTANCE"

	// InboundConnectionStatusCodeApproved is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeApproved = "APPROVED"

	// InboundConnectionStatusCodeProvisioning is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeProvisioning = "PROVISIONING"

	// InboundConnectionStatusCodeActive is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeActive = "ACTIVE"

	// InboundConnectionStatusCodeRejecting is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeRejecting = "REJECTING"

	// InboundConnectionStatusCodeRejected is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeRejected = "REJECTED"

	// InboundConnectionStatusCodeDeleting is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeDeleting = "DELETING"

	// InboundConnectionStatusCodeDeleted is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeDeleted = "DELETED"
)

// InboundConnectionStatusCode_Values returns all elements of the InboundConnectionStatusCode enum
func InboundConnectionStatusCode_Values() []string {
	return []string{
		InboundConnectionStatusCodePendingAcceptance,
		InboundConnectionStatusCodeApproved,
		InboundConnectionStatusCodeProvisioning,
		InboundConnectionStatusCodeActive,
		InboundConnectionStatusCodeRejecting,
		InboundConnectionStatusCodeRejected,
		InboundConnectionStatusCodeDeleting,
		InboundConnectionStatusCodeDeleted,
	}
}

// The type of log file. Can be one of the following:
//
//   - INDEX_SLOW_LOGS - Index slow logs contain insert requests that took
//     more time than the configured index query log threshold to execute.
//
//   - SEARCH_SLOW_LOGS - Search slow logs contain search queries that took
//     more time than the configured search query log threshold to execute.
//
//   - ES_APPLICATION_LOGS - OpenSearch application logs contain information
//     about errors and warnings raised during the operation of the service and
//     can be useful for troubleshooting.
//
//   - AUDIT_LOGS - Audit logs contain records of user requests for access
//     to the domain.
const (
	// LogTypeIndexSlowLogs is a LogType enum value
	LogTypeIndexSlowLogs = "INDEX_SLOW_LOGS"

	// LogTypeSearchSlowLogs is a LogType enum value
	LogTypeSearchSlowLogs = "SEARCH_SLOW_LOGS"

	// LogTypeEsApplicationLogs is a LogType enum value
	LogTypeEsApplicationLogs = "ES_APPLICATION_LOGS"

	// LogTypeAuditLogs is a LogType enum value
	LogTypeAuditLogs = "AUDIT_LOGS"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeIndexSlowLogs,
		LogTypeSearchSlowLogs,
		LogTypeEsApplicationLogs,
		LogTypeAuditLogs,
	}
}

const (
	// MaintenanceStatusPending is a MaintenanceStatus enum value
	MaintenanceStatusPending = "PENDING"

	// MaintenanceStatusInProgress is a MaintenanceStatus enum value
	MaintenanceStatusInProgress = "IN_PROGRESS"

	// MaintenanceStatusCompleted is a MaintenanceStatus enum value
	MaintenanceStatusCompleted = "COMPLETED"

	// MaintenanceStatusFailed is a MaintenanceStatus enum value
	MaintenanceStatusFailed = "FAILED"

	// MaintenanceStatusTimedOut is a MaintenanceStatus enum value
	MaintenanceStatusTimedOut = "TIMED_OUT"
)

// MaintenanceStatus_Values returns all elements of the MaintenanceStatus enum
func MaintenanceStatus_Values() []string {
	return []string{
		MaintenanceStatusPending,
		MaintenanceStatusInProgress,
		MaintenanceStatusCompleted,
		MaintenanceStatusFailed,
		MaintenanceStatusTimedOut,
	}
}

const (
	// MaintenanceTypeRebootNode is a MaintenanceType enum value
	MaintenanceTypeRebootNode = "REBOOT_NODE"

	// MaintenanceTypeRestartSearchProcess is a MaintenanceType enum value
	MaintenanceTypeRestartSearchProcess = "RESTART_SEARCH_PROCESS"

	// MaintenanceTypeRestartDashboard is a MaintenanceType enum value
	MaintenanceTypeRestartDashboard = "RESTART_DASHBOARD"
)

// MaintenanceType_Values returns all elements of the MaintenanceType enum
func MaintenanceType_Values() []string {
	return []string{
		MaintenanceTypeRebootNode,
		MaintenanceTypeRestartSearchProcess,
		MaintenanceTypeRestartDashboard,
	}
}

const (
	// MasterNodeStatusAvailable is a MasterNodeStatus enum value
	MasterNodeStatusAvailable = "Available"

	// MasterNodeStatusUnAvailable is a MasterNodeStatus enum value
	MasterNodeStatusUnAvailable = "UnAvailable"
)

// MasterNodeStatus_Values returns all elements of the MasterNodeStatus enum
func MasterNodeStatus_Values() []string {
	return []string{
		MasterNodeStatusAvailable,
		MasterNodeStatusUnAvailable,
	}
}

const (
	// NodeStatusActive is a NodeStatus enum value
	NodeStatusActive = "Active"

	// NodeStatusStandBy is a NodeStatus enum value
	NodeStatusStandBy = "StandBy"

	// NodeStatusNotAvailable is a NodeStatus enum value
	NodeStatusNotAvailable = "NotAvailable"
)

// NodeStatus_Values returns all elements of the NodeStatus enum
func NodeStatus_Values() []string {
	return []string{
		NodeStatusActive,
		NodeStatusStandBy,
		NodeStatusNotAvailable,
	}
}

const (
	// NodeTypeData is a NodeType enum value
	NodeTypeData = "Data"

	// NodeTypeUltrawarm is a NodeType enum value
	NodeTypeUltrawarm = "Ultrawarm"

	// NodeTypeMaster is a NodeType enum value
	NodeTypeMaster = "Master"
)

// NodeType_Values returns all elements of the NodeType enum
func NodeType_Values() []string {
	return []string{
		NodeTypeData,
		NodeTypeUltrawarm,
		NodeTypeMaster,
	}
}

const (
	// OpenSearchPartitionInstanceTypeM3MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM3MediumSearch = "m3.medium.search"

	// OpenSearchPartitionInstanceTypeM3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM3LargeSearch = "m3.large.search"

	// OpenSearchPartitionInstanceTypeM3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM3XlargeSearch = "m3.xlarge.search"

	// OpenSearchPartitionInstanceTypeM32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM32xlargeSearch = "m3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM4LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM4LargeSearch = "m4.large.search"

	// OpenSearchPartitionInstanceTypeM4XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM4XlargeSearch = "m4.xlarge.search"

	// OpenSearchPartitionInstanceTypeM42xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM42xlargeSearch = "m4.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM44xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM44xlargeSearch = "m4.4xlarge.search"

	// OpenSearchPartitionInstanceTypeM410xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM410xlargeSearch = "m4.10xlarge.search"

	// OpenSearchPartitionInstanceTypeM5LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM5LargeSearch = "m5.large.search"

	// OpenSearchPartitionInstanceTypeM5XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM5XlargeSearch = "m5.xlarge.search"

	// OpenSearchPartitionInstanceTypeM52xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM52xlargeSearch = "m5.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM54xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM54xlargeSearch = "m5.4xlarge.search"

	// OpenSearchPartitionInstanceTypeM512xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM512xlargeSearch = "m5.12xlarge.search"

	// OpenSearchPartitionInstanceTypeM524xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM524xlargeSearch = "m5.24xlarge.search"

	// OpenSearchPartitionInstanceTypeR5LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR5LargeSearch = "r5.large.search"

	// OpenSearchPartitionInstanceTypeR5XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR5XlargeSearch = "r5.xlarge.search"

	// OpenSearchPartitionInstanceTypeR52xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR52xlargeSearch = "r5.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR54xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR54xlargeSearch = "r5.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR512xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR512xlargeSearch = "r5.12xlarge.search"

	// OpenSearchPartitionInstanceTypeR524xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR524xlargeSearch = "r5.24xlarge.search"

	// OpenSearchPartitionInstanceTypeC5LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC5LargeSearch = "c5.large.search"

	// OpenSearchPartitionInstanceTypeC5XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC5XlargeSearch = "c5.xlarge.search"

	// OpenSearchPartitionInstanceTypeC52xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC52xlargeSearch = "c5.2xlarge.search"

	// OpenSearchPartitionInstanceTypeC54xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC54xlargeSearch = "c5.4xlarge.search"

	// OpenSearchPartitionInstanceTypeC59xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC59xlargeSearch = "c5.9xlarge.search"

	// OpenSearchPartitionInstanceTypeC518xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC518xlargeSearch = "c5.18xlarge.search"

	// OpenSearchPartitionInstanceTypeT3NanoSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3NanoSearch = "t3.nano.search"

	// OpenSearchPartitionInstanceTypeT3MicroSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3MicroSearch = "t3.micro.search"

	// OpenSearchPartitionInstanceTypeT3SmallSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3SmallSearch = "t3.small.search"

	// OpenSearchPartitionInstanceTypeT3MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3MediumSearch = "t3.medium.search"

	// OpenSearchPartitionInstanceTypeT3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3LargeSearch = "t3.large.search"

	// OpenSearchPartitionInstanceTypeT3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3XlargeSearch = "t3.xlarge.search"

	// OpenSearchPartitionInstanceTypeT32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT32xlargeSearch = "t3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeUltrawarm1MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeUltrawarm1MediumSearch = "ultrawarm1.medium.search"

	// OpenSearchPartitionInstanceTypeUltrawarm1LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeUltrawarm1LargeSearch = "ultrawarm1.large.search"

	// OpenSearchPartitionInstanceTypeUltrawarm1XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeUltrawarm1XlargeSearch = "ultrawarm1.xlarge.search"

	// OpenSearchPartitionInstanceTypeT2MicroSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT2MicroSearch = "t2.micro.search"

	// OpenSearchPartitionInstanceTypeT2SmallSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT2SmallSearch = "t2.small.search"

	// OpenSearchPartitionInstanceTypeT2MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT2MediumSearch = "t2.medium.search"

	// OpenSearchPartitionInstanceTypeR3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR3LargeSearch = "r3.large.search"

	// OpenSearchPartitionInstanceTypeR3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR3XlargeSearch = "r3.xlarge.search"

	// OpenSearchPartitionInstanceTypeR32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR32xlargeSearch = "r3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR34xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR34xlargeSearch = "r3.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR38xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR38xlargeSearch = "r3.8xlarge.search"

	// OpenSearchPartitionInstanceTypeI2XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI2XlargeSearch = "i2.xlarge.search"

	// OpenSearchPartitionInstanceTypeI22xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI22xlargeSearch = "i2.2xlarge.search"

	// OpenSearchPartitionInstanceTypeD2XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD2XlargeSearch = "d2.xlarge.search"

	// OpenSearchPartitionInstanceTypeD22xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD22xlargeSearch = "d2.2xlarge.search"

	// OpenSearchPartitionInstanceTypeD24xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD24xlargeSearch = "d2.4xlarge.search"

	// OpenSearchPartitionInstanceTypeD28xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD28xlargeSearch = "d2.8xlarge.search"

	// OpenSearchPartitionInstanceTypeC4LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC4LargeSearch = "c4.large.search"

	// OpenSearchPartitionInstanceTypeC4XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC4XlargeSearch = "c4.xlarge.search"

	// OpenSearchPartitionInstanceTypeC42xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC42xlargeSearch = "c4.2xlarge.search"

	// OpenSearchPartitionInstanceTypeC44xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC44xlargeSearch = "c4.4xlarge.search"

	// OpenSearchPartitionInstanceTypeC48xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC48xlargeSearch = "c4.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR4LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR4LargeSearch = "r4.large.search"

	// OpenSearchPartitionInstanceTypeR4XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR4XlargeSearch = "r4.xlarge.search"

	// OpenSearchPartitionInstanceTypeR42xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR42xlargeSearch = "r4.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR44xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR44xlargeSearch = "r4.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR48xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR48xlargeSearch = "r4.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR416xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR416xlargeSearch = "r4.16xlarge.search"

	// OpenSearchPartitionInstanceTypeI3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI3LargeSearch = "i3.large.search"

	// OpenSearchPartitionInstanceTypeI3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI3XlargeSearch = "i3.xlarge.search"

	// OpenSearchPartitionInstanceTypeI32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI32xlargeSearch = "i3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeI34xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI34xlargeSearch = "i3.4xlarge.search"

	// OpenSearchPartitionInstanceTypeI38xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI38xlargeSearch = "i3.8xlarge.search"

	// OpenSearchPartitionInstanceTypeI316xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI316xlargeSearch = "i3.16xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gLargeSearch = "r6g.large.search"

	// OpenSearchPartitionInstanceTypeR6gXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gXlargeSearch = "r6g.xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g2xlargeSearch = "r6g.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g4xlargeSearch = "r6g.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g8xlargeSearch = "r6g.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g12xlargeSearch = "r6g.12xlarge.search"

	// OpenSearchPartitionInstanceTypeM6gLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6gLargeSearch = "m6g.large.search"

	// OpenSearchPartitionInstanceTypeM6gXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6gXlargeSearch = "m6g.xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g2xlargeSearch = "m6g.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g4xlargeSearch = "m6g.4xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g8xlargeSearch = "m6g.8xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g12xlargeSearch = "m6g.12xlarge.search"

	// OpenSearchPartitionInstanceTypeC6gLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6gLargeSearch = "c6g.large.search"

	// OpenSearchPartitionInstanceTypeC6gXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6gXlargeSearch = "c6g.xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g2xlargeSearch = "c6g.2xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g4xlargeSearch = "c6g.4xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g8xlargeSearch = "c6g.8xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g12xlargeSearch = "c6g.12xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gdLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gdLargeSearch = "r6gd.large.search"

	// OpenSearchPartitionInstanceTypeR6gdXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gdXlargeSearch = "r6gd.xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd2xlargeSearch = "r6gd.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd4xlargeSearch = "r6gd.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd8xlargeSearch = "r6gd.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd12xlargeSearch = "r6gd.12xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd16xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd16xlargeSearch = "r6gd.16xlarge.search"

	// OpenSearchPartitionInstanceTypeT4gSmallSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT4gSmallSearch = "t4g.small.search"

	// OpenSearchPartitionInstanceTypeT4gMediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT4gMediumSearch = "t4g.medium.search"
)

// OpenSearchPartitionInstanceType_Values returns all elements of the OpenSearchPartitionInstanceType enum
func OpenSearchPartitionInstanceType_Values() []string {
	return []string{
		OpenSearchPartitionInstanceTypeM3MediumSearch,
		OpenSearchPartitionInstanceTypeM3LargeSearch,
		OpenSearchPartitionInstanceTypeM3XlargeSearch,
		OpenSearchPartitionInstanceTypeM32xlargeSearch,
		OpenSearchPartitionInstanceTypeM4LargeSearch,
		OpenSearchPartitionInstanceTypeM4XlargeSearch,
		OpenSearchPartitionInstanceTypeM42xlargeSearch,
		OpenSearchPartitionInstanceTypeM44xlargeSearch,
		OpenSearchPartitionInstanceTypeM410xlargeSearch,
		OpenSearchPartitionInstanceTypeM5LargeSearch,
		OpenSearchPartitionInstanceTypeM5XlargeSearch,
		OpenSearchPartitionInstanceTypeM52xlargeSearch,
		OpenSearchPartitionInstanceTypeM54xlargeSearch,
		OpenSearchPartitionInstanceTypeM512xlargeSearch,
		OpenSearchPartitionInstanceTypeM524xlargeSearch,
		OpenSearchPartitionInstanceTypeR5LargeSearch,
		OpenSearchPartitionInstanceTypeR5XlargeSearch,
		OpenSearchPartitionInstanceTypeR52xlargeSearch,
		OpenSearchPartitionInstanceTypeR54xlargeSearch,
		OpenSearchPartitionInstanceTypeR512xlargeSearch,
		OpenSearchPartitionInstanceTypeR524xlargeSearch,
		OpenSearchPartitionInstanceTypeC5LargeSearch,
		OpenSearchPartitionInstanceTypeC5XlargeSearch,
		OpenSearchPartitionInstanceTypeC52xlargeSearch,
		OpenSearchPartitionInstanceTypeC54xlargeSearch,
		OpenSearchPartitionInstanceTypeC59xlargeSearch,
		OpenSearchPartitionInstanceTypeC518xlargeSearch,
		OpenSearchPartitionInstanceTypeT3NanoSearch,
		OpenSearchPartitionInstanceTypeT3MicroSearch,
		OpenSearchPartitionInstanceTypeT3SmallSearch,
		OpenSearchPartitionInstanceTypeT3MediumSearch,
		OpenSearchPartitionInstanceTypeT3LargeSearch,
		OpenSearchPartitionInstanceTypeT3XlargeSearch,
		OpenSearchPartitionInstanceTypeT32xlargeSearch,
		OpenSearchPartitionInstanceTypeUltrawarm1MediumSearch,
		OpenSearchPartitionInstanceTypeUltrawarm1LargeSearch,
		OpenSearchPartitionInstanceTypeUltrawarm1XlargeSearch,
		OpenSearchPartitionInstanceTypeT2MicroSearch,
		OpenSearchPartitionInstanceTypeT2SmallSearch,
		OpenSearchPartitionInstanceTypeT2MediumSearch,
		OpenSearchPartitionInstanceTypeR3LargeSearch,
		OpenSearchPartitionInstanceTypeR3XlargeSearch,
		OpenSearchPartitionInstanceTypeR32xlargeSearch,
		OpenSearchPartitionInstanceTypeR34xlargeSearch,
		OpenSearchPartitionInstanceTypeR38xlargeSearch,
		OpenSearchPartitionInstanceTypeI2XlargeSearch,
		OpenSearchPartitionInstanceTypeI22xlargeSearch,
		OpenSearchPartitionInstanceTypeD2XlargeSearch,
		OpenSearchPartitionInstanceTypeD22xlargeSearch,
		OpenSearchPartitionInstanceTypeD24xlargeSearch,
		OpenSearchPartitionInstanceTypeD28xlargeSearch,
		OpenSearchPartitionInstanceTypeC4LargeSearch,
		OpenSearchPartitionInstanceTypeC4XlargeSearch,
		OpenSearchPartitionInstanceTypeC42xlargeSearch,
		OpenSearchPartitionInstanceTypeC44xlargeSearch,
		OpenSearchPartitionInstanceTypeC48xlargeSearch,
		OpenSearchPartitionInstanceTypeR4LargeSearch,
		OpenSearchPartitionInstanceTypeR4XlargeSearch,
		OpenSearchPartitionInstanceTypeR42xlargeSearch,
		OpenSearchPartitionInstanceTypeR44xlargeSearch,
		OpenSearchPartitionInstanceTypeR48xlargeSearch,
		OpenSearchPartitionInstanceTypeR416xlargeSearch,
		OpenSearchPartitionInstanceTypeI3LargeSearch,
		OpenSearchPartitionInstanceTypeI3XlargeSearch,
		OpenSearchPartitionInstanceTypeI32xlargeSearch,
		OpenSearchPartitionInstanceTypeI34xlargeSearch,
		OpenSearchPartitionInstanceTypeI38xlargeSearch,
		OpenSearchPartitionInstanceTypeI316xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gLargeSearch,
		OpenSearchPartitionInstanceTypeR6gXlargeSearch,
		OpenSearchPartitionInstanceTypeR6g2xlargeSearch,
		OpenSearchPartitionInstanceTypeR6g4xlargeSearch,
		OpenSearchPartitionInstanceTypeR6g8xlargeSearch,
		OpenSearchPartitionInstanceTypeR6g12xlargeSearch,
		OpenSearchPartitionInstanceTypeM6gLargeSearch,
		OpenSearchPartitionInstanceTypeM6gXlargeSearch,
		OpenSearchPartitionInstanceTypeM6g2xlargeSearch,
		OpenSearchPartitionInstanceTypeM6g4xlargeSearch,
		OpenSearchPartitionInstanceTypeM6g8xlargeSearch,
		OpenSearchPartitionInstanceTypeM6g12xlargeSearch,
		OpenSearchPartitionInstanceTypeC6gLargeSearch,
		OpenSearchPartitionInstanceTypeC6gXlargeSearch,
		OpenSearchPartitionInstanceTypeC6g2xlargeSearch,
		OpenSearchPartitionInstanceTypeC6g4xlargeSearch,
		OpenSearchPartitionInstanceTypeC6g8xlargeSearch,
		OpenSearchPartitionInstanceTypeC6g12xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gdLargeSearch,
		OpenSearchPartitionInstanceTypeR6gdXlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd2xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd4xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd8xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd12xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd16xlargeSearch,
		OpenSearchPartitionInstanceTypeT4gSmallSearch,
		OpenSearchPartitionInstanceTypeT4gMediumSearch,
	}
}

const (
	// OpenSearchWarmPartitionInstanceTypeUltrawarm1MediumSearch is a OpenSearchWarmPartitionInstanceType enum value
	OpenSearchWarmPartitionInstanceTypeUltrawarm1MediumSearch = "ultrawarm1.medium.search"

	// OpenSearchWarmPartitionInstanceTypeUltrawarm1LargeSearch is a OpenSearchWarmPartitionInstanceType enum value
	OpenSearchWarmPartitionInstanceTypeUltrawarm1LargeSearch = "ultrawarm1.large.search"

	// OpenSearchWarmPartitionInstanceTypeUltrawarm1XlargeSearch is a OpenSearchWarmPartitionInstanceType enum value
	OpenSearchWarmPartitionInstanceTypeUltrawarm1XlargeSearch = "ultrawarm1.xlarge.search"
)

// OpenSearchWarmPartitionInstanceType_Values returns all elements of the OpenSearchWarmPartitionInstanceType enum
func OpenSearchWarmPartitionInstanceType_Values() []string {
	return []string{
		OpenSearchWarmPartitionInstanceTypeUltrawarm1MediumSearch,
		OpenSearchWarmPartitionInstanceTypeUltrawarm1LargeSearch,
		OpenSearchWarmPartitionInstanceTypeUltrawarm1XlargeSearch,
	}
}

// The state of a requested domain configuration change. Can be one of the following:
//
//   - Processing - The requested change is still in progress.
//
//   - Active - The requested change is processed and deployed to the domain.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"
)

// OptionState_Values returns all elements of the OptionState enum
func OptionState_Values() []string {
	return []string{
		OptionStateRequiresIndexDocuments,
		OptionStateProcessing,
		OptionStateActive,
	}
}

const (
	// OutboundConnectionStatusCodeValidating is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeValidating = "VALIDATING"

	// OutboundConnectionStatusCodeValidationFailed is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeValidationFailed = "VALIDATION_FAILED"

	// OutboundConnectionStatusCodePendingAcceptance is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodePendingAcceptance = "PENDING_ACCEPTANCE"

	// OutboundConnectionStatusCodeApproved is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeApproved = "APPROVED"

	// OutboundConnectionStatusCodeProvisioning is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeProvisioning = "PROVISIONING"

	// OutboundConnectionStatusCodeActive is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeActive = "ACTIVE"

	// OutboundConnectionStatusCodeRejecting is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeRejecting = "REJECTING"

	// OutboundConnectionStatusCodeRejected is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeRejected = "REJECTED"

	// OutboundConnectionStatusCodeDeleting is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeDeleting = "DELETING"

	// OutboundConnectionStatusCodeDeleted is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeDeleted = "DELETED"
)

// OutboundConnectionStatusCode_Values returns all elements of the OutboundConnectionStatusCode enum
func OutboundConnectionStatusCode_Values() []string {
	return []string{
		OutboundConnectionStatusCodeValidating,
		OutboundConnectionStatusCodeValidationFailed,
		OutboundConnectionStatusCodePendingAcceptance,
		OutboundConnectionStatusCodeApproved,
		OutboundConnectionStatusCodeProvisioning,
		OutboundConnectionStatusCodeActive,
		OutboundConnectionStatusCodeRejecting,
		OutboundConnectionStatusCodeRejected,
		OutboundConnectionStatusCodeDeleting,
		OutboundConnectionStatusCodeDeleted,
	}
}

// The overall status value of the domain configuration change.
const (
	// OverallChangeStatusPending is a OverallChangeStatus enum value
	OverallChangeStatusPending = "PENDING"

	// OverallChangeStatusProcessing is a OverallChangeStatus enum value
	OverallChangeStatusProcessing = "PROCESSING"

	// OverallChangeStatusCompleted is a OverallChangeStatus enum value
	OverallChangeStatusCompleted = "COMPLETED"

	// OverallChangeStatusFailed is a OverallChangeStatus enum value
	OverallChangeStatusFailed = "FAILED"
)

// OverallChangeStatus_Values returns all elements of the OverallChangeStatus enum
func OverallChangeStatus_Values() []string {
	return []string{
		OverallChangeStatusPending,
		OverallChangeStatusProcessing,
		OverallChangeStatusCompleted,
		OverallChangeStatusFailed,
	}
}

const (
	// PackageStatusCopying is a PackageStatus enum value
	PackageStatusCopying = "COPYING"

	// PackageStatusCopyFailed is a PackageStatus enum value
	PackageStatusCopyFailed = "COPY_FAILED"

	// PackageStatusValidating is a PackageStatus enum value
	PackageStatusValidating = "VALIDATING"

	// PackageStatusValidationFailed is a PackageStatus enum value
	PackageStatusValidationFailed = "VALIDATION_FAILED"

	// PackageStatusAvailable is a PackageStatus enum value
	PackageStatusAvailable = "AVAILABLE"

	// PackageStatusDeleting is a PackageStatus enum value
	PackageStatusDeleting = "DELETING"

	// PackageStatusDeleted is a PackageStatus enum value
	PackageStatusDeleted = "DELETED"

	// PackageStatusDeleteFailed is a PackageStatus enum value
	PackageStatusDeleteFailed = "DELETE_FAILED"
)

// PackageStatus_Values returns all elements of the PackageStatus enum
func PackageStatus_Values() []string {
	return []string{
		PackageStatusCopying,
		PackageStatusCopyFailed,
		PackageStatusValidating,
		PackageStatusValidationFailed,
		PackageStatusAvailable,
		PackageStatusDeleting,
		PackageStatusDeleted,
		PackageStatusDeleteFailed,
	}
}

const (
	// PackageTypeTxtDictionary is a PackageType enum value
	PackageTypeTxtDictionary = "TXT-DICTIONARY"

	// PackageTypeZipPlugin is a PackageType enum value
	PackageTypeZipPlugin = "ZIP-PLUGIN"
)

// PackageType_Values returns all elements of the PackageType enum
func PackageType_Values() []string {
	return []string{
		PackageTypeTxtDictionary,
		PackageTypeZipPlugin,
	}
}

const (
	// PrincipalTypeAwsAccount is a PrincipalType enum value
	PrincipalTypeAwsAccount = "AWS_ACCOUNT"

	// PrincipalTypeAwsService is a PrincipalType enum value
	PrincipalTypeAwsService = "AWS_SERVICE"
)

// PrincipalType_Values returns all elements of the PrincipalType enum
func PrincipalType_Values() []string {
	return []string{
		PrincipalTypeAwsAccount,
		PrincipalTypeAwsService,
	}
}

const (
	// ReservedInstancePaymentOptionAllUpfront is a ReservedInstancePaymentOption enum value
	ReservedInstancePaymentOptionAllUpfront = "ALL_UPFRONT"

	// ReservedInstancePaymentOptionPartialUpfront is a ReservedInstancePaymentOption enum value
	ReservedInstancePaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// ReservedInstancePaymentOptionNoUpfront is a ReservedInstancePaymentOption enum value
	ReservedInstancePaymentOptionNoUpfront = "NO_UPFRONT"
)

// ReservedInstancePaymentOption_Values returns all elements of the ReservedInstancePaymentOption enum
func ReservedInstancePaymentOption_Values() []string {
	return []string{
		ReservedInstancePaymentOptionAllUpfront,
		ReservedInstancePaymentOptionPartialUpfront,
		ReservedInstancePaymentOptionNoUpfront,
	}
}

// The rollback state while disabling Auto-Tune for the domain.
const (
	// RollbackOnDisableNoRollback is a RollbackOnDisable enum value
	RollbackOnDisableNoRollback = "NO_ROLLBACK"

	// RollbackOnDisableDefaultRollback is a RollbackOnDisable enum value
	RollbackOnDisableDefaultRollback = "DEFAULT_ROLLBACK"
)

// RollbackOnDisable_Values returns all elements of the RollbackOnDisable enum
func RollbackOnDisable_Values() []string {
	return []string{
		RollbackOnDisableNoRollback,
		RollbackOnDisableDefaultRollback,
	}
}

const (
	// ScheduleAtNow is a ScheduleAt enum value
	ScheduleAtNow = "NOW"

	// ScheduleAtTimestamp is a ScheduleAt enum value
	ScheduleAtTimestamp = "TIMESTAMP"

	// ScheduleAtOffPeakWindow is a ScheduleAt enum value
	ScheduleAtOffPeakWindow = "OFF_PEAK_WINDOW"
)

// ScheduleAt_Values returns all elements of the ScheduleAt enum
func ScheduleAt_Values() []string {
	return []string{
		ScheduleAtNow,
		ScheduleAtTimestamp,
		ScheduleAtOffPeakWindow,
	}
}

// The Auto-Tune action type.
const (
	// ScheduledAutoTuneActionTypeJvmHeapSizeTuning is a ScheduledAutoTuneActionType enum value
	ScheduledAutoTuneActionTypeJvmHeapSizeTuning = "JVM_HEAP_SIZE_TUNING"

	// ScheduledAutoTuneActionTypeJvmYoungGenTuning is a ScheduledAutoTuneActionType enum value
	ScheduledAutoTuneActionTypeJvmYoungGenTuning = "JVM_YOUNG_GEN_TUNING"
)

// ScheduledAutoTuneActionType_Values returns all elements of the ScheduledAutoTuneActionType enum
func ScheduledAutoTuneActionType_Values() []string {
	return []string{
		ScheduledAutoTuneActionTypeJvmHeapSizeTuning,
		ScheduledAutoTuneActionTypeJvmYoungGenTuning,
	}
}

// The Auto-Tune action severity.
const (
	// ScheduledAutoTuneSeverityTypeLow is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeLow = "LOW"

	// ScheduledAutoTuneSeverityTypeMedium is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeMedium = "MEDIUM"

	// ScheduledAutoTuneSeverityTypeHigh is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeHigh = "HIGH"
)

// ScheduledAutoTuneSeverityType_Values returns all elements of the ScheduledAutoTuneSeverityType enum
func ScheduledAutoTuneSeverityType_Values() []string {
	return []string{
		ScheduledAutoTuneSeverityTypeLow,
		ScheduledAutoTuneSeverityTypeMedium,
		ScheduledAutoTuneSeverityTypeHigh,
	}
}

const (
	// ScheduledByCustomer is a ScheduledBy enum value
	ScheduledByCustomer = "CUSTOMER"

	// ScheduledBySystem is a ScheduledBy enum value
	ScheduledBySystem = "SYSTEM"
)

// ScheduledBy_Values returns all elements of the ScheduledBy enum
func ScheduledBy_Values() []string {
	return []string{
		ScheduledByCustomer,
		ScheduledBySystem,
	}
}

// The status of SkipUnavailable setting for the outbound connection.
//
//   - ENABLED - The SkipUnavailable setting is enabled for the connection.
//
//   - DISABLED - The SkipUnavailable setting is disabled for the connection.
const (
	// SkipUnavailableStatusEnabled is a SkipUnavailableStatus enum value
	SkipUnavailableStatusEnabled = "ENABLED"

	// SkipUnavailableStatusDisabled is a SkipUnavailableStatus enum value
	SkipUnavailableStatusDisabled = "DISABLED"
)

// SkipUnavailableStatus_Values returns all elements of the SkipUnavailableStatus enum
func SkipUnavailableStatus_Values() []string {
	return []string{
		SkipUnavailableStatusEnabled,
		SkipUnavailableStatusDisabled,
	}
}

const (
	// TLSSecurityPolicyPolicyMinTls10201907 is a TLSSecurityPolicy enum value
	TLSSecurityPolicyPolicyMinTls10201907 = "Policy-Min-TLS-1-0-2019-07"

	// TLSSecurityPolicyPolicyMinTls12201907 is a TLSSecurityPolicy enum value
	TLSSecurityPolicyPolicyMinTls12201907 = "Policy-Min-TLS-1-2-2019-07"
)

// TLSSecurityPolicy_Values returns all elements of the TLSSecurityPolicy enum
func TLSSecurityPolicy_Values() []string {
	return []string{
		TLSSecurityPolicyPolicyMinTls10201907,
		TLSSecurityPolicyPolicyMinTls12201907,
	}
}

// The unit of a maintenance schedule duration. Valid value is HOUR.
const (
	// TimeUnitHours is a TimeUnit enum value
	TimeUnitHours = "HOURS"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitHours,
	}
}

const (
	// UpgradeStatusInProgress is a UpgradeStatus enum value
	UpgradeStatusInProgress = "IN_PROGRESS"

	// UpgradeStatusSucceeded is a UpgradeStatus enum value
	UpgradeStatusSucceeded = "SUCCEEDED"

	// UpgradeStatusSucceededWithIssues is a UpgradeStatus enum value
	UpgradeStatusSucceededWithIssues = "SUCCEEDED_WITH_ISSUES"

	// UpgradeStatusFailed is a UpgradeStatus enum value
	UpgradeStatusFailed = "FAILED"
)

// UpgradeStatus_Values returns all elements of the UpgradeStatus enum
func UpgradeStatus_Values() []string {
	return []string{
		UpgradeStatusInProgress,
		UpgradeStatusSucceeded,
		UpgradeStatusSucceededWithIssues,
		UpgradeStatusFailed,
	}
}

const (
	// UpgradeStepPreUpgradeCheck is a UpgradeStep enum value
	UpgradeStepPreUpgradeCheck = "PRE_UPGRADE_CHECK"

	// UpgradeStepSnapshot is a UpgradeStep enum value
	UpgradeStepSnapshot = "SNAPSHOT"

	// UpgradeStepUpgrade is a UpgradeStep enum value
	UpgradeStepUpgrade = "UPGRADE"
)

// UpgradeStep_Values returns all elements of the UpgradeStep enum
func UpgradeStep_Values() []string {
	return []string{
		UpgradeStepPreUpgradeCheck,
		UpgradeStepSnapshot,
		UpgradeStepUpgrade,
	}
}

// The type of EBS volume that a domain uses. For more information, see Configuring
// EBS-based storage (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-createupdatedomains.html#opensearch-createdomain-configure-ebs).
const (
	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"

	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"

	// VolumeTypeGp3 is a VolumeType enum value
	VolumeTypeGp3 = "gp3"
)

// VolumeType_Values returns all elements of the VolumeType enum
func VolumeType_Values() []string {
	return []string{
		VolumeTypeStandard,
		VolumeTypeGp2,
		VolumeTypeIo1,
		VolumeTypeGp3,
	}
}

const (
	// VpcEndpointErrorCodeEndpointNotFound is a VpcEndpointErrorCode enum value
	VpcEndpointErrorCodeEndpointNotFound = "ENDPOINT_NOT_FOUND"

	// VpcEndpointErrorCodeServerError is a VpcEndpointErrorCode enum value
	VpcEndpointErrorCodeServerError = "SERVER_ERROR"
)

// VpcEndpointErrorCode_Values returns all elements of the VpcEndpointErrorCode enum
func VpcEndpointErrorCode_Values() []string {
	return []string{
		VpcEndpointErrorCodeEndpointNotFound,
		VpcEndpointErrorCodeServerError,
	}
}

const (
	// VpcEndpointStatusCreating is a VpcEndpointStatus enum value
	VpcEndpointStatusCreating = "CREATING"

	// VpcEndpointStatusCreateFailed is a VpcEndpointStatus enum value
	VpcEndpointStatusCreateFailed = "CREATE_FAILED"

	// VpcEndpointStatusActive is a VpcEndpointStatus enum value
	VpcEndpointStatusActive = "ACTIVE"

	// VpcEndpointStatusUpdating is a VpcEndpointStatus enum value
	VpcEndpointStatusUpdating = "UPDATING"

	// VpcEndpointStatusUpdateFailed is a VpcEndpointStatus enum value
	VpcEndpointStatusUpdateFailed = "UPDATE_FAILED"

	// VpcEndpointStatusDeleting is a VpcEndpointStatus enum value
	VpcEndpointStatusDeleting = "DELETING"

	// VpcEndpointStatusDeleteFailed is a VpcEndpointStatus enum value
	VpcEndpointStatusDeleteFailed = "DELETE_FAILED"
)

// VpcEndpointStatus_Values returns all elements of the VpcEndpointStatus enum
func VpcEndpointStatus_Values() []string {
	return []string{
		VpcEndpointStatusCreating,
		VpcEndpointStatusCreateFailed,
		VpcEndpointStatusActive,
		VpcEndpointStatusUpdating,
		VpcEndpointStatusUpdateFailed,
		VpcEndpointStatusDeleting,
		VpcEndpointStatusDeleteFailed,
	}
}

const (
	// ZoneStatusActive is a ZoneStatus enum value
	ZoneStatusActive = "Active"

	// ZoneStatusStandBy is a ZoneStatus enum value
	ZoneStatusStandBy = "StandBy"

	// ZoneStatusNotAvailable is a ZoneStatus enum value
	ZoneStatusNotAvailable = "NotAvailable"
)

// ZoneStatus_Values returns all elements of the ZoneStatus enum
func ZoneStatus_Values() []string {
	return []string{
		ZoneStatusActive,
		ZoneStatusStandBy,
		ZoneStatusNotAvailable,
	}
}
